/**********************************************************************
Copyright (c) 2004 IBM Corp. and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
    Luzius Meisser - Initial implementation
**********************************************************************/
package org.eclipse.ajdt.internal.ui.editor.contentassist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatusConstants;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jface.text.IDocument;

/**
 * Minimalistic implementation of a Compilation unit for .aj files.
 * To be used for code completion.
 * 
 * @author Luzius Meisser
 * 
 */
public class AJCompilationUnit extends org.eclipse.jdt.internal.core.CompilationUnit {
	
	private IFile ajFile;
	private IDocument doc;
	private boolean isWorkingCopy;
	private IBuffer myBuffer;
	private IJavaProject javaProject;
	
	protected AJCompilationUnit(IFile ajFile, IDocument openDocument) {
		super(getParent(ajFile), ajFile.getName(), DefaultWorkingCopyOwner.PRIMARY);
		this.ajFile = ajFile;
		doc = openDocument;
		isWorkingCopy = false;
	}
	
	static PackageFragment getParent(IFile ajFile){
		IJavaElement elem = JavaCore.create(ajFile.getParent());
		if (elem instanceof PackageFragmentRoot){
			//default package
			elem = ((PackageFragmentRoot)elem).getPackageFragment("");
		}
		if ((elem != null) && (elem instanceof PackageFragment)){
			return (PackageFragment)elem;
		}
		return null;
	}
	
	public IJavaProject getJavaProject(){
		if (javaProject == null){
			javaProject = JavaCore.create(ajFile.getProject());
		}
		return javaProject;
	}
	
	public char[] getContents(){
		try {
			return getBuffer().getCharacters();
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public String getMainTypeNameString(){
		String name = ajFile.getName();
		return name.substring(0, name.indexOf('.'));
	}

	public char[] getMainTypeName(){
		return getMainTypeNameString().toCharArray();
	}
	
	public char[] getFileName(){
		return ajFile.getName().toCharArray();
	}

	public ICompilationUnit getPrimary() {
		return this;
	}

	public IResource getResource() {
		return ajFile;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.core.IOpenable#getBuffer()
	 */
	public IBuffer getBuffer() throws JavaModelException {
		if (myBuffer == null){
			BufferManager bm = BufferManager.getDefaultBufferManager();
			myBuffer = bm.createBuffer(this);
			myBuffer.setContents(doc.get().toCharArray());
			//myBuffer.setContents(Util.getResourceContentsAsCharArray(ajFile));
		}
		return myBuffer;
	}

	public ICompilationUnit getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws JavaModelException {
		return this;
	}
	
	public void discardWorkingCopy(){
		//do nothing
	}

	public void codeComplete(int offset, ICompletionRequestor requestor,
			WorkingCopyOwner owner) throws JavaModelException {
		codeComplete(this, offset, requestor, owner);
	}

	public void codeComplete(int offset, CompletionRequestor requestor,
			WorkingCopyOwner owner) throws JavaModelException {
		codeComplete(this, offset, (ICompletionRequestor)requestor, owner);
	}
	
	protected void codeComplete(org.eclipse.jdt.internal.compiler.env.ICompilationUnit cu, int position, ICompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
		if (requestor == null) {
			throw new IllegalArgumentException("Completion requestor cannot be null"); //$NON-NLS-1$
		}
		IBuffer buffer = getBuffer();
		if (buffer == null) {
			return;
		}
		if (position < -1 || position > buffer.getLength()) {
			throw new JavaModelException(new JavaModelStatus(IJavaModelStatusConstants.INDEX_OUT_OF_BOUNDS));
		}
		JavaProject project = (JavaProject) getJavaProject();
	
		SearchableEnvironment environment = (SearchableEnvironment) project.newSearchableNameEnvironment(owner);

		// code complete
		CompletionRequestorWrapper requestorWrapper = new CompletionRequestorWrapper(requestor, environment.nameLookup);
		CompletionEngine engine = new CompletionEngine(environment, requestorWrapper, project.getOptions(true), project);
		requestorWrapper.completionEngine = engine;

		engine.complete(cu, position, 0);
	}
}
