/**********************************************************************
Copyright (c) 2004 IBM Corp. and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
    Luzius Meisser - Initial implementation
**********************************************************************/
package org.eclipse.ajdt.internal.ui.editor.contentassist;

import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * @author Luzius Meisser
 * 
 * Does not much yet... this would be the place to add additional
 * code completion proposals or filter them. 
 */
public class AJCompletionProcessor extends JavaCompletionProcessor {

	private IEditorPart fEditor;
	
	public AJCompletionProcessor(IEditorPart editor) {
		super(editor);
		fEditor = editor;
		IDocumentProvider provider = null;
		if (editor instanceof ITextEditor){
			provider = ((ITextEditor)editor).getDocumentProvider();
		}
		fManager = new WorkingCopyManagerForCompletionProcessor(fManager, provider);
	}
	
	public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
		IContextInformation[] result = super.computeContextInformation(viewer, offset);
		((WorkingCopyManagerForCompletionProcessor)fManager).discardWorkingCopy();
		return result;
	}
	
	public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
		ICompletionProposal[] props =  super.computeCompletionProposals(viewer, offset);
		((WorkingCopyManagerForCompletionProcessor)fManager).discardWorkingCopy();
		return props;
	}
}
