/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.examples;

import org.eclipse.ajdt.examples.AspectJExampleMessages;
import org.eclipse.ajdt.examples.AspectJExamplePlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AspectJExampleCreationWizardPage
extends WizardPage {
    private IStatus fCurrStatus = AspectJExampleCreationWizardPage.createStatus(0, "");
    private boolean fPageVisible;
    private IConfigurationElement fConfigurationElement;
    private String fNameLabel;
    private String fProjectName;
    private Text fTextControl;

    public AspectJExampleCreationWizardPage(int n, IConfigurationElement iConfigurationElement) {
        super("page" + n);
        this.fConfigurationElement = iConfigurationElement;
        this.setTitle(this.getAttribute(iConfigurationElement, "pagetitle"));
        this.setDescription(this.getAttribute(iConfigurationElement, "pagedescription"));
        this.fNameLabel = this.getAttribute(iConfigurationElement, "label");
        this.fProjectName = this.getAttribute(iConfigurationElement, "name");
    }

    private String getAttribute(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null) {
            return '!' + string + '!';
        }
        return string2;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(this.fNameLabel);
        label.setLayoutData((Object)new GridData());
        this.fTextControl = new Text(composite2, 2052);
        this.fTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (!AspectJExampleCreationWizardPage.this.fTextControl.isDisposed()) {
                    AspectJExampleCreationWizardPage.this.validateText(AspectJExampleCreationWizardPage.this.fTextControl.getText());
                }
            }
        });
        this.fTextControl.setText(this.fProjectName);
        this.fTextControl.setLayoutData((Object)new GridData(768));
        this.setControl((Control)composite2);
    }

    private void validateText(String string) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (iStatus.isOK() && iWorkspace.getRoot().getProject(string).exists()) {
            iStatus = AspectJExampleCreationWizardPage.createStatus(4, AspectJExampleMessages.getString("ExampleProjectCreationWizardPage.error.alreadyexists"));
        }
        this.updateStatus(iStatus);
        this.fProjectName = string;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fPageVisible = bl;
        if (!bl || this.fCurrStatus.matches(4)) {
            // empty if block
        }
        this.updateStatus(this.fCurrStatus);
    }

    private void updateStatus(IStatus iStatus) {
        this.fCurrStatus = iStatus;
        this.setPageComplete(!iStatus.matches(4));
        if (this.fPageVisible) {
            AspectJExampleCreationWizardPage.applyToStatusLine((DialogPage)this, iStatus);
        }
    }

    private static void applyToStatusLine(DialogPage dialogPage, IStatus iStatus) {
        String string = null;
        String string2 = null;
        String string3 = iStatus.getMessage();
        if (string3.length() > 0) {
            if (iStatus.matches(4)) {
                string = string3;
            } else if (!iStatus.isOK()) {
                string2 = string3;
            }
        }
        dialogPage.setErrorMessage(string);
        dialogPage.setMessage(string2);
    }

    private static IStatus createStatus(int n, String string) {
        return new Status(n, AspectJExamplePlugin.getPluginId(), n, string, null);
    }

    public String getName() {
        return this.fProjectName;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfigurationElement;
    }
}

