/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.util.ConfigParser;

class LstBuildConfigFileUpdater {
    LstBuildConfigFileUpdater() {
    }

    public void updateBuildConfigFile(String buildConfigFile, String update, boolean addToConfiguration) {
        List fileContents = this.readConfigFile(buildConfigFile);
        if (addToConfiguration) {
            fileContents.add(update);
        } else {
            fileContents.remove(update);
        }
        this.writeConfigFile(buildConfigFile, fileContents);
    }

    public void updateBuildConfigFiles(List buildConfigFiles, List filesToUpdate, boolean addToConfiguration) {
        for (int i = 0; i < buildConfigFiles.size(); ++i) {
            List fileContents = this.readConfigFile((String)buildConfigFiles.get(i));
            if (addToConfiguration) {
                for (int j = 0; j < filesToUpdate.size(); ++j) {
                    fileContents.add(filesToUpdate.get(j));
                }
            } else {
                for (int k = 0; k < filesToUpdate.size(); ++k) {
                    if (!fileContents.contains(filesToUpdate.get(k))) continue;
                    fileContents.remove(filesToUpdate.get(k));
                }
            }
            this.writeConfigFile((String)buildConfigFiles.get(i), fileContents);
        }
    }

    public boolean exists(String entry, String configFile) {
        return this.exists(entry, configFile, "");
    }

    public boolean exists(String entry, String configFile, String rootPath) {
        Iterator it = this.readConfigFile(configFile).iterator();
        while (it.hasNext()) {
            if (!entry.equals(rootPath + "/" + (String)it.next())) continue;
            return true;
        }
        return false;
    }

    public List readConfigFile(String filePath) {
        try {
            File configFile = new File(filePath);
            if (!configFile.exists()) {
                Ajde.getDefault().getErrorHandler().handleWarning("Config file: " + filePath + " does not exist.  Update failed.");
            }
            ArrayList<String> fileContents = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            String line = reader.readLine();
            while (line != null) {
                fileContents.add(line.replace('\\', '/'));
                line = reader.readLine();
            }
            reader.close();
            return fileContents;
        }
        catch (IOException ioe) {
            Ajde.getDefault().getErrorHandler().handleError("Could not update build config file.", ioe);
            return null;
        }
    }

    public void writeConfigFile(String filePath, List files, List importedNodes) {
        BuildConfigNode node;
        String fileContentsString = "";
        HashSet includedFiles = new HashSet();
        Iterator it = importedNodes.iterator();
        while (it.hasNext()) {
            node = (BuildConfigNode)it.next();
            fileContentsString = fileContentsString + '@' + node.getResourcePath() + "\n";
            String parentPath = new File(filePath).getParent();
            String importedFilePath = parentPath + File.separator + node.getResourcePath();
            includedFiles.addAll(this.getIncludedFiles(importedFilePath, parentPath));
        }
        it = files.iterator();
        while (it.hasNext()) {
            node = (BuildConfigNode)it.next();
            if (node.getName().endsWith(".lst") && !node.getResourcePath().startsWith("..")) {
                fileContentsString = fileContentsString + '@';
                fileContentsString = fileContentsString + node.getResourcePath() + "\n";
                continue;
            }
            if (includedFiles.contains(node.getResourcePath())) continue;
            fileContentsString = fileContentsString + node.getResourcePath() + "\n";
        }
        this.writeFile(fileContentsString, filePath);
    }

    private List getIncludedFiles(String path, String rootPath) {
        try {
            ConfigParser configParser = new ConfigParser();
            configParser.parseConfigFile(new File(path));
            List files = configParser.getFiles();
            ArrayList<String> relativeFiles = new ArrayList<String>();
            Iterator it = files.iterator();
            while (it.hasNext()) {
                relativeFiles.add(this.relativizePath(((File)it.next()).getPath(), rootPath));
            }
            return relativeFiles;
        }
        catch (ConfigParser.ParseException pe) {
            return new ArrayList();
        }
    }

    public String relativizePath(String path, String rootPath) {
        int pathIndex = (path = path.replace('\\', '/')).indexOf(rootPath = rootPath.replace('\\', '/'));
        if (pathIndex > -1) {
            return path.substring(pathIndex + rootPath.length() + 1);
        }
        return path;
    }

    public void writeConfigFile(String filePath, List fileContents) {
        TreeSet contentsSet = new TreeSet(fileContents);
        String fileContentsString = "";
        Iterator it = contentsSet.iterator();
        while (it.hasNext()) {
            fileContentsString = fileContentsString + it.next().toString() + "\n";
        }
        this.writeFile(fileContentsString, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile(String contents, String filePath) {
        FileOutputStream fos = null;
        fos = new FileOutputStream(filePath, false);
        fos.write(contents.getBytes());
        Object var6_4 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                Ajde.getDefault().getErrorHandler().handleError("Could not update build config file: " + filePath, ioe);
                Object var6_5 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

