/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.weaver.bcel.UnwovenClassFile;

public class StatefulNameEnvironment
implements INameEnvironment {
    Map classesFromName;
    Set packageNames;
    INameEnvironment baseEnvironment;

    public StatefulNameEnvironment(INameEnvironment baseEnvironment, Map classesFromName) {
        this.classesFromName = classesFromName;
        this.baseEnvironment = baseEnvironment;
        this.packageNames = new HashSet();
        Iterator i = classesFromName.keySet().iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            this.addAllPackageNames(className);
        }
    }

    private void addAllPackageNames(String className) {
        int dot = className.indexOf(46);
        while (dot != -1) {
            this.packageNames.add(className.substring(0, dot));
            dot = className.indexOf(46, dot + 1);
        }
    }

    public void cleanup() {
        this.baseEnvironment.cleanup();
    }

    private NameEnvironmentAnswer findType(String name) {
        UnwovenClassFile cf = (UnwovenClassFile)this.classesFromName.get(name);
        if (cf == null) {
            return null;
        }
        try {
            return new NameEnvironmentAnswer(new ClassFileReader(cf.getBytes(), cf.getFilename().toCharArray()));
        }
        catch (ClassFormatException e) {
            return null;
        }
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        NameEnvironmentAnswer ret = this.findType(new String(CharOperation.concatWith(packageName, typeName, '.')));
        if (ret != null) {
            return ret;
        }
        return this.baseEnvironment.findType(typeName, packageName);
    }

    public NameEnvironmentAnswer findType(char[][] compoundName) {
        NameEnvironmentAnswer ret = this.findType(new String(CharOperation.concatWith(compoundName, '.')));
        if (ret != null) {
            return ret;
        }
        return this.baseEnvironment.findType(compoundName);
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        if (this.baseEnvironment.isPackage(parentPackageName, packageName)) {
            return true;
        }
        String fullPackageName = new String(CharOperation.concatWith(parentPackageName, packageName, '.'));
        return this.packageNames.contains(fullPackageName);
    }
}

