/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core.search;

import java.util.HashMap;
import java.util.HashSet;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IMember;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.IWorkingCopy;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.WorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.ISearchPattern;
import org.aspectj.org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.core.search.SearchMatch;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.core.search.SearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.aspectj.org.eclipse.jdt.internal.core.search.PathCollector;
import org.aspectj.org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class SearchEngine {
    private Parser parser;
    private CompilerOptions compilerOptions;
    private ICompilationUnit[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public SearchEngine() {
    }

    public SearchEngine(ICompilationUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    public SearchEngine(IWorkingCopy[] workingCopies) {
        int length = workingCopies.length;
        this.workingCopies = new ICompilationUnit[length];
        System.arraycopy(workingCopies, 0, this.workingCopies, 0, length);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaSearchScope createHierarchyScope(IType type) throws JavaModelException {
        return SearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaModelException {
        return new HierarchyScope(type, owner);
    }

    public static IJavaSearchScope createJavaSearchScope(IResource[] resources) {
        int length = resources.length;
        IJavaElement[] elements = new IJavaElement[length];
        int i = 0;
        while (i < length) {
            elements[i] = JavaCore.create(resources[i]);
            ++i;
        }
        return SearchEngine.createJavaSearchScope(elements);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements) {
        return SearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return SearchEngine.createJavaSearchScope(elements, includeMask);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements, int includeMask) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof JavaProject) {
                        scope.add((JavaProject)element, includeMask, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return scope;
    }

    public static ISearchPattern createOrSearchPattern(ISearchPattern leftPattern, ISearchPattern rightPattern) {
        SearchPattern left = ((SearchPatternAdapter)leftPattern).pattern;
        SearchPattern right = ((SearchPatternAdapter)rightPattern).pattern;
        SearchPattern pattern = SearchPattern.createOrPattern(left, right);
        return new SearchPatternAdapter(pattern);
    }

    public static ISearchPattern createSearchPattern(String stringPattern, int searchFor, int limitTo, boolean isCaseSensitive) {
        int matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        int matchRule = isCaseSensitive ? matchMode | 8 : matchMode;
        return new SearchPatternAdapter(SearchPattern.createPattern(stringPattern, searchFor, limitTo, matchRule));
    }

    public static ISearchPattern createSearchPattern(IJavaElement element, int limitTo) {
        return new SearchPatternAdapter(SearchPattern.createPattern(element, limitTo));
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return new JavaWorkspaceScope();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findMatches(SearchPattern pattern, SearchParticipant[] participants, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(Util.bind("engine.searching"), 100);
        }
        if (VERBOSE) {
            System.out.println("Searching for " + this + " in " + scope);
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        try {
            int l;
            requestor.beginReporting();
            int i = 0;
            int n = l = participants == null ? 0 : participants.length;
            while (i < l) {
                Object var15_16;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                SearchParticipant participant = participants[i];
                try {
                    participant.beginSearching();
                    requestor.enterParticipant(participant);
                    PathCollector pathCollector = new PathCollector();
                    indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, monitor);
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String[] indexMatchPaths = pathCollector.getPaths();
                    pathCollector = null;
                    int indexMatchLength = indexMatchPaths == null ? 0 : indexMatchPaths.length;
                    SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                    int j = 0;
                    while (true) {
                        block13: {
                            if (j < indexMatchLength) break block13;
                            SearchDocument[] matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                            participant.locateMatches(matches, pattern, scope, requestor, monitor);
                            break;
                        }
                        indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    var15_16 = null;
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                    throw throwable;
                }
                {
                    var15_16 = null;
                    requestor.exitParticipant(participant);
                    participant.doneSearching();
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            requestor.endReporting();
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        {
            Object var17_20 = null;
            requestor.endReporting();
            if (monitor == null) return;
        }
        monitor.done();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant();
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private IResource getResource(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null) {
            return cu.getResource();
        }
        return element.getResource();
    }

    private ICompilationUnit[] getWorkingCopies() {
        int length;
        ICompilationUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ICompilationUnit unit;
                    HashMap<IPath, ICompilationUnit> pathToCUs = new HashMap<IPath, ICompilationUnit>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new ICompilationUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ICompilationUnit[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new ICompilationUnit[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        if (index != length && result != null) {
            ICompilationUnit[] iCompilationUnitArray = result;
            result = new ICompilationUnit[index];
            System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
        }
        return result;
    }

    private ICompilationUnit[] getWorkingCopies(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null && cu.isWorkingCopy()) {
            int length;
            ICompilationUnit[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                ICompilationUnit[] newWorkingCopies = new ICompilationUnit[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new ICompilationUnit[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char classOrInterface, char[] patternPkg, char[] patternTypeName, int matchRule, boolean isClass, char[] pkg, char[] typeName) {
        boolean isCaseSensitive;
        switch (classOrInterface) {
            case 'C': {
                if (!isClass) {
                    return false;
                }
            }
            case 'I': {
                if (!isClass) break;
                return false;
            }
        }
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternPkg != null && !CharOperation.equals(patternPkg, pkg, isCaseSensitive)) {
            return false;
        }
        if (patternTypeName != null) {
            int matchMode = matchRule - (isCaseSensitive ? 8 : 0);
            switch (matchMode) {
                case 0: {
                    return CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(IWorkspace workspace, String patternString, int searchFor, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        try {
            int matchMode = patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1 ? 2 : 0;
            this.search(SearchPattern.createPattern(patternString, searchFor, limitTo, matchMode | 8), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new ResultCollectorAdapter(resultCollector), resultCollector.getProgressMonitor());
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void search(IWorkspace workspace, IJavaElement element, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        this.search(workspace, SearchEngine.createSearchPattern(element, limitTo), scope, resultCollector);
    }

    public void search(IWorkspace workspace, ISearchPattern searchPattern, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        try {
            this.search(((SearchPatternAdapter)searchPattern).pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new ResultCollectorAdapter(resultCollector), resultCollector.getProgressMonitor());
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(char[] packageName, char[] typeName, int matchRule, int searchFor, IJavaSearchScope scope, ITypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 621->625)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void searchAllTypeNames(IWorkspace workspace, char[] packageName, char[] typeName, int matchMode, boolean isCaseSensitive, int searchFor, IJavaSearchScope scope, ITypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException {
        this.searchAllTypeNames(packageName, typeName, isCaseSensitive ? matchMode | 8 : matchMode, searchFor, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    private void searchDeclarations(IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector, SearchPattern pattern) throws JavaModelException {
        this.searchDeclarations(enclosingElement, new ResultCollectorAdapter(resultCollector), pattern, resultCollector.getProgressMonitor());
    }

    private void searchDeclarations(IJavaElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{enclosingElement});
        IResource resource = this.getResource(enclosingElement);
        try {
            if (resource instanceof IFile) {
                if (VERBOSE) {
                    System.out.println("Searching for " + pattern + " in " + resource.getFullPath());
                }
                SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
                SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new JavaSearchDocument(enclosingElement.getPath().toString(), participant)}, this.getWorkingCopies(enclosingElement), participant);
                participant.locateMatches(documents, pattern, scope, requestor, monitor);
            } else {
                this.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
            }
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void searchDeclarationsOfAccessedFields(IJavaElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfAccessedFields(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, resultCollector, pattern);
    }

    public void searchDeclarationsOfReferencedTypes(IJavaElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, resultCollector, pattern);
    }

    public void searchDeclarationsOfSentMessages(IJavaElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, requestor, pattern, monitor);
    }

    public void searchDeclarationsOfSentMessages(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(enclosingElement, resultCollector, pattern);
    }

    static class SearchPatternAdapter
    implements ISearchPattern {
        SearchPattern pattern;

        SearchPatternAdapter(SearchPattern pattern) {
            this.pattern = pattern;
        }
    }

    class ResultCollectorAdapter
    extends SearchRequestor {
        IJavaSearchResultCollector resultCollector;

        ResultCollectorAdapter(IJavaSearchResultCollector resultCollector) {
            this.resultCollector = resultCollector;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.resultCollector.accept(match.getResource(), match.getOffset(), match.getOffset() + match.getLength(), (IJavaElement)match.getElement(), match.getAccuracy());
        }

        public void beginReporting() {
            this.resultCollector.aboutToStart();
        }

        public void endReporting() {
            this.resultCollector.done();
        }
    }
}

