/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;
    boolean thenExit;
    int thenInitStateIndex = -1;
    int elseInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public IfStatement(Expression condition, Statement thenStatement, int sourceStart, int sourceEnd) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        if (thenStatement instanceof EmptyStatement) {
            thenStatement.bits |= 1;
        }
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public IfStatement(Expression condition, Statement thenStatement, Statement elseStatement, int sourceStart, int sourceEnd) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        if (thenStatement instanceof EmptyStatement) {
            thenStatement.bits |= 1;
        }
        this.elseStatement = elseStatement;
        if (elseStatement instanceof IfStatement) {
            elseStatement.bits |= 0x20000000;
        }
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst != ASTNode.NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != ASTNode.NotAConstant && !cst.booleanValue();
        FlowInfo thenFlowInfo = flowInfo.initsWhenTrue().copy();
        if (isConditionOptimizedFalse) {
            thenFlowInfo.setReachMode(1);
        }
        if (this.thenStatement != null) {
            this.thenInitStateIndex = currentScope.methodScope().recordInitializationStates(thenFlowInfo);
            if (!this.thenStatement.complainIfUnreachable(thenFlowInfo, currentScope, false)) {
                thenFlowInfo = this.thenStatement.analyseCode(currentScope, flowContext, thenFlowInfo);
            }
        }
        this.thenExit = !thenFlowInfo.isReachable();
        FlowInfo elseFlowInfo = flowInfo.initsWhenFalse().copy();
        if (isConditionOptimizedTrue) {
            elseFlowInfo.setReachMode(1);
        }
        if (this.elseStatement != null) {
            if (thenFlowInfo == FlowInfo.DEAD_END && (this.bits & 0x20000000) == 0 && !(this.elseStatement instanceof IfStatement)) {
                currentScope.problemReporter().unnecessaryElse(this.elseStatement);
            }
            this.elseInitStateIndex = currentScope.methodScope().recordInitializationStates(elseFlowInfo);
            if (!this.elseStatement.complainIfUnreachable(elseFlowInfo, currentScope, false)) {
                elseFlowInfo = this.elseStatement.analyseCode(currentScope, flowContext, elseFlowInfo);
            }
        }
        FlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(thenFlowInfo, isConditionOptimizedTrue, elseFlowInfo, isConditionOptimizedFalse, true);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean hasElsePart;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        Label endifLabel = new Label(codeStream);
        Constant cst = this.condition.optimizedBooleanConstant();
        boolean hasThenPart = (cst == ASTNode.NotAConstant || cst.booleanValue()) && this.thenStatement != null && !this.thenStatement.isEmptyBlock();
        boolean bl = hasElsePart = (cst == ASTNode.NotAConstant || !cst.booleanValue()) && this.elseStatement != null && !this.elseStatement.isEmptyBlock();
        if (hasThenPart) {
            Label falseLabel = new Label(codeStream);
            this.condition.generateOptimizedBoolean(currentScope, codeStream, null, falseLabel, true);
            if (this.thenInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.thenInitStateIndex);
            }
            this.thenStatement.generateCode(currentScope, codeStream);
            if (hasElsePart && !this.thenExit) {
                this.thenStatement.branchChainTo(endifLabel);
                int position = codeStream.position;
                codeStream.goto_(endifLabel);
                codeStream.updateLastRecordedEndPC(position);
            }
            falseLabel.place();
        } else if (hasElsePart) {
            this.condition.generateOptimizedBoolean(currentScope, codeStream, endifLabel, null, true);
        } else {
            this.condition.generateCode(currentScope, codeStream, false);
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        if (hasElsePart) {
            if (this.elseInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.elseInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.elseInitStateIndex);
            }
            this.elseStatement.generateCode(currentScope, codeStream);
        }
        endifLabel.place();
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output).append("if (");
        this.condition.printExpression(0, output).append(")\n");
        this.thenStatement.printStatement(indent + 2, output);
        if (this.elseStatement != null) {
            output.append('\n');
            ASTNode.printIndent(indent, output);
            output.append("else\n");
            this.elseStatement.printStatement(indent + 2, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        TypeBinding type = this.condition.resolveTypeExpecting(scope, BaseTypes.BooleanBinding);
        this.condition.implicitWidening(type, type);
        if (this.thenStatement != null) {
            this.thenStatement.resolve(scope);
        }
        if (this.elseStatement != null) {
            this.elseStatement.resolve(scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(visitor, blockScope);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

