/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class QualifiedAllocationExpression
extends AllocationExpression {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration anonymousType) {
        this.anonymousType = anonymousType;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(currentScope, flowContext, flowInfo);
        }
        this.checkCapturedLocalInitializationIfNecessary(this.superTypeBinding == null ? this.binding.declaringClass : this.superTypeBinding, currentScope, flowInfo);
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo);
                ++i;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(currentScope, flowContext, flowInfo);
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, flowInfo, currentScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int i;
        int pc = codeStream.position;
        ReferenceBinding allocatedType = this.binding.declaringClass;
        codeStream.new_(allocatedType);
        if (valueRequired) {
            codeStream.dup();
        }
        codeStream.recordPositionsFrom(pc, this.type.sourceStart);
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
        }
        if (this.arguments != null) {
            i = 0;
            int count = this.arguments.length;
            while (i < count) {
                this.arguments[i].generateCode(currentScope, codeStream, true);
                ++i;
            }
        }
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.binding);
        } else {
            i = 0;
            int max = this.syntheticAccessor.parameters.length - this.binding.parameters.length;
            while (i < max) {
                codeStream.aconst_null();
                ++i;
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        if (this.anonymousType != null) {
            this.anonymousType.generateCode(currentScope, codeStream);
        }
    }

    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        ReferenceBinding allocatedType = this.binding.declaringClass;
        if (allocatedType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (allocatedType.isLocalType()) {
                ((LocalTypeBinding)allocatedType).addInnerEmulationDependent(currentScope, this.enclosingInstance != null);
            } else {
                currentScope.propagateInnerEmulation(allocatedType, this.enclosingInstance != null);
            }
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, output).append('.');
        }
        super.printExpression(0, output);
        if (this.anonymousType != null) {
            this.anonymousType.print(indent, output);
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        int i;
        if (this.anonymousType == null && this.enclosingInstance == null) {
            return super.resolveType(scope);
        }
        this.constant = ASTNode.NotAConstant;
        TypeBinding enclosingInstanceType = null;
        TypeBinding receiverType = null;
        boolean hasError = false;
        boolean enclosingInstanceContainsCast = false;
        boolean argsContainCast = false;
        if (this.enclosingInstance != null) {
            if (this.enclosingInstance instanceof CastExpression) {
                this.enclosingInstance.bits |= 0x20;
                enclosingInstanceContainsCast = true;
            }
            if ((enclosingInstanceType = this.enclosingInstance.resolveType(scope)) == null) {
                hasError = true;
            } else if (enclosingInstanceType.isBaseType() || enclosingInstanceType.isArrayType()) {
                scope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(enclosingInstanceType, this.enclosingInstance);
                hasError = true;
            } else {
                receiverType = ((SingleTypeReference)this.type).resolveTypeEnclosing(scope, (ReferenceBinding)enclosingInstanceType);
                if (receiverType != null && enclosingInstanceContainsCast) {
                    CastExpression.checkNeedForEnclosingInstanceCast(scope, this.enclosingInstance, enclosingInstanceType, receiverType);
                }
            }
        } else {
            receiverType = this.type.resolveType(scope);
        }
        if (receiverType == null) {
            hasError = true;
        } else if (((ReferenceBinding)receiverType).isFinal() && this.anonymousType != null) {
            scope.problemReporter().anonymousClassCannotExtendFinalClass(this.type, receiverType);
            hasError = true;
        }
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                    hasError = true;
                }
                ++i;
            }
        }
        if (hasError) {
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        if (this.anonymousType == null) {
            ReferenceBinding allocationType = (ReferenceBinding)receiverType;
            if (!receiverType.canBeInstantiated()) {
                scope.problemReporter().cannotInstantiate(this.type, receiverType);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            this.binding = scope.getConstructor(allocationType, argumentTypes, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, scope)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
                if (this.arguments != null) {
                    i = 0;
                    while (i < this.arguments.length) {
                        this.arguments[i].implicitWidening(this.binding.parameters[i], argumentTypes[i]);
                        ++i;
                    }
                    if (argsContainCast) {
                        CastExpression.checkNeedForArgumentCasts(scope, null, allocationType, this.binding, this.arguments, argumentTypes, this);
                    }
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocationType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            ReferenceBinding expectedType = this.binding.declaringClass.enclosingType();
            if (enclosingInstanceType.isCompatibleWith(expectedType)) {
                return receiverType;
            }
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.enclosingInstance, enclosingInstanceType, expectedType);
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        this.superTypeBinding = receiverType.isInterface() ? scope.getJavaLangObject() : (ReferenceBinding)receiverType;
        scope.addAnonymousType(this.anonymousType, (ReferenceBinding)receiverType);
        this.anonymousType.resolve(scope);
        MethodBinding inheritedBinding = scope.getConstructor(this.superTypeBinding, argumentTypes, this);
        if (!inheritedBinding.isValidBinding()) {
            if (inheritedBinding.declaringClass == null) {
                inheritedBinding.declaringClass = this.superTypeBinding;
            }
            scope.problemReporter().invalidConstructor(this, inheritedBinding);
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.enclosingInstance != null && !enclosingInstanceType.isCompatibleWith(inheritedBinding.declaringClass.enclosingType())) {
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.enclosingInstance, enclosingInstanceType, inheritedBinding.declaringClass.enclosingType());
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.arguments != null) {
            i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].implicitWidening(inheritedBinding.parameters[i], argumentTypes[i]);
                ++i;
            }
            if (argsContainCast) {
                CastExpression.checkNeedForArgumentCasts(scope, null, this.superTypeBinding, inheritedBinding, this.arguments, argumentTypes, this);
            }
        }
        this.binding = this.anonymousType.createsInternalConstructorWithBinding(inheritedBinding);
        this.resolvedType = this.anonymousType.binding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(visitor, scope);
            }
            this.type.traverse(visitor, scope);
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

