/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Statement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public static final char[] ANONYMOUS_EMPTY_NAME = new char[0];
    public int modifiers = 0;
    public int modifiersSourceStart;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public TypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    protected boolean hasBeenGenerated = false;
    public CompilationResult compilationResult;
    private MethodDeclaration[] missingAbstractMethods;
    public Javadoc javadoc;
    public QualifiedAllocationExpression allocation;
    public TypeDeclaration enclosingType;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int abortLevel, IProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortType(this.compilationResult, problem);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] methodDeclarations = this.methods;
            if (this.methods == null) {
                boolean length = false;
                methodDeclarations = new AbstractMethodDeclaration[1];
            } else {
                int length = methodDeclarations.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = methodDeclarations;
                methodDeclarations = new AbstractMethodDeclaration[length + 1];
                System.arraycopy(abstractMethodDeclarationArray, 0, methodDeclarations, 1, length);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            methodDeclarations[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = methodDeclarations;
        }
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        TypeBinding[] argumentTypes = methodBinding.parameters;
        int argumentsLength = argumentTypes.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (argumentsLength > 0) {
            String baseName = "arg";
            methodDeclaration.arguments = new Argument[argumentsLength];
            Argument[] arguments = methodDeclaration.arguments;
            int i = argumentsLength;
            while (--i >= 0) {
                arguments[i] = new Argument((String.valueOf(baseName) + i).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            MethodDeclaration[] newMethods = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, newMethods, 1, this.missingAbstractMethods.length);
            newMethods[0] = methodDeclaration;
            this.missingAbstractMethods = newMethods;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers, methodBinding.selector, methodBinding.returnType, argumentsLength == 0 ? TypeConstants.NoParameters : argumentTypes, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            if (flowInfo.isReachable()) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localType = (LocalTypeBinding)this.binding;
                localType.setConstantPoolName(currentScope.compilationUnitScope().computeConstantPoolName(localType));
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType e) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope enclosingClassScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.updateMaxFieldCount();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (flowInfo.isReachable()) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localType = (LocalTypeBinding)this.binding;
                localType.setConstantPoolName(currentScope.compilationUnitScope().computeConstantPoolName(localType));
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean hasConstructor = false;
        if (this.methods != null) {
            int i = this.methods.length;
            while (--i >= 0) {
                AbstractMethodDeclaration am = this.methods[i];
                if (!am.isConstructor()) continue;
                if (!CharOperation.equals(am.selector, this.name)) {
                    ConstructorDeclaration c = (ConstructorDeclaration)am;
                    if (c.constructorCall != null && !c.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration m = parser.convertToMethodDeclaration(c, this.compilationResult);
                    this.methods[i] = m;
                    continue;
                }
                if (this.isInterface()) {
                    parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)am);
                }
                hasConstructor = true;
            }
        }
        return hasConstructor;
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createsInternalConstructor(boolean needExplicitConstructorCall, boolean needToInsert) {
        ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
        constructor.isDefaultConstructor = true;
        constructor.selector = this.name;
        if (this.modifiers != 0) {
            constructor.modifiers = (this.bits & 0x400) != 0 && (this.modifiers & 2) != 0 ? 0 : this.modifiers & 7;
        }
        constructor.declarationSourceStart = constructor.sourceStart = this.sourceStart;
        constructor.sourceEnd = constructor.bodyEnd = this.sourceEnd;
        constructor.declarationSourceEnd = constructor.bodyEnd;
        if (needExplicitConstructorCall) {
            constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructor.constructorCall.sourceStart = this.sourceStart;
            constructor.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (needToInsert) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructor};
            } else {
                AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
                newMethods[0] = constructor;
                this.methods = newMethods;
            }
        }
        return constructor;
    }

    public MethodBinding createsInternalConstructorWithBinding(MethodBinding inheritedConstructorBinding) {
        BaseTypes[] newMethods;
        int i;
        String baseName = "$anonymous";
        TypeBinding[] argumentTypes = inheritedConstructorBinding.parameters;
        int argumentsLength = argumentTypes.length;
        ConstructorDeclaration cd = new ConstructorDeclaration(this.compilationResult);
        cd.selector = new char[]{'x'};
        cd.sourceStart = this.sourceStart;
        cd.sourceEnd = this.sourceEnd;
        cd.modifiers = this.modifiers & 7;
        cd.isDefaultConstructor = true;
        if (argumentsLength > 0) {
            cd.arguments = new Argument[argumentsLength];
            Argument[] arguments = cd.arguments;
            i = argumentsLength;
            while (--i >= 0) {
                arguments[i] = new Argument((String.valueOf(baseName) + i).toCharArray(), 0L, null, 0);
            }
        }
        cd.constructorCall = SuperReference.implicitSuperConstructorCall();
        cd.constructorCall.sourceStart = this.sourceStart;
        cd.constructorCall.sourceEnd = this.sourceEnd;
        if (argumentsLength > 0) {
            cd.constructorCall.arguments = new Expression[argumentsLength];
            Expression[] args = cd.constructorCall.arguments;
            i = argumentsLength;
            while (--i >= 0) {
                args[i] = new SingleNameReference((String.valueOf(baseName) + i).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{cd};
        } else {
            newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
            newMethods[0] = cd;
            this.methods = newMethods;
        }
        cd.binding = new MethodBinding(cd.modifiers, argumentsLength == 0 ? TypeConstants.NoParameters : argumentTypes, inheritedConstructorBinding.thrownExceptions, this.binding);
        cd.scope = new MethodScope(this.scope, cd, true);
        cd.bindArguments();
        cd.constructorCall.resolve(cd.scope);
        if (this.binding.methods == null) {
            this.binding.methods = new MethodBinding[]{cd.binding};
        } else {
            newMethods = new MethodBinding[this.binding.methods.length + 1];
            System.arraycopy(this.binding.methods, 0, newMethods, 1, this.binding.methods.length);
            newMethods[0] = cd.binding;
            this.binding.methods = newMethods;
        }
        return cd.binding;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null) {
            int i = 0;
            int max = this.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = this.fields[i];
                if (fieldDecl.binding == fieldBinding) {
                    return fieldDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null) {
            int i = 0;
            int max = this.memberTypes.length;
            while (i < max) {
                TypeDeclaration memberTypeDecl = this.memberTypes[i];
                if (memberTypeDecl.binding == memberTypeBinding) {
                    return memberTypeDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null) {
            int i = 0;
            int max = this.methods.length;
            while (i < max) {
                AbstractMethodDeclaration methodDecl = this.methods[i];
                if (methodDecl.binding == methodBinding) {
                    return methodDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        int typeNameLength = typeName.length;
        if (typeNameLength < 1 || !CharOperation.equals(typeName[0], this.name)) {
            return null;
        }
        if (typeNameLength == 1) {
            return this;
        }
        char[][] subTypeName = new char[typeNameLength - 1][];
        System.arraycopy(typeName, 1, subTypeName, 0, typeNameLength - 1);
        int i = 0;
        while (i < this.memberTypes.length) {
            TypeDeclaration typeDecl = this.memberTypes[i].declarationOfType(subTypeName);
            if (typeDecl != null) {
                return typeDecl;
            }
            ++i;
        }
        return null;
    }

    public void generateCode(ClassFile enclosingClassFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        this.hasBeenGenerated = true;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            int max;
            int i;
            ClassFile classFile = new ClassFile(this.binding, enclosingClassFile, false);
            classFile.addFieldInfos();
            if (this.binding.isMemberType()) {
                classFile.recordEnclosingTypeAttributes(this.binding);
            }
            if (this.binding.isLocalType()) {
                enclosingClassFile.recordNestedLocalAttribute(this.binding);
                classFile.recordNestedLocalAttribute(this.binding);
            }
            if (this.memberTypes != null) {
                i = 0;
                max = this.memberTypes.length;
                while (i < max) {
                    classFile.recordNestedMemberAttribute(this.memberTypes[i].binding);
                    this.memberTypes[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.setForMethodInfos();
            if (this.methods != null) {
                i = 0;
                max = this.methods.length;
                while (i < max) {
                    this.methods[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.generateMissingAbstractMethods(this.missingAbstractMethods, this.scope.referenceCompilationUnit().compilationResult);
            classFile.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            this.generateAttributes(classFile);
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile);
        }
        catch (AbortType e) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    protected void generateAttributes(ClassFile classFile) {
        classFile.addAttributes();
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.hasBeenGenerated) {
            return;
        }
        int pc = codeStream.position;
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile enclosingClassFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(enclosingClassFile);
    }

    public void generateCode(CompilationUnitScope unitScope) {
        this.generateCode((ClassFile)null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int count;
        int i;
        if (this.binding.isPrivate() && !this.binding.isPrivateUsed() && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        InitializationFlowContext initializerContext = new InitializationFlowContext(null, this, this.initializerScope);
        InitializationFlowContext staticInitializerContext = new InitializationFlowContext(null, this, this.staticInitializerScope);
        FlowInfo nonStaticFieldInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
        FlowInfo staticFieldInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
        if (this.fields != null) {
            i = 0;
            count = this.fields.length;
            while (i < count) {
                FieldDeclaration field = this.fields[i];
                if (field.isStatic()) {
                    staticInitializerContext.handledExceptions = TypeConstants.AnyException;
                    if ((staticFieldInfo = field.analyseCode(this.staticInitializerScope, (FlowContext)staticInitializerContext, staticFieldInfo)) == FlowInfo.DEAD_END) {
                        this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(field);
                        staticFieldInfo = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                } else {
                    initializerContext.handledExceptions = TypeConstants.AnyException;
                    if ((nonStaticFieldInfo = field.analyseCode(this.initializerScope, (FlowContext)initializerContext, nonStaticFieldInfo)) == FlowInfo.DEAD_END) {
                        this.initializerScope.problemReporter().initializerMustCompleteNormally(field);
                        nonStaticFieldInfo = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                }
                ++i;
            }
        }
        if (this.memberTypes != null) {
            i = 0;
            count = this.memberTypes.length;
            while (i < count) {
                if (flowContext != null) {
                    this.memberTypes[i].analyseCode(this.scope, flowContext, ((FlowInfo)nonStaticFieldInfo).copy());
                } else {
                    this.memberTypes[i].analyseCode(this.scope);
                }
                ++i;
            }
        }
        if (this.methods != null) {
            UnconditionalFlowInfo outerInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
            FlowInfo constructorInfo = ((FlowInfo)nonStaticFieldInfo).unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(outerInfo);
            int i2 = 0;
            int count2 = this.methods.length;
            while (i2 < count2) {
                AbstractMethodDeclaration method = this.methods[i2];
                if (!method.ignoreFurtherInvestigation) {
                    if (method.isInitializationMethod()) {
                        if (method.isStatic()) {
                            method.analyseCode(this.scope, staticInitializerContext, staticFieldInfo.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(outerInfo));
                        } else {
                            method.analyseCode(this.scope, initializerContext, constructorInfo.copy());
                        }
                    } else {
                        method.analyseCode(this.scope, null, flowInfo.copy());
                    }
                }
                ++i2;
            }
        }
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding superclassBinding;
        if (!flowInfo.isReachable()) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)this.binding;
        MethodScope methodScope = currentScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedType.addSyntheticArgumentAndField(this.binding.enclosingType());
        }
        if (!(!this.binding.isAnonymousType() || (superclassBinding = this.binding.superclass).enclosingType() == null || superclassBinding.isStatic() || superclassBinding.isLocalType() && ((NestedTypeBinding)superclassBinding).getSyntheticField(superclassBinding.enclosingType(), true) == null)) {
            nestedType.addSyntheticArgument(superclassBinding.enclosingType());
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)this.binding;
        nestedType.addSyntheticArgumentAndField(this.binding.enclosingType());
    }

    public boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        if (this.fields == null) {
            return false;
        }
        if (this.isInterface()) {
            return true;
        }
        int i = this.fields.length;
        while (--i >= 0) {
            FieldDeclaration field = this.fields[i];
            if ((field.modifiers & 8) == 0) continue;
            return true;
        }
        return false;
    }

    public void parseMethod(Parser parser, CompilationUnitDeclaration unit) {
        int i;
        int length;
        if (unit.ignoreMethodBodies) {
            return;
        }
        if (this.memberTypes != null) {
            length = this.memberTypes.length;
            i = 0;
            while (i < length) {
                this.memberTypes[i].parseMethod(parser, unit);
                ++i;
            }
        }
        if (this.methods != null) {
            length = this.methods.length;
            i = 0;
            while (i < length) {
                this.methods[i].parseStatements(parser, unit);
                ++i;
            }
        }
        if (this.fields != null) {
            length = this.fields.length;
            i = 0;
            while (i < length) {
                if (this.fields[i] instanceof Initializer) {
                    ((Initializer)this.fields[i]).parseStatements(parser, this, unit);
                }
                ++i;
            }
        }
    }

    public StringBuffer print(int indent, StringBuffer output) {
        if ((this.bits & 0x200) == 0) {
            ASTNode.printIndent(indent, output);
            this.printHeader(0, output);
        }
        return this.printBody(indent, output);
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        int i;
        output.append(" {");
        if (this.memberTypes != null) {
            i = 0;
            while (i < this.memberTypes.length) {
                if (this.memberTypes[i] != null) {
                    output.append('\n');
                    this.memberTypes[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        if (this.fields != null) {
            int fieldI = 0;
            while (fieldI < this.fields.length) {
                if (this.fields[fieldI] != null) {
                    output.append('\n');
                    this.fields[fieldI].print(indent + 1, output);
                }
                ++fieldI;
            }
        }
        if (this.methods != null) {
            i = 0;
            while (i < this.methods.length) {
                if (this.methods[i] != null) {
                    output.append('\n');
                    this.methods[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        output.append('\n');
        return ASTNode.printIndent(indent, output).append('}');
    }

    public StringBuffer printHeader(int indent, StringBuffer output) {
        ASTNode.printModifiers(this.modifiers, output);
        output.append(this.isInterface() ? "interface " : "class ");
        output.append(this.name);
        if (this.superclass != null) {
            output.append(" extends ");
            this.superclass.print(0, output);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            output.append(this.isInterface() ? " extends " : " implements ");
            int i = 0;
            while (i < this.superInterfaces.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.superInterfaces[i].print(0, output);
                ++i;
            }
        }
        return output;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        return this.print(tab, output);
    }

    public void resolve() {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            int methodsLength;
            int count;
            int i;
            block18: {
                if ((this.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd);
                }
                if (this.binding.superclass != null && this.isTypeUseDeprecated(this.binding.superclass, this.scope)) {
                    this.scope.problemReporter().deprecatedType(this.binding.superclass, this.superclass);
                }
                if (this.superInterfaces != null) {
                    int i2 = this.superInterfaces.length;
                    while (--i2 >= 0) {
                        if (this.superInterfaces[i2].resolvedType == null || !this.isTypeUseDeprecated(this.superInterfaces[i2].resolvedType, this.scope)) continue;
                        this.scope.problemReporter().deprecatedType(this.superInterfaces[i2].resolvedType, this.superInterfaces[i2]);
                    }
                }
                this.maxFieldCount = 0;
                int lastVisibleFieldID = -1;
                if (this.fields == null) break block18;
                i = 0;
                count = this.fields.length;
                while (i < count) {
                    block21: {
                        FieldDeclaration field;
                        block22: {
                            block19: {
                                block20: {
                                    field = this.fields[i];
                                    if (!field.isField()) break block19;
                                    if (field.binding != null) break block20;
                                    if (field.initialization != null) {
                                        field.initialization.resolve(field.isStatic() ? this.staticInitializerScope : this.initializerScope);
                                    }
                                    this.ignoreFurtherInvestigation = true;
                                    break block21;
                                }
                                ++this.maxFieldCount;
                                lastVisibleFieldID = field.binding.id;
                                break block22;
                            }
                            ((Initializer)field).lastVisibleFieldID = lastVisibleFieldID + 1;
                        }
                        field.resolve(field.isStatic() ? this.staticInitializerScope : this.initializerScope);
                    }
                    ++i;
                }
            }
            if (this.memberTypes != null) {
                i = 0;
                count = this.memberTypes.length;
                while (i < count) {
                    this.memberTypes[i].resolve(this.scope);
                    ++i;
                }
            }
            int missingAbstractMethodslength = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            int n = methodsLength = this.methods == null ? 0 : this.methods.length;
            if (methodsLength + missingAbstractMethodslength > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (this.methods != null) {
                int i3 = 0;
                int count2 = this.methods.length;
                while (i3 < count2) {
                    this.methods[i3].resolve(this.scope);
                    ++i3;
                }
            }
            if (this.javadoc != null) {
                if (this.scope != null) {
                    this.javadoc.resolve(this.scope);
                }
            } else if (this.binding != null && !this.binding.isLocalType()) {
                this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
            }
        }
        catch (AbortType e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void resolve(BlockScope blockScope) {
        if ((this.bits & 0x200) == 0) {
            blockScope.addLocalType(this);
        }
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            this.resolve();
            this.updateMaxFieldCount();
        }
    }

    public void resolve(ClassScope upperScope) {
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            upperScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void resolve(CompilationUnitScope upperScope) {
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, unitScope)) {
                int i;
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    int superInterfaceLength = this.superInterfaces.length;
                    i = 0;
                    while (i < superInterfaceLength) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    int memberTypesLength = this.memberTypes.length;
                    i = 0;
                    while (i < memberTypesLength) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    int fieldsLength = this.fields.length;
                    i = 0;
                    while (i < fieldsLength) {
                        FieldDeclaration field = this.fields[i];
                        if (field.isStatic()) {
                            field.traverse(visitor, this.staticInitializerScope);
                        } else {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    int methodsLength = this.methods.length;
                    i = 0;
                    while (i < methodsLength) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, unitScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, blockScope)) {
                int i;
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    int superInterfaceLength = this.superInterfaces.length;
                    i = 0;
                    while (i < superInterfaceLength) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    int memberTypesLength = this.memberTypes.length;
                    i = 0;
                    while (i < memberTypesLength) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    int fieldsLength = this.fields.length;
                    i = 0;
                    while (i < fieldsLength) {
                        FieldDeclaration field = this.fields[i];
                        if (!field.isStatic()) {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    int methodsLength = this.methods.length;
                    i = 0;
                    while (i < methodsLength) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, classScope)) {
                int i;
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    int superInterfaceLength = this.superInterfaces.length;
                    i = 0;
                    while (i < superInterfaceLength) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    int memberTypesLength = this.memberTypes.length;
                    i = 0;
                    while (i < memberTypesLength) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    int fieldsLength = this.fields.length;
                    i = 0;
                    while (i < fieldsLength) {
                        FieldDeclaration field = this.fields[i];
                        if (field.isStatic()) {
                            field.traverse(visitor, this.staticInitializerScope);
                        } else {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    int methodsLength = this.methods.length;
                    i = 0;
                    while (i < methodsLength) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, classScope);
        }
        catch (AbortType abortType) {
            // empty catch block
        }
    }

    void updateMaxFieldCount() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration outerMostType = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > outerMostType.maxFieldCount) {
            outerMostType.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = outerMostType.maxFieldCount;
        }
    }
}

