/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.CompoundNameVector;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfType;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleNameVector;

public class CompilationUnitScope
extends Scope {
    public LookupEnvironment environment;
    public CompilationUnitDeclaration referenceContext;
    public char[][] currentPackageName;
    public PackageBinding fPackage;
    public ImportBinding[] imports;
    public HashtableOfObject resolvedSingeTypeImports;
    public SourceTypeBinding[] topLevelTypes;
    private CompoundNameVector qualifiedReferences;
    private SimpleNameVector simpleNameReferences;
    private ObjectVector referencedTypes;
    HashtableOfType constantPoolNameUsage;

    public CompilationUnitScope(CompilationUnitDeclaration unit, LookupEnvironment environment) {
        super(4, null);
        this.environment = environment;
        this.referenceContext = unit;
        unit.scope = this;
        char[][] cArray = this.currentPackageName = unit.currentPackage == null ? CharOperation.NO_CHAR_CHAR : unit.currentPackage.tokens;
        if (environment.options.produceReferenceInfo) {
            this.qualifiedReferences = new CompoundNameVector();
            this.simpleNameReferences = new SimpleNameVector();
            this.referencedTypes = new ObjectVector();
        } else {
            this.qualifiedReferences = null;
            this.simpleNameReferences = null;
            this.referencedTypes = null;
        }
    }

    public void buildFieldsAndMethods() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].scope.buildFieldsAndMethods();
            ++i;
        }
    }

    void buildTypeBindings() {
        TypeDeclaration[] types;
        char[][] expectedPackageName;
        this.topLevelTypes = new SourceTypeBinding[0];
        if (this.referenceContext.compilationResult.compilationUnit != null && (expectedPackageName = this.referenceContext.compilationResult.compilationUnit.getPackageName()) != null && !CharOperation.equals(this.currentPackageName, expectedPackageName)) {
            if (this.referenceContext.currentPackage != null || this.referenceContext.types != null || this.referenceContext.imports != null) {
                this.problemReporter().packageIsNotExpectedPackage(this.referenceContext);
            }
            char[][] cArray = this.currentPackageName = expectedPackageName.length == 0 ? CharOperation.NO_CHAR_CHAR : expectedPackageName;
        }
        if (this.currentPackageName == CharOperation.NO_CHAR_CHAR) {
            this.fPackage = this.environment.defaultPackage;
            if (this.fPackage == null) {
                this.problemReporter().mustSpecifyPackage(this.referenceContext);
                return;
            }
        } else {
            this.fPackage = this.environment.createPackage(this.currentPackageName);
            if (this.fPackage == null) {
                this.problemReporter().packageCollidesWithType(this.referenceContext);
                return;
            }
            this.recordQualifiedReference(this.currentPackageName);
        }
        int typeLength = (types = this.referenceContext.types) == null ? 0 : types.length;
        this.topLevelTypes = new SourceTypeBinding[typeLength];
        int count = 0;
        int i = 0;
        while (i < typeLength) {
            char[] mainTypeName;
            TypeDeclaration typeDecl = types[i];
            ReferenceBinding typeBinding = this.fPackage.getType0(typeDecl.name);
            this.recordSimpleReference(typeDecl.name);
            if (typeBinding != null && !(typeBinding instanceof UnresolvedReferenceBinding)) {
                this.problemReporter().duplicateTypes(this.referenceContext, typeDecl);
            } else if (this.fPackage != this.environment.defaultPackage && this.fPackage.getPackage(typeDecl.name) != null) {
                this.problemReporter().typeCollidesWithPackage(this.referenceContext, typeDecl);
            } else if ((typeDecl.modifiers & 1) != 0 && (mainTypeName = this.referenceContext.getMainTypeName()) != null && !CharOperation.equals(mainTypeName, typeDecl.name)) {
                this.problemReporter().publicClassMustMatchFileName(this.referenceContext, typeDecl);
            } else {
                ClassScope child = new ClassScope(this, typeDecl);
                SourceTypeBinding type = child.buildType(null, this.fPackage);
                if (type != null) {
                    this.topLevelTypes[count++] = type;
                }
            }
            ++i;
        }
        if (count != this.topLevelTypes.length) {
            this.topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(this.topLevelTypes, 0, this.topLevelTypes, 0, count);
        }
    }

    public void checkAndSetImports() {
        if (this.referenceContext.imports == null) {
            this.imports = this.getDefaultImports();
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        int numberOfImports = numberOfStatements + 1;
        int i = 0;
        while (i < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i];
            if (importReference.onDemand && CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens)) {
                --numberOfImports;
                break;
            }
            ++i;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        int i2 = 0;
        while (i2 < numberOfStatements) {
            block11: {
                ImportReference importReference = this.referenceContext.imports[i2];
                char[][] compoundName = importReference.tokens;
                int j = 0;
                while (j < index) {
                    if (resolvedImports[j].onDemand != importReference.onDemand || !CharOperation.equals(compoundName, resolvedImports[j].compoundName)) {
                        ++j;
                        continue;
                    }
                    break block11;
                }
                if (!importReference.onDemand || !CharOperation.equals(compoundName, this.currentPackageName)) {
                    if (importReference.onDemand) {
                        Binding importBinding = this.findOnDemandImport(compoundName);
                        if (importBinding.isValidBinding()) {
                            resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                        }
                    } else {
                        resolvedImports[index++] = new ImportBinding(compoundName, false, null, importReference);
                    }
                }
            }
            ++i2;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
    }

    /*
     * WARNING - void declaration
     */
    public char[] computeConstantPoolName(LocalTypeBinding localType) {
        void var4_4;
        char[] candidateName;
        if (localType.constantPoolName() != null) {
            return localType.constantPoolName();
        }
        if (this.constantPoolNameUsage == null) {
            this.constantPoolNameUsage = new HashtableOfType();
        }
        SourceTypeBinding outerMostEnclosingType = localType.scope.outerMostClassScope().enclosingSourceType();
        int index = 0;
        while (true) {
            candidateName = localType.isMemberType() ? (index == 0 ? CharOperation.concat(localType.enclosingType().constantPoolName(), localType.sourceName, '$') : CharOperation.concat(localType.enclosingType().constantPoolName(), '$', String.valueOf(index).toCharArray(), '$', localType.sourceName)) : (localType.isAnonymousType() ? CharOperation.concat(outerMostEnclosingType.constantPoolName(), String.valueOf(index + 1).toCharArray(), '$') : CharOperation.concat(outerMostEnclosingType.constantPoolName(), '$', String.valueOf(index + 1).toCharArray(), '$', localType.sourceName));
            if (this.constantPoolNameUsage.get(candidateName) == null) break;
            ++index;
        }
        this.constantPoolNameUsage.put(candidateName, localType);
        return var4_4;
    }

    public void connectTypeHierarchy() {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].scope.connectTypeHierarchy();
            ++i;
        }
    }

    void faultInImports() {
        if (this.referenceContext.imports == null) {
            return;
        }
        int numberOfStatements = this.referenceContext.imports.length;
        HashtableOfType typesBySimpleNames = null;
        int i = 0;
        while (i < numberOfStatements) {
            if (!this.referenceContext.imports[i].onDemand) {
                typesBySimpleNames = new HashtableOfType(this.topLevelTypes.length + numberOfStatements);
                int j = 0;
                int length = this.topLevelTypes.length;
                while (j < length) {
                    typesBySimpleNames.put(this.topLevelTypes[j].sourceName, this.topLevelTypes[j]);
                    ++j;
                }
                break;
            }
            ++i;
        }
        int numberOfImports = numberOfStatements + 1;
        int i2 = 0;
        while (i2 < numberOfStatements) {
            ImportReference importReference = this.referenceContext.imports[i2];
            if (importReference.onDemand && CharOperation.equals(TypeConstants.JAVA_LANG, importReference.tokens)) {
                --numberOfImports;
                break;
            }
            ++i2;
        }
        ImportBinding[] resolvedImports = new ImportBinding[numberOfImports];
        resolvedImports[0] = this.getDefaultImports()[0];
        int index = 1;
        int i3 = 0;
        while (i3 < numberOfStatements) {
            block28: {
                ImportReference importReference = this.referenceContext.imports[i3];
                char[][] compoundName = importReference.tokens;
                int j = 0;
                while (j < index) {
                    if (resolvedImports[j].onDemand == importReference.onDemand && CharOperation.equals(compoundName, resolvedImports[j].compoundName)) {
                        this.problemReporter().unusedImport(importReference);
                        break block28;
                    }
                    ++j;
                }
                if (importReference.onDemand && CharOperation.equals(compoundName, this.currentPackageName)) {
                    this.problemReporter().unusedImport(importReference);
                } else if (importReference.onDemand) {
                    Binding importBinding = this.findOnDemandImport(compoundName);
                    if (!importBinding.isValidBinding()) {
                        this.problemReporter().importProblem(importReference, importBinding);
                    } else {
                        resolvedImports[index++] = new ImportBinding(compoundName, true, importBinding, importReference);
                    }
                } else {
                    Binding typeBinding = this.findSingleTypeImport(compoundName);
                    if (!typeBinding.isValidBinding()) {
                        this.problemReporter().importProblem(importReference, typeBinding);
                    } else if (typeBinding instanceof PackageBinding) {
                        this.problemReporter().cannotImportPackage(importReference);
                    } else {
                        ReferenceBinding existingType;
                        ReferenceBinding referenceBinding;
                        if (typeBinding instanceof ReferenceBinding && importReference.isTypeUseDeprecated(referenceBinding = (ReferenceBinding)typeBinding, this)) {
                            this.problemReporter().deprecatedType((TypeBinding)typeBinding, importReference);
                        }
                        if ((existingType = typesBySimpleNames.get(compoundName[compoundName.length - 1])) != null) {
                            if (existingType != typeBinding) {
                                int j2 = 0;
                                int length = this.topLevelTypes.length;
                                while (j2 < length) {
                                    if (CharOperation.equals(this.topLevelTypes[j2].sourceName, existingType.sourceName)) {
                                        this.problemReporter().conflictingImport(importReference);
                                        break block28;
                                    }
                                    ++j2;
                                }
                                this.problemReporter().duplicateImport(importReference);
                            }
                        } else {
                            resolvedImports[index++] = new ImportBinding(compoundName, false, typeBinding, importReference);
                            typesBySimpleNames.put(compoundName[compoundName.length - 1], (ReferenceBinding)typeBinding);
                        }
                    }
                }
            }
            ++i3;
        }
        if (resolvedImports.length > index) {
            ImportBinding[] importBindingArray = resolvedImports;
            resolvedImports = new ImportBinding[index];
            System.arraycopy(importBindingArray, 0, resolvedImports, 0, index);
        }
        this.imports = resolvedImports;
        int length = this.imports.length;
        this.resolvedSingeTypeImports = new HashtableOfObject(length);
        int i4 = 0;
        while (i4 < length) {
            ImportBinding binding = this.imports[i4];
            if (!binding.onDemand) {
                this.resolvedSingeTypeImports.put(binding.compoundName[binding.compoundName.length - 1], binding);
            }
            ++i4;
        }
    }

    public void faultInTypes() {
        this.faultInImports();
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].faultInTypesForFieldsAndMethods();
            ++i;
        }
    }

    private Binding findOnDemandImport(char[][] compoundName) {
        ReferenceBinding type;
        int length;
        int i;
        Binding binding;
        block13: {
            this.recordQualifiedReference(compoundName);
            binding = this.environment.getTopLevelPackage(compoundName[0]);
            i = 1;
            length = compoundName.length;
            if (binding != null) {
                PackageBinding packageBinding = binding;
                while (i < length) {
                    if ((binding = packageBinding.getTypeOrPackage(compoundName[i++])) == null || !binding.isValidBinding()) {
                        binding = null;
                    } else if (binding instanceof PackageBinding) {
                        packageBinding = (PackageBinding)binding;
                        continue;
                    }
                    break block13;
                }
                return packageBinding;
            }
        }
        if (binding == null) {
            if (this.environment.defaultPackage == null || this.environment.options.complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), 1);
            }
            type = this.findType(compoundName[0], this.environment.defaultPackage, this.environment.defaultPackage);
            if (type == null || !type.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), 1);
            }
            i = 1;
        } else {
            type = (ReferenceBinding)binding;
        }
        while (i < length) {
            if (!type.canBeSeenBy(this.fPackage)) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i), type, 2);
            }
            if ((type = type.getMemberType(compoundName[i])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, i + 1), 1);
            }
            ++i;
        }
        if (!type.canBeSeenBy(this.fPackage)) {
            return new ProblemReferenceBinding(compoundName, type, 2);
        }
        return type;
    }

    private Binding findSingleTypeImport(char[][] compoundName) {
        if (compoundName.length == 1) {
            if (this.environment.defaultPackage == null || this.environment.options.complianceLevel >= 0x300000L) {
                return new ProblemReferenceBinding(compoundName, 1);
            }
            ReferenceBinding typeBinding = this.findType(compoundName[0], this.environment.defaultPackage, this.fPackage);
            if (typeBinding == null) {
                return new ProblemReferenceBinding(compoundName, 1);
            }
            return typeBinding;
        }
        return this.findOnDemandImport(compoundName);
    }

    ImportBinding[] getDefaultImports() {
        if (this.environment.defaultImports != null) {
            return this.environment.defaultImports;
        }
        Binding importBinding = this.environment.getTopLevelPackage(TypeConstants.JAVA);
        if (importBinding != null) {
            importBinding = importBinding.getTypeOrPackage(TypeConstants.JAVA_LANG[1]);
        }
        if (importBinding == null || !importBinding.isValidBinding()) {
            this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceCompilationUnit());
        }
        this.environment.defaultImports = new ImportBinding[]{new ImportBinding(TypeConstants.JAVA_LANG, true, importBinding, null)};
        return this.environment.defaultImports;
    }

    public ProblemReporter problemReporter() {
        ProblemReporter problemReporter = this.referenceContext.problemReporter;
        problemReporter.referenceContext = this.referenceContext;
        return problemReporter;
    }

    void recordQualifiedReference(char[][] qualifiedName) {
        if (this.qualifiedReferences == null) {
            return;
        }
        int length = qualifiedName.length;
        if (length > 1) {
            while (!this.qualifiedReferences.contains(qualifiedName)) {
                this.qualifiedReferences.add(qualifiedName);
                if (length == 2) {
                    this.recordSimpleReference(qualifiedName[0]);
                    this.recordSimpleReference(qualifiedName[1]);
                    return;
                }
                this.recordSimpleReference(qualifiedName[--length]);
                char[][] cArray = qualifiedName;
                qualifiedName = new char[length][];
                System.arraycopy(cArray, 0, qualifiedName, 0, length);
            }
        } else if (length == 1) {
            this.recordSimpleReference(qualifiedName[0]);
        }
    }

    void recordReference(char[][] qualifiedEnclosingName, char[] simpleName) {
        this.recordQualifiedReference(qualifiedEnclosingName);
        this.recordSimpleReference(simpleName);
    }

    void recordSimpleReference(char[] simpleName) {
        if (this.simpleNameReferences == null) {
            return;
        }
        if (!this.simpleNameReferences.contains(simpleName)) {
            this.simpleNameReferences.add(simpleName);
        }
    }

    public void recordTypeReference(TypeBinding type) {
        if (this.referencedTypes == null) {
            return;
        }
        if (type.isArrayType()) {
            type = ((ArrayBinding)type).leafComponentType;
        }
        if (type.isBaseType()) {
            return;
        }
        if (this.referencedTypes.containsIdentical(type)) {
            return;
        }
        if (((ReferenceBinding)type).isLocalType()) {
            return;
        }
        this.referencedTypes.add(type);
    }

    void recordTypeReferences(TypeBinding[] types) {
        if (this.qualifiedReferences == null) {
            return;
        }
        if (types == null || types.length == 0) {
            return;
        }
        int i = 0;
        int max = types.length;
        while (i < max) {
            ReferenceBinding actualType;
            TypeBinding type = types[i];
            if (type.isArrayType()) {
                type = ((ArrayBinding)type).leafComponentType;
            }
            if (!type.isBaseType() && !(actualType = (ReferenceBinding)type).isLocalType()) {
                this.recordQualifiedReference(actualType.isMemberType() ? CharOperation.splitOn('.', actualType.readableName()) : actualType.compoundName);
            }
            ++i;
        }
    }

    Binding resolveSingleTypeImport(ImportBinding importBinding) {
        if (importBinding.resolvedImport == null) {
            importBinding.resolvedImport = this.findSingleTypeImport(importBinding.compoundName);
            if (!importBinding.resolvedImport.isValidBinding() || importBinding.resolvedImport instanceof PackageBinding) {
                if (this.imports != null) {
                    ImportBinding[] newImports = new ImportBinding[this.imports.length - 1];
                    int i = 0;
                    int n = 0;
                    int max = this.imports.length;
                    while (i < max) {
                        if (this.imports[i] != importBinding) {
                            newImports[n++] = this.imports[i];
                        }
                        ++i;
                    }
                    this.imports = newImports;
                }
                return null;
            }
        }
        return importBinding.resolvedImport;
    }

    public void storeDependencyInfo() {
        int i = 0;
        while (i < this.referencedTypes.size) {
            ReferenceBinding[] interfaces;
            ReferenceBinding superclass;
            ReferenceBinding type = (ReferenceBinding)this.referencedTypes.elementAt(i);
            if (!type.isLocalType()) {
                this.recordQualifiedReference(type.isMemberType() ? CharOperation.splitOn('.', type.readableName()) : type.compoundName);
                ReferenceBinding enclosing = type.enclosingType();
                if (enclosing != null && !this.referencedTypes.containsIdentical(enclosing)) {
                    this.referencedTypes.add(enclosing);
                }
            }
            if ((superclass = type.superclass()) != null && !this.referencedTypes.containsIdentical(superclass)) {
                this.referencedTypes.add(superclass);
            }
            if ((interfaces = type.superInterfaces()) != null && interfaces.length > 0) {
                int j = 0;
                int length = interfaces.length;
                while (j < length) {
                    if (!this.referencedTypes.containsIdentical(interfaces[j])) {
                        this.referencedTypes.add(interfaces[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int size = this.qualifiedReferences.size;
        char[][][] qualifiedRefs = new char[size][][];
        int i2 = 0;
        while (i2 < size) {
            qualifiedRefs[i2] = this.qualifiedReferences.elementAt(i2);
            ++i2;
        }
        this.referenceContext.compilationResult.qualifiedReferences = qualifiedRefs;
        size = this.simpleNameReferences.size;
        char[][] simpleRefs = new char[size][];
        int i3 = 0;
        while (i3 < size) {
            simpleRefs[i3] = this.simpleNameReferences.elementAt(i3);
            ++i3;
        }
        this.referenceContext.compilationResult.simpleNameReferences = simpleRefs;
    }

    public String toString() {
        return "--- CompilationUnit Scope : " + new String(this.referenceContext.getFileName());
    }

    public void verifyMethods(MethodVerifier verifier) {
        int i = 0;
        int length = this.topLevelTypes.length;
        while (i < length) {
            this.topLevelTypes[i].verifyMethods(verifier);
            ++i;
        }
    }
}

