/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LocalVariableBinding
extends VariableBinding {
    public boolean isArgument;
    public int resolvedPosition;
    public static final int UNUSED = 0;
    public static final int USED = 1;
    public static final int FAKE_USED = 2;
    public int useFlag;
    public BlockScope declaringScope;
    public LocalDeclaration declaration;
    public int[] initializationPCs;
    public int initializationCount = 0;

    public LocalVariableBinding(char[] name, TypeBinding type, int modifiers, boolean isArgument) {
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
        this.isArgument = isArgument;
        if (isArgument) {
            this.constant = Constant.NotAConstant;
        }
    }

    public LocalVariableBinding(LocalDeclaration declaration, TypeBinding type, int modifiers, boolean isArgument) {
        this(declaration.name, type, modifiers, isArgument);
        this.declaration = declaration;
    }

    public final int bindingType() {
        return 2;
    }

    public boolean isSecret() {
        return this.declaration == null && !this.isArgument;
    }

    public void recordInitializationEndPC(int pc) {
        if (this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == -1) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = pc;
        }
    }

    public void recordInitializationStartPC(int pc) {
        if (this.initializationPCs == null) {
            return;
        }
        if (this.initializationCount > 0 && this.initializationPCs[(this.initializationCount - 1 << 1) + 1] == pc) {
            this.initializationPCs[(this.initializationCount - 1 << 1) + 1] = -1;
        } else {
            int index = this.initializationCount << 1;
            if (index == this.initializationPCs.length) {
                this.initializationPCs = new int[this.initializationCount << 2];
                System.arraycopy(this.initializationPCs, 0, this.initializationPCs, 0, index);
            }
            this.initializationPCs[index] = pc;
            this.initializationPCs[index + 1] = -1;
            ++this.initializationCount;
        }
    }

    public String toString() {
        String s = super.toString();
        switch (this.useFlag) {
            case 1: {
                s = String.valueOf(s) + "[pos: " + String.valueOf(this.resolvedPosition) + "]";
                break;
            }
            case 0: {
                s = String.valueOf(s) + "[pos: unused]";
                break;
            }
            case 2: {
                s = String.valueOf(s) + "[pos: fake_used]";
            }
        }
        s = String.valueOf(s) + "[id:" + String.valueOf(this.id) + "]";
        if (this.initializationCount > 0) {
            s = String.valueOf(s) + "[pc: ";
            int i = 0;
            while (i < this.initializationCount) {
                if (i > 0) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + String.valueOf(this.initializationPCs[i << 1]) + "-" + (this.initializationPCs[(i << 1) + 1] == -1 ? "?" : String.valueOf(this.initializationPCs[(i << 1) + 1]));
                ++i;
            }
            s = String.valueOf(s) + "]";
        }
        return s;
    }
}

