/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class JavaProjectElementInfo
extends OpenableElementInfo {
    private Object[] nonJavaResources = null;
    public IPackageFragmentRoot[] allPkgFragmentRootsCache;
    private HashMap allPkgFragmentsCache;

    private Object[] computeNonJavaResources(JavaProject project) {
        IPath projectPath = project.getProject().getFullPath();
        boolean srcIsProject = false;
        boolean binIsProject = false;
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = null;
        IClasspathEntry[] classpath = null;
        IPath projectOutput = null;
        try {
            classpath = project.getResolvedClasspath(true, false, false);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry entry = classpath[i];
                if (projectPath.equals((Object)entry.getPath())) {
                    srcIsProject = true;
                    inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                    exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                    break;
                }
                ++i;
            }
            projectOutput = project.getOutputLocation();
            binIsProject = projectPath.equals((Object)projectOutput);
        }
        catch (JavaModelException i) {
            // empty catch block
        }
        Object[] resources = new IResource[5];
        int resourcesCounter = 0;
        try {
            IResource[] members = ((IContainer)project.getResource()).members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource res = members[i];
                switch (res.getType()) {
                    case 1: {
                        IPath resFullPath = res.getFullPath();
                        String resName = res.getName();
                        if (org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resName) && this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput) || srcIsProject && Util.isValidCompilationUnitName(resName) && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) || binIsProject && Util.isValidClassFileName(resName)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                        break;
                    }
                    case 2: {
                        IPath resFullPath = res.getFullPath();
                        if (srcIsProject && !Util.isExcluded(res, inclusionPatterns, exclusionPatterns) && Util.isValidFolderNameForPackage(res.getName()) || this.isClasspathEntryOrOutputLocation(resFullPath, classpath, projectOutput)) break;
                        if (resources.length == resourcesCounter) {
                            Object[] objectArray = resources;
                            resources = new IResource[resourcesCounter * 2];
                            System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
                        }
                        resources[resourcesCounter++] = res;
                    }
                }
                ++i;
            }
            if (resources.length != resourcesCounter) {
                Object[] objectArray = resources;
                resources = new IResource[resourcesCounter];
                System.arraycopy(objectArray, 0, resources, 0, resourcesCounter);
            }
        }
        catch (CoreException e) {
            resources = JavaElementInfo.NO_NON_JAVA_RESOURCES;
            resourcesCounter = 0;
        }
        return resources;
    }

    IPackageFragmentRoot[] getAllPackageFragmentRoots(JavaProject project) {
        if (this.allPkgFragmentRootsCache == null) {
            try {
                this.allPkgFragmentRootsCache = project.getAllPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return this.allPkgFragmentRootsCache;
    }

    HashMap getAllPackageFragments(JavaProject project) {
        if (this.allPkgFragmentsCache == null) {
            HashMap<String, IPackageFragment[]> cache = new HashMap<String, IPackageFragment[]>();
            IPackageFragmentRoot[] roots = this.getAllPackageFragmentRoots(project);
            IPackageFragment[] frags = this.getPackageFragmentsInRoots(roots, project);
            int i = 0;
            while (i < frags.length) {
                IPackageFragment fragment = frags[i];
                IPackageFragment[] entry = (IPackageFragment[])cache.get(fragment.getElementName());
                if (entry == null) {
                    entry = new IPackageFragment[]{fragment};
                    cache.put(fragment.getElementName(), entry);
                } else {
                    IPackageFragment[] copy = new IPackageFragment[entry.length + 1];
                    System.arraycopy(entry, 0, copy, 0, entry.length);
                    copy[entry.length] = fragment;
                    cache.put(fragment.getElementName(), copy);
                }
                ++i;
            }
            this.allPkgFragmentsCache = cache;
        }
        return this.allPkgFragmentsCache;
    }

    Object[] getNonJavaResources(JavaProject project) {
        if (this.nonJavaResources == null) {
            this.nonJavaResources = this.computeNonJavaResources(project);
        }
        return this.nonJavaResources;
    }

    private IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots, IJavaProject project) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaElement[] pkgs = root.getChildren();
                int length = pkgs.length;
                if (length != 0) {
                    int j;
                    if (pkgs[0].getParent().getParent().equals(project)) {
                        j = 0;
                        while (j < length) {
                            frags.add(pkgs[j]);
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < length) {
                            frags.add(root.getPackageFragment(pkgs[j].getElementName()));
                            ++j;
                        }
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    private boolean isClasspathEntryOrOutputLocation(IPath path, IClasspathEntry[] resolvedClasspath, IPath projectOutput) {
        if (projectOutput.equals((Object)path)) {
            return true;
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            IClasspathEntry entry = resolvedClasspath[i];
            if (entry.getPath().equals((Object)path)) {
                return true;
            }
            IPath output = entry.getOutputLocation();
            if (output != null && output.equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void resetCaches() {
        this.allPkgFragmentRootsCache = null;
        this.allPkgFragmentsCache = null;
    }

    void setNonJavaResources(Object[] resources) {
        this.nonJavaResources = resources;
    }
}

