/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.builder;

import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;
import org.aspectj.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.aspectj.org.eclipse.jdt.internal.core.util.SimpleLookupTable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class ClasspathDirectory
extends ClasspathLocation {
    IContainer binaryFolder;
    boolean isOutputFolder;
    String binaryLocation;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];

    ClasspathDirectory(IContainer binaryFolder, boolean isOutputFolder) {
        this.binaryFolder = binaryFolder;
        this.isOutputFolder = isOutputFolder;
        IPath location = binaryFolder.getLocation();
        this.binaryLocation = location != null ? location.addTrailingSeparator().toString() : "";
        this.directoryCache = new SimpleLookupTable(5);
    }

    public void cleanup() {
        this.directoryCache = null;
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer && !this.isExcluded(container)) {
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                int i = 0;
                int l = members.length;
                while (i < l) {
                    IResource m = members[i];
                    if (m.getType() == 1 && Util.isClassFileName(m.getName())) {
                        dirList[index++] = m.getName();
                    }
                    ++i;
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName, String qualifiedFullName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathDirectory)) {
            return false;
        }
        return this.binaryFolder.equals((Object)((ClasspathDirectory)o).binaryFolder);
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        block7: {
            if (!this.doesFileExist(binaryFileName, qualifiedPackageName, qualifiedBinaryFileName)) {
                return null;
            }
            try {
                ClassFileReader reader = ClassFileReader.read(String.valueOf(this.binaryLocation) + qualifiedBinaryFileName);
                if (reader != null) {
                    return new NameEnvironmentAnswer(reader);
                }
            }
            catch (Exception e) {
                IPath location;
                IResource file;
                if (!(this.binaryFolder instanceof IProject) || !((file = this.binaryFolder.findMember(qualifiedBinaryFileName)) instanceof IFile) || (location = file.getLocation()) == null) break block7;
                try {
                    ClassFileReader reader = ClassFileReader.read(location.toString());
                    if (reader != null) {
                        return new NameEnvironmentAnswer(reader);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        return this.binaryFolder.getProjectRelativePath();
    }

    protected boolean isExcluded(IResource resource) {
        return false;
    }

    public boolean isOutputFolder() {
        return this.isOutputFolder;
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Binary classpath directory " + this.binaryFolder.getFullPath().toString();
    }
}

