/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.index.EntryResult;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public class MethodPattern
extends JavaSearchPattern
implements IIndexConstants {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] selector;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[] returnQualification;
    public char[] returnSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    protected IType declaringType;
    protected static char[][] REF_CATEGORIES = new char[][]{IIndexConstants.METHOD_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{IIndexConstants.METHOD_REF, IIndexConstants.METHOD_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{IIndexConstants.METHOD_DECL};

    public static char[] createIndexKey(char[] selector, int argCount) {
        char[] countChars = argCount < 10 ? IIndexConstants.COUNTS[argCount] : ("/" + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(selector, countChars);
    }

    public MethodPattern(boolean findDeclarations, boolean findReferences, char[] selector, char[] declaringQualification, char[] declaringSimpleName, char[] returnQualification, char[] returnSimpleName, char[][] parameterQualifications, char[][] parameterSimpleNames, IType declaringType, int matchRule) {
        this(matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.selector = this.isCaseSensitive() ? selector : CharOperation.toLowerCase(selector);
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.returnQualification = this.isCaseSensitive() ? returnQualification : CharOperation.toLowerCase(returnQualification);
        char[] cArray = this.returnSimpleName = this.isCaseSensitive() ? returnSimpleName : CharOperation.toLowerCase(returnSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterCount = parameterSimpleNames.length;
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterQualifications[i] = this.isCaseSensitive() ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = this.isCaseSensitive() ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.declaringType = declaringType;
        this.mustResolve = this.mustResolve();
    }

    MethodPattern(int matchRule) {
        super(128, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int size = key.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', key);
        this.parameterCount = Integer.parseInt(new String(key, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.selector = CharOperation.subarray(key, 0, lastSeparatorIndex);
    }

    public SearchPattern getBlankPattern() {
        return new MethodPattern(8);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean isPolymorphicSearch() {
        return this.findReferences;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        MethodPattern pattern = (MethodPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1) && this.matchesName(this.selector, pattern.selector);
    }

    protected boolean mustResolve() {
        if (this.declaringSimpleName != null || this.declaringQualification != null) {
            return true;
        }
        if (this.returnSimpleName != null || this.returnQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (this.parameterQualifications[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.selector;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.selector != null && this.parameterCount >= 0) {
                    key = MethodPattern.createIndexKey(this.selector, this.parameterCount);
                    break;
                }
                matchRule = matchRule - 0 + 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0) {
                    key = MethodPattern.createIndexKey(this.selector == null ? IIndexConstants.ONE_STAR : this.selector, this.parameterCount);
                    break;
                }
                if (this.selector == null || this.selector[this.selector.length - 1] == '*') break;
                key = CharOperation.concat(this.selector, IIndexConstants.ONE_STAR, '/');
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "MethodCombinedPattern: " : "MethodDeclarationPattern: ");
        } else {
            buffer.append("MethodReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName).append('.');
        } else if (this.declaringQualification != null) {
            buffer.append("*.");
        }
        if (this.selector != null) {
            buffer.append(this.selector);
        } else {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int i = 0;
            int max = this.parameterSimpleNames.length;
            while (i < max) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                } else {
                    buffer.append(this.parameterSimpleNames[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.returnQualification != null) {
            buffer.append(" --> ").append(this.returnQualification).append('.');
        } else if (this.returnSimpleName != null) {
            buffer.append(" --> ");
        }
        if (this.returnSimpleName != null) {
            buffer.append(this.returnSimpleName);
        } else if (this.returnQualification != null) {
            buffer.append("*");
        }
        buffer.append(", ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

