/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchMatch;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ConstructorLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.FieldLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.LocalVariableLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.LocalVariablePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.OrLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageDeclarationLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeReferenceLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;
import org.eclipse.core.runtime.CoreException;

public abstract class PatternLocator
implements IIndexConstants {
    protected int matchMode;
    protected boolean isCaseSensitive;
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int INACCURATE_MATCH = 1;
    public static final int POSSIBLE_MATCH = 2;
    public static final int ACCURATE_MATCH = 3;
    public static final int COMPILATION_UNIT_CONTAINER = 1;
    public static final int CLASS_CONTAINER = 2;
    public static final int METHOD_CONTAINER = 4;
    public static final int FIELD_CONTAINER = 8;
    public static final int ALL_CONTAINER = 15;

    public static PatternLocator patternLocator(SearchPattern pattern) {
        switch (pattern.kind) {
            case 1: {
                return new PackageReferenceLocator((PackageReferencePattern)pattern);
            }
            case 2: {
                return new PackageDeclarationLocator((PackageDeclarationPattern)pattern);
            }
            case 4: {
                return new TypeReferenceLocator((TypeReferencePattern)pattern);
            }
            case 8: {
                return new TypeDeclarationLocator((TypeDeclarationPattern)pattern);
            }
            case 16: {
                return new SuperTypeReferenceLocator((SuperTypeReferencePattern)pattern);
            }
            case 32: {
                return new ConstructorLocator((ConstructorPattern)pattern);
            }
            case 64: {
                return new FieldLocator((FieldPattern)pattern);
            }
            case 128: {
                return new MethodLocator((MethodPattern)pattern);
            }
            case 256: {
                return new OrLocator((OrPattern)pattern);
            }
            case 512: {
                return new LocalVariableLocator((LocalVariablePattern)pattern);
            }
        }
        return null;
    }

    public static char[] qualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
        if (simpleNamePattern == null) {
            if (qualificationPattern == null) {
                return null;
            }
            return CharOperation.concat(qualificationPattern, IIndexConstants.ONE_STAR, '.');
        }
        return qualificationPattern == null ? CharOperation.concat(IIndexConstants.ONE_STAR, simpleNamePattern) : CharOperation.concat(qualificationPattern, simpleNamePattern, '.');
    }

    public static char[] qualifiedSourceName(TypeBinding binding) {
        ReferenceBinding type;
        if (binding instanceof ReferenceBinding && (type = (ReferenceBinding)binding).isLocalType()) {
            return type.isMemberType() ? CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), type.sourceName(), '.') : CharOperation.concat(PatternLocator.qualifiedSourceName(type.enclosingType()), new char[]{'.', '1', '.'}, type.sourceName());
        }
        return binding != null ? binding.qualifiedSourceName() : null;
    }

    public PatternLocator(SearchPattern pattern) {
        int matchRule = pattern.getMatchRule();
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.matchMode = matchRule - (this.isCaseSensitive ? 8 : 0);
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
    }

    public int match(ASTNode node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(ConstructorDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Expression node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(FieldDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(Reference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeDeclaration node, MatchingNodeSet nodeSet) {
        return 0;
    }

    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        return 0;
    }

    protected int matchContainer() {
        return 15;
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name != null) {
            switch (this.matchMode) {
                case 0: {
                    return CharOperation.equals(pattern, name, this.isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(pattern, name, this.isCaseSensitive);
                }
                case 2: {
                    if (!this.isCaseSensitive) {
                        pattern = CharOperation.toLowerCase(pattern);
                    }
                    return CharOperation.match(pattern, name, this.isCaseSensitive);
                }
            }
        }
        return false;
    }

    protected boolean matchesTypeReference(char[] pattern, TypeReference type) {
        if (pattern == null) {
            return true;
        }
        if (type == null) {
            return true;
        }
        char[][] compoundName = type.getTypeName();
        char[] simpleName = compoundName[compoundName.length - 1];
        int dimensions = type.dimensions() * 2;
        if (dimensions > 0) {
            int length = simpleName.length;
            char[] result = new char[length + dimensions];
            System.arraycopy(simpleName, 0, result, 0, length);
            int i = length;
            int l = result.length;
            while (i < l) {
                result[i++] = 91;
                result[i++] = 93;
            }
            simpleName = result;
        }
        return this.matchesName(pattern, simpleName);
    }

    protected int matchLevel(ImportReference importRef) {
        return 0;
    }

    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        int level = this.resolveLevel(binding);
        if (level >= 1) {
            this.matchReportImportRef(importRef, binding, locator.createImportHandle(importRef), level == 3 ? 0 : 1, locator);
        }
    }

    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (locator.encloses(element)) {
            this.matchReportReference(importRef, element, accuracy, locator);
        }
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        SearchMatch match = null;
        int referenceType = this.referenceType();
        int offset = reference.sourceStart;
        switch (referenceType) {
            case 4: {
                match = locator.newPackageReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 7: {
                match = locator.newTypeReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 8: {
                match = locator.newFieldReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 9: {
                match = locator.newMethodReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
                break;
            }
            case 14: {
                match = locator.newLocalVariableReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            }
        }
        if (match != null) {
            locator.report(match);
        }
    }

    protected int referenceType() {
        return 0;
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        return 0;
    }

    public int resolveLevel(Binding binding) {
        return 1;
    }

    protected int resolveLevelForType(char[] simpleNamePattern, char[] qualificationPattern, TypeBinding type) {
        return this.resolveLevelForType(PatternLocator.qualifiedPattern(simpleNamePattern, qualificationPattern), type);
    }

    protected int resolveLevelForType(char[] qualifiedPattern, TypeBinding type) {
        if (qualifiedPattern == null) {
            return 3;
        }
        if (type == null) {
            return 1;
        }
        char[] qualifiedPackageName = type.qualifiedPackageName();
        char[] qualifiedSourceName = PatternLocator.qualifiedSourceName(type);
        char[] fullyQualifiedTypeName = qualifiedPackageName.length == 0 ? qualifiedSourceName : CharOperation.concat(qualifiedPackageName, qualifiedSourceName, '.');
        return CharOperation.match(qualifiedPattern, fullyQualifiedTypeName, this.isCaseSensitive) ? 3 : 0;
    }

    public String toString() {
        return "SearchPattern";
    }
}

