/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.IRelationship;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.util.PartialOrder;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.bcel.BcelAdvice;

public abstract class Shadow {
    private final Kind kind;
    private final Member signature;
    protected final Shadow enclosingShadow;
    protected List mungers = new ArrayList(1);
    public static final Kind MethodCall = new Kind("method-call", 1, true);
    public static final Kind ConstructorCall = new Kind("constructor-call", 2, true);
    public static final Kind MethodExecution = new Kind("method-execution", 3, false);
    public static final Kind ConstructorExecution = new Kind("constructor-execution", 4, false);
    public static final Kind FieldGet = new Kind("field-get", 5, true);
    public static final Kind FieldSet = new Kind("field-set", 6, true);
    public static final Kind StaticInitialization = new Kind("staticinitialization", 7, false);
    public static final Kind PreInitialization = new Kind("preinitialization", 8, false);
    public static final Kind AdviceExecution = new Kind("advice-execution", 9, false);
    public static final Kind Initialization = new Kind("initialization", 10, false);
    public static final Kind ExceptionHandler = new Kind("exception-handler", 11, true);
    public static final int MAX_SHADOW_KIND = 11;
    public static final Kind[] SHADOW_KINDS = new Kind[]{MethodCall, ConstructorCall, MethodExecution, ConstructorExecution, FieldGet, FieldSet, StaticInitialization, PreInitialization, AdviceExecution, Initialization, ExceptionHandler};

    protected Shadow(Kind kind, Member signature, Shadow enclosingShadow) {
        this.kind = kind;
        this.signature = signature;
        this.enclosingShadow = enclosingShadow;
    }

    public abstract World getIWorld();

    public List getMungers() {
        return this.mungers;
    }

    public final boolean hasThis() {
        if (this.getKind().neverHasThis()) {
            return false;
        }
        if (this.getKind().isEnclosingKind()) {
            return !this.getSignature().isStatic();
        }
        if (this.enclosingShadow == null) {
            return false;
        }
        return this.enclosingShadow.hasThis();
    }

    public final TypeX getThisType() {
        if (!this.hasThis()) {
            throw new IllegalStateException("no this");
        }
        if (this.getKind().isEnclosingKind()) {
            return this.getSignature().getDeclaringType();
        }
        return this.enclosingShadow.getThisType();
    }

    public abstract Var getThisVar();

    public final boolean hasTarget() {
        if (this.getKind().neverHasTarget()) {
            return false;
        }
        if (this.getKind().isTargetSameAsThis()) {
            return this.hasThis();
        }
        return !this.getSignature().isStatic();
    }

    public final TypeX getTargetType() {
        if (!this.hasTarget()) {
            throw new IllegalStateException("no target");
        }
        return this.getSignature().getDeclaringType();
    }

    public abstract Var getTargetVar();

    public TypeX[] getArgTypes() {
        if (this.getKind() == FieldSet) {
            return new TypeX[]{this.getSignature().getReturnType()};
        }
        return this.getSignature().getParameterTypes();
    }

    public TypeX getArgType(int arg) {
        if (this.getKind() == FieldSet) {
            return this.getSignature().getReturnType();
        }
        return this.getSignature().getParameterTypes()[arg];
    }

    public int getArgCount() {
        if (this.getKind() == FieldSet) {
            return 1;
        }
        return this.getSignature().getParameterTypes().length;
    }

    public abstract TypeX getEnclosingType();

    public abstract Var getArgVar(int var1);

    public abstract Var getThisJoinPointVar();

    public abstract Var getThisJoinPointStaticPartVar();

    public abstract Var getThisEnclosingJoinPointStaticPartVar();

    public abstract Member getEnclosingCodeSignature();

    public Kind getKind() {
        return this.kind;
    }

    public Member getSignature() {
        return this.signature;
    }

    public TypeX getReturnType() {
        if (this.kind == ConstructorCall) {
            return this.getSignature().getDeclaringType();
        }
        if (this.kind == FieldSet) {
            return ResolvedTypeX.VOID;
        }
        return this.getSignature().getReturnType();
    }

    protected boolean checkMunger(ShadowMunger munger) {
        Iterator i = munger.getThrownExceptions().iterator();
        while (i.hasNext()) {
            if (this.checkCanThrow(munger, (ResolvedTypeX)i.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean checkCanThrow(ShadowMunger munger, ResolvedTypeX resolvedTypeX) {
        if (this.getKind() == ExceptionHandler) {
            return true;
        }
        if (!this.isDeclaredException(resolvedTypeX, this.getSignature())) {
            this.getIWorld().showMessage(IMessage.ERROR, WeaverMessages.format("cantThrowChecked", resolvedTypeX, this), this.getSourceLocation(), munger.getSourceLocation());
        }
        return true;
    }

    private boolean isDeclaredException(ResolvedTypeX resolvedTypeX, Member member) {
        ResolvedTypeX[] excs = this.getIWorld().resolve(member.getExceptions(this.getIWorld()));
        int len = excs.length;
        for (int i = 0; i < len; ++i) {
            if (!excs[i].isAssignableFrom(resolvedTypeX)) continue;
            return true;
        }
        return false;
    }

    public void addMunger(ShadowMunger munger) {
        if (this.checkMunger(munger)) {
            this.mungers.add(munger);
        }
    }

    public final void implement() {
        this.sortMungers();
        if (this.mungers == null) {
            return;
        }
        this.prepareForMungers();
        this.implementMungers();
    }

    private void sortMungers() {
        List sorted = PartialOrder.sort(this.mungers);
        if (sorted == null) {
            Iterator i = this.mungers.iterator();
            while (i.hasNext()) {
                ShadowMunger m = (ShadowMunger)i.next();
                this.getIWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("circularDependency", this), m.getSourceLocation()));
            }
        }
        this.mungers = sorted;
    }

    protected void prepareForMungers() {
        throw new RuntimeException("Generic shadows cannot be prepared");
    }

    private String beautifyLocation(ISourceLocation isl) {
        StringBuffer nice = new StringBuffer();
        if (isl == null || isl.getSourceFile() == null || isl.getSourceFile().getName().indexOf("no debug info available") != -1) {
            nice.append("no debug info available");
        } else {
            int takeFrom = isl.getSourceFile().getPath().lastIndexOf(47);
            if (takeFrom == -1) {
                takeFrom = isl.getSourceFile().getPath().lastIndexOf(92);
            }
            nice.append(isl.getSourceFile().getPath().substring(takeFrom + 1));
            if (isl.getLine() != 0) {
                nice.append(":").append(isl.getLine());
            }
        }
        return nice.toString();
    }

    private void reportWeavingMessage(ShadowMunger munger) {
        Advice advice = (Advice)munger;
        AdviceKind aKind = advice.getKind();
        if (aKind == null || advice.getConcreteAspect() == null) {
            return;
        }
        if (!(aKind.equals(AdviceKind.Before) || aKind.equals(AdviceKind.After) || aKind.equals(AdviceKind.AfterReturning) || aKind.equals(AdviceKind.AfterThrowing) || aKind.equals(AdviceKind.Around) || aKind.equals(AdviceKind.Softener))) {
            return;
        }
        String description = advice.getKind().toString();
        String advisedType = this.getEnclosingType().getName();
        String advisingType = advice.getConcreteAspect().getName();
        WeaveMessage msg = null;
        if (advice.getKind().equals(AdviceKind.Softener)) {
            msg = WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_SOFTENS, new String[]{advisedType, this.beautifyLocation(this.getSourceLocation()), advisingType, this.beautifyLocation(munger.getSourceLocation())});
        } else {
            boolean runtimeTest = ((BcelAdvice)advice).hasDynamicTests();
            msg = WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_ADVISES, new String[]{advisedType, this.beautifyLocation(this.getSourceLocation()), description, advisingType, this.beautifyLocation(munger.getSourceLocation()), runtimeTest ? " [with runtime test]" : ""});
        }
        this.getIWorld().getMessageHandler().handleMessage(msg);
    }

    public IRelationship.Kind determineRelKind(ShadowMunger munger) {
        AdviceKind ak = ((Advice)munger).getKind();
        if (ak.getKey() == AdviceKind.Before.getKey()) {
            return IRelationship.Kind.ADVICE_BEFORE;
        }
        if (ak.getKey() == AdviceKind.After.getKey()) {
            return IRelationship.Kind.ADVICE_AFTER;
        }
        if (ak.getKey() == AdviceKind.AfterThrowing.getKey()) {
            return IRelationship.Kind.ADVICE_AFTERTHROWING;
        }
        if (ak.getKey() == AdviceKind.AfterReturning.getKey()) {
            return IRelationship.Kind.ADVICE_AFTERRETURNING;
        }
        if (ak.getKey() == AdviceKind.Around.getKey()) {
            return IRelationship.Kind.ADVICE_AROUND;
        }
        if (ak.getKey() == AdviceKind.CflowEntry.getKey() || ak.getKey() == AdviceKind.CflowBelowEntry.getKey() || ak.getKey() == AdviceKind.InterInitializer.getKey() || ak.getKey() == AdviceKind.PerCflowEntry.getKey() || ak.getKey() == AdviceKind.PerCflowBelowEntry.getKey() || ak.getKey() == AdviceKind.PerThisEntry.getKey() || ak.getKey() == AdviceKind.PerTargetEntry.getKey() || ak.getKey() == AdviceKind.Softener.getKey()) {
            System.err.println("Dont want a message about this: " + ak);
            return null;
        }
        throw new RuntimeException("Shadow.determineRelKind: What the hell is it? " + ak);
    }

    private void implementMungers() {
        World world = this.getIWorld();
        Iterator iter = this.mungers.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            munger.implementOn(this);
            if (world.xrefHandler != null) {
                world.xrefHandler.addCrossReference(munger.getSourceLocation(), this.getSourceLocation(), this.determineRelKind(munger), ((BcelAdvice)munger).hasDynamicTests());
            }
            if (!this.getIWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
                this.reportWeavingMessage(munger);
            }
            if (world.getModel() == null) continue;
            AsmRelationshipProvider.getDefault().adviceMunger(world.getModel(), this, munger);
        }
    }

    public String makeReflectiveFactoryString() {
        return null;
    }

    public abstract ISourceLocation getSourceLocation();

    public String toString() {
        return this.getKind() + "(" + this.getSignature() + ")";
    }

    public static final class Kind
    extends TypeSafeEnum {
        private boolean argsOnStack;

        public Kind(String name, int key, boolean argsOnStack) {
            super(name, key);
            this.argsOnStack = argsOnStack;
        }

        public String toLegalJavaIdentifier() {
            return this.getName().replace('-', '_');
        }

        public boolean argsOnStack() {
            return !this.isTargetSameAsThis();
        }

        public boolean allowsExtraction() {
            return true;
        }

        public boolean hasHighPriorityExceptions() {
            return !this.isTargetSameAsThis();
        }

        public boolean isEnclosingKind() {
            return this == MethodExecution || this == ConstructorExecution || this == AdviceExecution || this == StaticInitialization || this == Initialization;
        }

        public boolean isTargetSameAsThis() {
            return this == MethodExecution || this == ConstructorExecution || this == StaticInitialization || this == PreInitialization || this == AdviceExecution || this == Initialization;
        }

        public boolean neverHasTarget() {
            return this == ConstructorCall || this == ExceptionHandler || this == PreInitialization || this == StaticInitialization;
        }

        public boolean neverHasThis() {
            return this == PreInitialization || this == StaticInitialization;
        }

        public String getSimpleName() {
            int dash = this.getName().lastIndexOf(45);
            if (dash == -1) {
                return this.getName();
            }
            return this.getName().substring(dash + 1);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return MethodCall;
                }
                case 2: {
                    return ConstructorCall;
                }
                case 3: {
                    return MethodExecution;
                }
                case 4: {
                    return ConstructorExecution;
                }
                case 5: {
                    return FieldGet;
                }
                case 6: {
                    return FieldSet;
                }
                case 7: {
                    return StaticInitialization;
                }
                case 8: {
                    return PreInitialization;
                }
                case 9: {
                    return AdviceExecution;
                }
                case 10: {
                    return Initialization;
                }
                case 11: {
                    return ExceptionHandler;
                }
            }
            throw new BCException("unknown kind: " + key);
        }
    }
}

