/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelTypeMunger;

public class WeaverStateInfo {
    private List typeMungers;
    private boolean oldStyle;
    private boolean reweavable;
    private boolean reweavableCompressedMode;
    private Set aspectsAffectingType;
    private byte[] unwovenClassFile;
    private static boolean reweavableDefault = false;
    private static boolean reweavableCompressedModeDefault = false;
    private static final int UNTOUCHED = 0;
    private static final int WOVEN = 2;
    private static final int EXTENDED = 3;
    private static final byte REWEAVABLE_BIT = 16;
    private static final byte REWEAVABLE_COMPRESSION_BIT = 32;

    public WeaverStateInfo() {
        this(new ArrayList(), false, reweavableDefault, reweavableCompressedModeDefault);
    }

    private WeaverStateInfo(List typeMungers, boolean oldStyle, boolean reweavableMode, boolean reweavableCompressedMode) {
        this.typeMungers = typeMungers;
        this.oldStyle = oldStyle;
        this.reweavable = reweavableMode;
        this.reweavableCompressedMode = reweavableCompressedMode;
        this.aspectsAffectingType = new HashSet();
        this.unwovenClassFile = null;
    }

    public static void setReweavableModeDefaults(boolean mode, boolean compress) {
        reweavableDefault = mode;
        reweavableCompressedModeDefault = compress;
    }

    public static final WeaverStateInfo read(DataInputStream s, ISourceContext context) throws IOException {
        boolean isReweavableCompressed;
        boolean isReweavable;
        byte b = s.readByte();
        boolean bl = isReweavable = (b & 0x10) != 0;
        if (isReweavable) {
            b = (byte)(b - 16);
        }
        boolean bl2 = isReweavableCompressed = (b & 0x20) != 0;
        if (isReweavableCompressed) {
            b = (byte)(b - 32);
        }
        switch (b) {
            case 0: {
                throw new RuntimeException("unexpected UNWOVEN");
            }
            case 2: {
                return new WeaverStateInfo(Collections.EMPTY_LIST, true, isReweavable, isReweavableCompressed);
            }
            case 3: {
                int n = s.readShort();
                ArrayList<Entry> l = new ArrayList<Entry>();
                for (int i = 0; i < n; ++i) {
                    TypeX aspectType = TypeX.read(s);
                    ResolvedTypeMunger typeMunger = ResolvedTypeMunger.read(s, context);
                    l.add(new Entry(aspectType, typeMunger));
                }
                WeaverStateInfo wsi = new WeaverStateInfo(l, false, isReweavable, isReweavableCompressed);
                WeaverStateInfo.readAnyReweavableData(wsi, s);
                return wsi;
            }
        }
        throw new RuntimeException("bad WeaverState.Kind: " + b);
    }

    public void write(DataOutputStream s) throws IOException {
        if (this.oldStyle) {
            throw new RuntimeException("shouldn't be writing this");
        }
        int weaverStateInfoKind = 3;
        if (this.reweavable) {
            weaverStateInfoKind = (byte)(weaverStateInfoKind | 0x10);
        }
        if (this.reweavableCompressedMode) {
            weaverStateInfoKind = (byte)(weaverStateInfoKind | 0x20);
        }
        s.writeByte(weaverStateInfoKind);
        int n = this.typeMungers.size();
        s.writeShort(n);
        for (int i = 0; i < n; ++i) {
            Entry e = (Entry)this.typeMungers.get(i);
            e.aspectType.write(s);
            e.typeMunger.write(s);
        }
        WeaverStateInfo.writeAnyReweavableData(this, s);
    }

    public void addConcreteMunger(ConcreteTypeMunger munger) {
        this.typeMungers.add(new Entry(munger.getAspectType(), munger.getMunger()));
    }

    public String toString() {
        return "WeaverStateInfo(" + this.typeMungers + ", " + this.oldStyle + ")";
    }

    public List getTypeMungers(ResolvedTypeX onType) {
        World world = onType.getWorld();
        ArrayList<BcelTypeMunger> ret = new ArrayList<BcelTypeMunger>();
        Iterator i = this.typeMungers.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            ResolvedTypeX aspectType = world.resolve(entry.aspectType, true);
            if (aspectType == ResolvedTypeX.MISSING) {
                world.showMessage(IMessage.ERROR, WeaverMessages.format("aspectNeeded", entry.aspectType, onType), onType.getSourceLocation(), null);
                continue;
            }
            ret.add(new BcelTypeMunger(entry.typeMunger, aspectType));
        }
        return ret;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    public byte[] getUnwovenClassFileData() {
        return this.unwovenClassFile;
    }

    public void setUnwovenClassFileData(byte[] data) {
        this.unwovenClassFile = data;
    }

    public boolean isReweavable() {
        return this.reweavable;
    }

    public void setReweavable(boolean rw, boolean compressData) {
        this.reweavable = rw;
        this.reweavableCompressedMode = compressData;
    }

    public void addAspectsAffectingType(Collection aspects) {
        this.aspectsAffectingType.addAll(aspects);
    }

    public void addAspectAffectingType(String aspectType) {
        this.aspectsAffectingType.add(aspectType);
    }

    public Set getAspectsAffectingType() {
        return this.aspectsAffectingType;
    }

    private static void readAnyReweavableData(WeaverStateInfo wsi, DataInputStream s) throws IOException {
        if (wsi.isReweavable()) {
            int numberAspectsAffectingType = s.readShort();
            for (int i = 0; i < numberAspectsAffectingType; ++i) {
                wsi.addAspectAffectingType(s.readUTF());
            }
            int unwovenClassFileSize = s.readInt();
            byte[] classData = null;
            if (!wsi.reweavableCompressedMode) {
                classData = new byte[unwovenClassFileSize];
                int bytesread = s.read(classData);
                if (bytesread != unwovenClassFileSize) {
                    throw new IOException("ERROR whilst reading reweavable data, expected " + unwovenClassFileSize + " bytes, only found " + bytesread);
                }
            } else {
                int bytesToGo;
                int amount;
                classData = new byte[unwovenClassFileSize];
                ZipInputStream zis = new ZipInputStream(s);
                ZipEntry zen = zis.getNextEntry();
                int current = 0;
                for (bytesToGo = unwovenClassFileSize; bytesToGo > 0; bytesToGo -= amount) {
                    amount = zis.read(classData, current, bytesToGo);
                    current += amount;
                }
                zis.closeEntry();
                if (bytesToGo != 0) {
                    throw new IOException("ERROR whilst reading compressed reweavable data, expected " + unwovenClassFileSize + " bytes, only found " + current);
                }
            }
            wsi.setUnwovenClassFileData(classData);
        }
    }

    private static void writeAnyReweavableData(WeaverStateInfo wsi, DataOutputStream s) throws IOException {
        if (wsi.isReweavable()) {
            s.writeShort(wsi.aspectsAffectingType.size());
            if (wsi.aspectsAffectingType.size() > 0) {
                Iterator iter = wsi.aspectsAffectingType.iterator();
                while (iter.hasNext()) {
                    String type = (String)iter.next();
                    s.writeUTF(type);
                }
            }
            byte[] data = wsi.unwovenClassFile;
            s.writeInt(data.length);
            if (!wsi.reweavableCompressedMode) {
                s.write(wsi.unwovenClassFile);
            } else {
                ZipOutputStream zos = new ZipOutputStream(s);
                ZipEntry ze = new ZipEntry("data");
                zos.putNextEntry(ze);
                zos.write(wsi.unwovenClassFile, 0, wsi.unwovenClassFile.length);
                zos.closeEntry();
            }
        }
    }

    private static class Entry {
        public TypeX aspectType;
        public ResolvedTypeMunger typeMunger;

        public Entry(TypeX aspectType, ResolvedTypeMunger typeMunger) {
            this.aspectType = aspectType;
            this.typeMunger = typeMunger;
        }

        public String toString() {
            return "<" + this.aspectType + ", " + this.typeMunger + ">";
        }
    }
}

