/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.apache.bcel.generic.FieldGen;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.NewMethodTypeMunger;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.PerObjectInterfaceTypeMunger;
import org.aspectj.weaver.PrivilegedAccessMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.Pointcut;

public class BcelTypeMunger
extends ConcreteTypeMunger {
    public BcelTypeMunger(ResolvedTypeMunger munger, ResolvedTypeX aspectType) {
        super(munger, aspectType);
    }

    public String toString() {
        return "(BcelTypeMunger " + this.getMunger() + ")";
    }

    public boolean munge(BcelClassWeaver weaver) {
        boolean changed = false;
        boolean worthReporting = true;
        if (this.munger.getKind() == ResolvedTypeMunger.Field) {
            changed = this.mungeNewField(weaver, (NewFieldTypeMunger)this.munger);
        } else if (this.munger.getKind() == ResolvedTypeMunger.Method) {
            changed = this.mungeNewMethod(weaver, (NewMethodTypeMunger)this.munger);
        } else if (this.munger.getKind() == ResolvedTypeMunger.PerObjectInterface) {
            changed = this.mungePerObjectInterface(weaver, (PerObjectInterfaceTypeMunger)this.munger);
            worthReporting = false;
        } else if (this.munger.getKind() == ResolvedTypeMunger.PrivilegedAccess) {
            changed = this.mungePrivilegedAccess(weaver, (PrivilegedAccessMunger)this.munger);
            worthReporting = false;
        } else if (this.munger.getKind() == ResolvedTypeMunger.Constructor) {
            changed = this.mungeNewConstructor(weaver, (NewConstructorTypeMunger)this.munger);
        } else if (this.munger.getKind() == ResolvedTypeMunger.Parent) {
            changed = this.mungeNewParent(weaver, (NewParentTypeMunger)this.munger);
        } else {
            throw new RuntimeException("unimplemented");
        }
        if (changed && this.munger.changesPublicSignature()) {
            WeaverStateInfo info = weaver.getLazyClassGen().getOrCreateWeaverStateInfo();
            info.addConcreteMunger(this);
        }
        if (ResolvedTypeMunger.persistSourceLocation && changed) {
            if (this.munger.getKind().equals(ResolvedTypeMunger.Parent)) {
                AsmRelationshipProvider.getDefault().addRelationship(weaver.getLazyClassGen().getType(), this.munger, this.getAspectType());
            } else {
                AsmRelationshipProvider.getDefault().addRelationship(weaver.getLazyClassGen().getType(), this.munger, this.getAspectType());
            }
        }
        if (worthReporting && this.munger != null && !weaver.getWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
            String tName = weaver.getLazyClassGen().getType().getSourceLocation().getSourceFile().getName();
            tName = tName.indexOf("no debug info available") != -1 ? "no debug info available" : this.getShortname(weaver.getLazyClassGen().getType().getSourceLocation().getSourceFile().getPath());
            String fName = this.getShortname(this.getAspectType().getSourceLocation().getSourceFile().getPath());
            if (this.munger.getKind().equals(ResolvedTypeMunger.Parent)) {
                NewParentTypeMunger parentTM = (NewParentTypeMunger)this.munger;
                if (parentTM.getNewParent().isInterface()) {
                    weaver.getWorld().getMessageHandler().handleMessage(WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_DECLAREPARENTSIMPLEMENTS, new String[]{weaver.getLazyClassGen().getType().getName(), tName, parentTM.getNewParent().getName(), fName}));
                } else {
                    System.err.println("BANG, you need to fix this.  BcelTypeMunger");
                }
            } else {
                weaver.getWorld().getMessageHandler().handleMessage(WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_ITD, new String[]{weaver.getLazyClassGen().getType().getName(), tName, this.munger.getKind().toString().toLowerCase(), this.getAspectType().getName(), fName + ":'" + this.munger.getSignature() + "'"}));
            }
        }
        return changed;
    }

    private String getShortname(String path) {
        int takefrom = path.lastIndexOf(47);
        if (takefrom == -1) {
            takefrom = path.lastIndexOf(92);
        }
        return path.substring(takefrom + 1);
    }

    private boolean mungeNewParent(BcelClassWeaver weaver, NewParentTypeMunger munger) {
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedTypeX newParent = munger.getNewParent();
        if (!newParent.isClass()) {
            gen.addInterface(newParent, this.getSourceLocation());
        }
        return true;
    }

    private boolean mungePrivilegedAccess(BcelClassWeaver weaver, PrivilegedAccessMunger munger) {
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedMember member = munger.getMember();
        ResolvedTypeX onType = weaver.getWorld().resolve(member.getDeclaringType(), munger.getSourceLocation());
        if (onType.equals(gen.getType())) {
            if (member.getKind() == Member.FIELD) {
                this.addFieldGetter(gen, member, AjcMemberMaker.privilegedAccessMethodForFieldGet(this.aspectType, member));
                this.addFieldSetter(gen, member, AjcMemberMaker.privilegedAccessMethodForFieldSet(this.aspectType, member));
                return true;
            }
            if (member.getKind() == Member.METHOD) {
                this.addMethodDispatch(gen, member, AjcMemberMaker.privilegedAccessMethodForMethod(this.aspectType, member));
                return true;
            }
            if (member.getKind() == Member.CONSTRUCTOR) {
                Iterator i = gen.getMethodGens().iterator();
                while (i.hasNext()) {
                    LazyMethodGen m = (LazyMethodGen)i.next();
                    if (m.getMemberView() == null || m.getMemberView().getKind() != Member.CONSTRUCTOR) continue;
                    m.forcePublic();
                }
                return true;
            }
            if (member.getKind() == Member.STATIC_INITIALIZATION) {
                gen.forcePublic();
                return true;
            }
            throw new RuntimeException("unimplemented");
        }
        return false;
    }

    private void addFieldGetter(LazyClassGen gen, ResolvedMember field, ResolvedMember accessMethod) {
        LazyMethodGen mg = this.makeMethodGen(gen, accessMethod);
        InstructionList il = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        if (field.isStatic()) {
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), BcelWorld.makeBcelType(field.getType()), (short)178));
        } else {
            il.append(InstructionConstants.ALOAD_0);
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), BcelWorld.makeBcelType(field.getType()), (short)180));
        }
        il.append(InstructionFactory.createReturn(BcelWorld.makeBcelType(field.getType())));
        mg.getBody().insert(il);
        gen.addMethodGen(mg, this.getSignature().getSourceLocation());
    }

    private void addFieldSetter(LazyClassGen gen, ResolvedMember field, ResolvedMember accessMethod) {
        LazyMethodGen mg = this.makeMethodGen(gen, accessMethod);
        InstructionList il = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        Type fieldType = BcelWorld.makeBcelType(field.getType());
        if (field.isStatic()) {
            il.append(InstructionFactory.createLoad(fieldType, 0));
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), fieldType, (short)179));
        } else {
            il.append(InstructionConstants.ALOAD_0);
            il.append(InstructionFactory.createLoad(fieldType, 1));
            il.append(fact.createFieldAccess(gen.getClassName(), field.getName(), fieldType, (short)181));
        }
        il.append(InstructionFactory.createReturn(Type.VOID));
        mg.getBody().insert(il);
        gen.addMethodGen(mg, this.getSignature().getSourceLocation());
    }

    private void addMethodDispatch(LazyClassGen gen, ResolvedMember method, ResolvedMember accessMethod) {
        LazyMethodGen mg = this.makeMethodGen(gen, accessMethod);
        InstructionList il = new InstructionList();
        InstructionFactory fact = gen.getFactory();
        Type[] paramTypes = BcelWorld.makeBcelTypes(method.getParameterTypes());
        int pos = 0;
        if (!method.isStatic()) {
            il.append(InstructionConstants.ALOAD_0);
            ++pos;
        }
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            Type paramType = paramTypes[i];
            il.append(InstructionFactory.createLoad(paramType, pos));
            pos += paramType.getSize();
        }
        il.append(Utility.createInvoke(fact, (BcelWorld)this.aspectType.getWorld(), method));
        il.append(InstructionFactory.createReturn(BcelWorld.makeBcelType(method.getReturnType())));
        mg.getBody().insert(il);
        gen.addMethodGen(mg);
    }

    private LazyMethodGen makeMethodGen(LazyClassGen gen, ResolvedMember member) {
        LazyMethodGen ret = new LazyMethodGen(member.getModifiers(), BcelWorld.makeBcelType(member.getReturnType()), member.getName(), BcelWorld.makeBcelTypes(member.getParameterTypes()), TypeX.getNames(member.getExceptions()), gen);
        return ret;
    }

    private FieldGen makeFieldGen(LazyClassGen gen, ResolvedMember member) {
        return new FieldGen(member.getModifiers(), BcelWorld.makeBcelType(member.getReturnType()), member.getName(), gen.getConstantPoolGen());
    }

    private boolean mungePerObjectInterface(BcelClassWeaver weaver, PerObjectInterfaceTypeMunger munger) {
        LazyClassGen gen = weaver.getLazyClassGen();
        if (this.couldMatch(gen.getBcelObjectType(), munger.getTestPointcut())) {
            FieldGen fg = this.makeFieldGen(gen, AjcMemberMaker.perObjectField(gen.getType(), this.aspectType));
            gen.addField(fg.getField(), this.getSourceLocation());
            Type fieldType = BcelWorld.makeBcelType(this.aspectType);
            LazyMethodGen mg = new LazyMethodGen(1, fieldType, NameMangler.perObjectInterfaceGet(this.aspectType), new Type[0], new String[0], gen);
            InstructionList il = new InstructionList();
            InstructionFactory fact = gen.getFactory();
            il.append(InstructionConstants.ALOAD_0);
            il.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)180));
            il.append(InstructionFactory.createReturn(fieldType));
            mg.getBody().insert(il);
            gen.addMethodGen(mg);
            LazyMethodGen mg1 = new LazyMethodGen(1, Type.VOID, NameMangler.perObjectInterfaceSet(this.aspectType), new Type[]{fieldType}, new String[0], gen);
            InstructionList il1 = new InstructionList();
            il1.append(InstructionConstants.ALOAD_0);
            il1.append(InstructionFactory.createLoad(fieldType, 1));
            il1.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)181));
            il1.append(InstructionFactory.createReturn(Type.VOID));
            mg1.getBody().insert(il1);
            gen.addMethodGen(mg1);
            gen.addInterface(munger.getInterfaceType(), this.getSourceLocation());
            return true;
        }
        return false;
    }

    private boolean couldMatch(BcelObjectType bcelObjectType, Pointcut pointcut) {
        return !bcelObjectType.isInterface();
    }

    private boolean mungeNewMethod(BcelClassWeaver weaver, NewMethodTypeMunger munger) {
        ResolvedMember signature = munger.getSignature();
        ResolvedMember dispatchMethod = munger.getDispatchMethod(this.aspectType);
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedTypeX onType = weaver.getWorld().resolve(signature.getDeclaringType(), munger.getSourceLocation());
        boolean onInterface = onType.isInterface();
        if (onType.equals(gen.getType())) {
            ResolvedMember introMethod = AjcMemberMaker.interMethod(signature, this.aspectType, onInterface);
            LazyMethodGen mg = this.makeMethodGen(gen, introMethod);
            if (!onInterface && !Modifier.isAbstract(introMethod.getModifiers())) {
                InstructionList body = mg.getBody();
                InstructionFactory fact = gen.getFactory();
                int pos = 0;
                if (!signature.isStatic()) {
                    body.append(InstructionFactory.createThis());
                    ++pos;
                }
                Type[] paramTypes = BcelWorld.makeBcelTypes(introMethod.getParameterTypes());
                int len = paramTypes.length;
                for (int i = 0; i < len; ++i) {
                    Type paramType = paramTypes[i];
                    body.append(InstructionFactory.createLoad(paramType, pos));
                    pos += paramType.getSize();
                }
                body.append(Utility.createInvoke(fact, weaver.getWorld(), dispatchMethod));
                body.append(InstructionFactory.createReturn(BcelWorld.makeBcelType(introMethod.getReturnType())));
            }
            weaver.addLazyMethodGen(mg);
            weaver.getLazyClassGen().warnOnAddedMethod(mg.getMethod(), this.getSignature().getSourceLocation());
            this.addNeededSuperCallMethods(weaver, onType, munger.getSuperMethodsCalled());
            return true;
        }
        if (onInterface && !Modifier.isAbstract(signature.getModifiers())) {
            if (!gen.getType().isTopmostImplementor(onType)) {
                ResolvedTypeX rtx = gen.getType().getTopmostImplementor(onType);
                if (!rtx.isExposedToWeaver()) {
                    ISourceLocation sLoc = munger.getSourceLocation();
                    weaver.getWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("itdNonExposedImplementor", rtx, this.getAspectType().getName()), sLoc == null ? this.getAspectType().getSourceLocation() : sLoc));
                }
                return false;
            }
            ResolvedMember introMethod = AjcMemberMaker.interMethod(signature, this.aspectType, false);
            LazyMethodGen mg = this.makeMethodGen(gen, introMethod);
            Type[] paramTypes = BcelWorld.makeBcelTypes(introMethod.getParameterTypes());
            Type returnType = BcelWorld.makeBcelType(introMethod.getReturnType());
            InstructionList body = mg.getBody();
            InstructionFactory fact = gen.getFactory();
            int pos = 0;
            if (!introMethod.isStatic()) {
                body.append(InstructionFactory.createThis());
                ++pos;
            }
            int len = paramTypes.length;
            for (int i = 0; i < len; ++i) {
                Type paramType = paramTypes[i];
                body.append(InstructionFactory.createLoad(paramType, pos));
                pos += paramType.getSize();
            }
            body.append(Utility.createInvoke(fact, weaver.getWorld(), dispatchMethod));
            body.append(InstructionFactory.createReturn(returnType));
            mg.definingType = onType;
            weaver.addOrReplaceLazyMethodGen(mg);
            this.addNeededSuperCallMethods(weaver, onType, munger.getSuperMethodsCalled());
            return true;
        }
        return false;
    }

    private void addNeededSuperCallMethods(BcelClassWeaver weaver, ResolvedTypeX onType, Set neededSuperCalls) {
        LazyClassGen gen = weaver.getLazyClassGen();
        Iterator iter = neededSuperCalls.iterator();
        while (iter.hasNext()) {
            ResolvedMember superMethod = (ResolvedMember)iter.next();
            if (!weaver.addDispatchTarget(superMethod)) continue;
            boolean isSuper = !superMethod.getDeclaringType().equals(gen.getType());
            String dispatchName = isSuper ? NameMangler.superDispatchMethod(onType, superMethod.getName()) : NameMangler.protectedDispatchMethod(onType, superMethod.getName());
            LazyMethodGen dispatcher = BcelTypeMunger.makeDispatcher(gen, dispatchName, superMethod, weaver.getWorld(), isSuper);
            weaver.addLazyMethodGen(dispatcher);
        }
    }

    private boolean mungeNewConstructor(BcelClassWeaver weaver, NewConstructorTypeMunger newConstructorTypeMunger) {
        LazyClassGen currentClass = weaver.getLazyClassGen();
        InstructionFactory fact = currentClass.getFactory();
        ResolvedMember newConstructorMember = newConstructorTypeMunger.getSyntheticConstructor();
        TypeX onType = newConstructorMember.getDeclaringType();
        if (!onType.equals(currentClass.getType())) {
            return false;
        }
        ResolvedMember explicitConstructor = newConstructorTypeMunger.getExplicitConstructor();
        LazyMethodGen freshConstructor = this.makeMethodGen(currentClass, newConstructorMember);
        currentClass.addMethodGen(freshConstructor);
        InstructionList body = freshConstructor.getBody();
        TypeX[] declaredParams = newConstructorTypeMunger.getSignature().getParameterTypes();
        Type[] paramTypes = freshConstructor.getArgumentTypes();
        int frameIndex = 1;
        int len = declaredParams.length;
        for (int i = 0; i < len; ++i) {
            body.append(InstructionFactory.createLoad(paramTypes[i], frameIndex));
            frameIndex += paramTypes[i].getSize();
        }
        ResolvedMember preMethod = AjcMemberMaker.preIntroducedConstructor(this.aspectType, onType, declaredParams);
        body.append(Utility.createInvoke(fact, null, preMethod));
        int arraySlot = freshConstructor.allocateLocal(1);
        body.append(InstructionFactory.createStore(Type.OBJECT, arraySlot));
        body.append(InstructionConstants.ALOAD_0);
        TypeX[] superParamTypes = explicitConstructor.getParameterTypes();
        int len2 = superParamTypes.length;
        for (int i = 0; i < len2; ++i) {
            body.append(InstructionFactory.createLoad(Type.OBJECT, arraySlot));
            body.append(Utility.createConstant(fact, i));
            body.append(InstructionFactory.createArrayLoad(Type.OBJECT));
            body.append(Utility.createConversion(fact, Type.OBJECT, BcelWorld.makeBcelType(superParamTypes[i])));
        }
        body.append(Utility.createInvoke(fact, null, explicitConstructor));
        body.append(InstructionConstants.ALOAD_0);
        ResolvedMember postMethod = AjcMemberMaker.postIntroducedConstructor(this.aspectType, onType, declaredParams);
        TypeX[] postParamTypes = postMethod.getParameterTypes();
        int len3 = postParamTypes.length;
        for (int i = 1; i < len3; ++i) {
            body.append(InstructionFactory.createLoad(Type.OBJECT, arraySlot));
            body.append(Utility.createConstant(fact, superParamTypes.length + i - 1));
            body.append(InstructionFactory.createArrayLoad(Type.OBJECT));
            body.append(Utility.createConversion(fact, Type.OBJECT, BcelWorld.makeBcelType(postParamTypes[i])));
        }
        body.append(Utility.createInvoke(fact, null, postMethod));
        body.append(InstructionConstants.RETURN);
        return true;
    }

    private static LazyMethodGen makeDispatcher(LazyClassGen onGen, String dispatchName, ResolvedMember superMethod, BcelWorld world, boolean isSuper) {
        Type[] paramTypes = BcelWorld.makeBcelTypes(superMethod.getParameterTypes());
        Type returnType = BcelWorld.makeBcelType(superMethod.getReturnType());
        int modifiers = 1;
        if (onGen.isInterface()) {
            modifiers |= 0x400;
        }
        LazyMethodGen mg = new LazyMethodGen(modifiers, returnType, dispatchName, paramTypes, TypeX.getNames(superMethod.getExceptions()), onGen);
        InstructionList body = mg.getBody();
        if (onGen.isInterface()) {
            return mg;
        }
        InstructionFactory fact = onGen.getFactory();
        int pos = 0;
        body.append(InstructionFactory.createThis());
        ++pos;
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            Type paramType = paramTypes[i];
            body.append(InstructionFactory.createLoad(paramType, pos));
            pos += paramType.getSize();
        }
        if (isSuper) {
            body.append(Utility.createSuperInvoke(fact, world, superMethod));
        } else {
            body.append(Utility.createInvoke(fact, world, superMethod));
        }
        body.append(InstructionFactory.createReturn(returnType));
        return mg;
    }

    private boolean mungeNewField(BcelClassWeaver weaver, NewFieldTypeMunger munger) {
        munger.getInitMethod(this.aspectType);
        LazyClassGen gen = weaver.getLazyClassGen();
        ResolvedMember field = munger.getSignature();
        ResolvedTypeX onType = weaver.getWorld().resolve(field.getDeclaringType(), munger.getSourceLocation());
        boolean onInterface = onType.isInterface();
        if (onType.equals(gen.getType())) {
            if (onInterface) {
                LazyMethodGen mg = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceGetter(field, onType, this.aspectType));
                gen.addMethodGen(mg);
                LazyMethodGen mg1 = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceSetter(field, onType, this.aspectType));
                gen.addMethodGen(mg1);
            } else {
                weaver.addInitializer(this);
                FieldGen fg = this.makeFieldGen(gen, AjcMemberMaker.interFieldClassField(field, this.aspectType));
                gen.addField(fg.getField(), this.getSourceLocation());
            }
            return true;
        }
        if (onInterface && gen.getType().isTopmostImplementor(onType)) {
            if (field.isStatic()) {
                throw new RuntimeException("unimplemented");
            }
            weaver.addInitializer(this);
            Type fieldType = BcelWorld.makeBcelType(field.getType());
            FieldGen fg = this.makeFieldGen(gen, AjcMemberMaker.interFieldInterfaceField(field, onType, this.aspectType));
            gen.addField(fg.getField(), this.getSourceLocation());
            LazyMethodGen mg = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceGetter(field, gen.getType(), this.aspectType));
            InstructionList il = new InstructionList();
            InstructionFactory fact = gen.getFactory();
            if (field.isStatic()) {
                il.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)178));
            } else {
                il.append(InstructionConstants.ALOAD_0);
                il.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)180));
            }
            il.append(InstructionFactory.createReturn(fieldType));
            mg.getBody().insert(il);
            gen.addMethodGen(mg);
            LazyMethodGen mg1 = this.makeMethodGen(gen, AjcMemberMaker.interFieldInterfaceSetter(field, gen.getType(), this.aspectType));
            InstructionList il1 = new InstructionList();
            if (field.isStatic()) {
                il1.append(InstructionFactory.createLoad(fieldType, 0));
                il1.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)179));
            } else {
                il1.append(InstructionConstants.ALOAD_0);
                il1.append(InstructionFactory.createLoad(fieldType, 1));
                il1.append(fact.createFieldAccess(gen.getClassName(), fg.getName(), fieldType, (short)181));
            }
            il1.append(InstructionFactory.createReturn(Type.VOID));
            mg1.getBody().insert(il1);
            gen.addMethodGen(mg1);
            return true;
        }
        return false;
    }
}

