/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.generic.BranchHandle;
import org.aspectj.apache.bcel.generic.BranchInstruction;
import org.aspectj.apache.bcel.generic.CPInstruction;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.CodeExceptionGen;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.LineNumberGen;
import org.aspectj.apache.bcel.generic.LocalVariableGen;
import org.aspectj.apache.bcel.generic.LocalVariableInstruction;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Select;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.ExceptionRange;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LineNumberTag;
import org.aspectj.weaver.bcel.LocalVariableTag;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.Tag;
import org.aspectj.weaver.bcel.Utility;

public final class LazyMethodGen {
    private int accessFlags;
    private Type returnType;
    private final String name;
    private Type[] argumentTypes;
    private String[] declaredExceptions;
    private InstructionList body;
    private Attribute[] attributes;
    final LazyClassGen enclosingClass;
    private final BcelMethod memberView;
    int highestLineNumber = 0;
    String fromFilename = null;
    private int maxLocals;
    private boolean canInline = true;
    private boolean hasExceptionHandlers;
    private boolean isSynthetic = false;
    List matchedShadows;
    public ResolvedTypeX definingType = null;
    private Method savedMethod = null;

    public LazyMethodGen(int accessFlags, Type returnType, String name, Type[] paramTypes, String[] declaredExceptions, LazyClassGen enclosingClass) {
        this.memberView = null;
        this.accessFlags = accessFlags;
        this.returnType = returnType;
        this.name = name;
        this.argumentTypes = paramTypes;
        this.declaredExceptions = declaredExceptions;
        if (!Modifier.isAbstract(accessFlags)) {
            this.body = new InstructionList();
            this.setMaxLocals(this.calculateMaxLocals());
        } else {
            this.body = null;
        }
        this.attributes = new Attribute[0];
        this.enclosingClass = enclosingClass;
        this.assertGoodBody();
    }

    private int calculateMaxLocals() {
        int ret = 0;
        if (!Modifier.isStatic(this.accessFlags)) {
            ++ret;
        }
        int len = this.argumentTypes.length;
        for (int i = 0; i < len; ++i) {
            ret += this.argumentTypes[i].getSize();
        }
        return ret;
    }

    public LazyMethodGen(Method m, LazyClassGen enclosingClass) {
        this.savedMethod = m;
        this.enclosingClass = enclosingClass;
        if (!m.isAbstract() && !m.isNative() && m.getCode() == null) {
            throw new RuntimeException("bad non-abstract method with no code: " + m + " on " + enclosingClass);
        }
        if ((m.isAbstract() || m.isNative()) && m.getCode() != null) {
            throw new RuntimeException("bad abstract method with code: " + m + " on " + enclosingClass);
        }
        this.memberView = new BcelMethod(enclosingClass.getBcelObjectType(), m);
        this.accessFlags = m.getAccessFlags();
        this.name = m.getName();
    }

    public boolean hasDeclaredLineNumberInfo() {
        return this.memberView != null && this.memberView.hasDeclarationLineNumberInfo();
    }

    public int getDeclarationLineNumber() {
        if (this.hasDeclaredLineNumberInfo()) {
            return this.memberView.getDeclarationLineNumber();
        }
        return -1;
    }

    private void initialize() {
        if (this.returnType != null) {
            return;
        }
        MethodGen gen = new MethodGen(this.savedMethod, this.enclosingClass.getName(), this.enclosingClass.getConstantPoolGen());
        this.returnType = gen.getReturnType();
        this.argumentTypes = gen.getArgumentTypes();
        this.declaredExceptions = gen.getExceptions();
        this.attributes = gen.getAttributes();
        this.maxLocals = gen.getMaxLocals();
        if (gen.isAbstract() || gen.isNative()) {
            this.body = null;
        } else {
            this.body = gen.getInstructionList();
            this.unpackHandlers(gen);
            this.unpackLineNumbers(gen);
            this.unpackLocals(gen);
        }
        this.assertGoodBody();
    }

    private void unpackHandlers(MethodGen gen) {
        CodeExceptionGen[] exns = gen.getExceptionHandlers();
        if (exns != null) {
            int len = exns.length;
            if (len > 0) {
                this.hasExceptionHandlers = true;
            }
            int priority = len - 1;
            int i = 0;
            while (i < len) {
                CodeExceptionGen exn = exns[i];
                InstructionHandle start = Range.genStart(this.body, this.getOutermostExceptionStart(exn.getStartPC()));
                InstructionHandle end = Range.genEnd(this.body, this.getOutermostExceptionEnd(exn.getEndPC()));
                ExceptionRange er = new ExceptionRange(this.body, exn.getCatchType() == null ? null : BcelWorld.fromBcel(exn.getCatchType()), priority);
                er.associateWithTargets(start, end, exn.getHandlerPC());
                exn.setStartPC(null);
                exn.setEndPC(null);
                exn.setHandlerPC(null);
                ++i;
                --priority;
            }
            gen.removeExceptionHandlers();
        }
    }

    private InstructionHandle getOutermostExceptionStart(InstructionHandle ih) {
        while (ExceptionRange.isExceptionStart(ih.getPrev())) {
            ih = ih.getPrev();
        }
        return ih;
    }

    private InstructionHandle getOutermostExceptionEnd(InstructionHandle ih) {
        while (ExceptionRange.isExceptionEnd(ih.getNext())) {
            ih = ih.getNext();
        }
        return ih;
    }

    private void unpackLineNumbers(MethodGen gen) {
        LineNumberTag lr = null;
        for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
            InstructionTargeter[] targeters = ih.getTargeters();
            if (targeters != null) {
                for (int i = targeters.length - 1; i >= 0; --i) {
                    InstructionTargeter targeter = targeters[i];
                    if (!(targeter instanceof LineNumberGen)) continue;
                    LineNumberGen lng = (LineNumberGen)targeter;
                    lng.updateTarget(ih, null);
                    int lineNumber = lng.getSourceLine();
                    if (this.highestLineNumber < lineNumber) {
                        this.highestLineNumber = lineNumber;
                    }
                    lr = new LineNumberTag(lineNumber);
                }
            }
            if (lr == null) continue;
            ih.addTargeter(lr);
        }
        gen.removeLineNumbers();
    }

    private void unpackLocals(MethodGen gen) {
        HashSet<LocalVariableTag> locals = new HashSet<LocalVariableTag>();
        for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
            InstructionTargeter[] targeters = ih.getTargeters();
            ArrayList<LocalVariableTag> ends = new ArrayList<LocalVariableTag>(0);
            if (targeters != null) {
                for (int i = targeters.length - 1; i >= 0; --i) {
                    InstructionTargeter targeter = targeters[i];
                    if (!(targeter instanceof LocalVariableGen)) continue;
                    LocalVariableGen lng = (LocalVariableGen)targeter;
                    LocalVariableTag lr = new LocalVariableTag(BcelWorld.fromBcel(lng.getType()), lng.getName(), lng.getIndex());
                    if (lng.getStart() == ih) {
                        locals.add(lr);
                        continue;
                    }
                    ends.add(lr);
                }
            }
            Iterator i = locals.iterator();
            while (i.hasNext()) {
                ih.addTargeter((LocalVariableTag)i.next());
            }
            locals.removeAll(ends);
        }
        gen.removeLocalVariables();
    }

    public int allocateLocal(Type type) {
        return this.allocateLocal(type.getSize());
    }

    public int allocateLocal(int slots) {
        int max = this.getMaxLocals();
        this.setMaxLocals(max + slots);
        return max;
    }

    public Method getMethod() {
        if (this.savedMethod != null) {
            return this.savedMethod;
        }
        try {
            MethodGen gen = this.pack();
            return gen.getMethod();
        }
        catch (ClassGenException e) {
            this.enclosingClass.getBcelObjectType().getResolvedTypeX().getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("problemGeneratingMethod", this.getClassName(), this.getName(), e.getMessage()), this.getMemberView() == null ? null : this.getMemberView().getSourceLocation(), null);
            this.body = null;
            MethodGen gen = this.pack();
            return gen.getMethod();
        }
    }

    public void markAsChanged() {
        this.initialize();
        this.savedMethod = null;
    }

    public String toString() {
        return this.toLongString();
    }

    public String toShortString() {
        int i;
        String access = org.aspectj.apache.bcel.classfile.Utility.accessToString(this.getAccessFlags());
        StringBuffer buf = new StringBuffer();
        if (!access.equals("")) {
            buf.append(access);
            buf.append(" ");
        }
        buf.append(org.aspectj.apache.bcel.classfile.Utility.signatureToString(this.getReturnType().getSignature(), true));
        buf.append(" ");
        buf.append(this.getName());
        buf.append("(");
        int len = this.argumentTypes.length;
        if (len > 0) {
            buf.append(org.aspectj.apache.bcel.classfile.Utility.signatureToString(this.argumentTypes[0].getSignature(), true));
            for (i = 1; i < this.argumentTypes.length; ++i) {
                buf.append(", ");
                buf.append(org.aspectj.apache.bcel.classfile.Utility.signatureToString(this.argumentTypes[i].getSignature(), true));
            }
        }
        buf.append(")");
        int n = len = this.declaredExceptions != null ? this.declaredExceptions.length : 0;
        if (len > 0) {
            buf.append(" throws ");
            buf.append(this.declaredExceptions[0]);
            for (i = 1; i < this.declaredExceptions.length; ++i) {
                buf.append(", ");
                buf.append(this.declaredExceptions[i]);
            }
        }
        return buf.toString();
    }

    public String toLongString() {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        this.print(new PrintStream(s));
        return new String(s.toByteArray());
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        out.print("  " + this.toShortString());
        this.printAspectAttributes(out);
        InstructionList body = this.getBody();
        if (body == null) {
            out.println(";");
            return;
        }
        out.println(":");
        new BodyPrinter(out).run();
        out.println("  end " + this.toShortString());
    }

    private void printAspectAttributes(PrintStream out) {
        List as;
        ISourceContext context = null;
        if (this.enclosingClass != null && this.enclosingClass.getType() != null) {
            context = this.enclosingClass.getType().getSourceContext();
        }
        if (!(as = BcelAttributes.readAjAttributes(this.attributes, context)).isEmpty()) {
            out.println("    " + as.get(0));
        }
    }

    static LocalVariableTag getLocalVariableTag(InstructionHandle ih, int index) {
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters == null) {
            return null;
        }
        for (int i = targeters.length - 1; i >= 0; --i) {
            LocalVariableTag lvt;
            InstructionTargeter t = targeters[i];
            if (!(t instanceof LocalVariableTag) || (lvt = (LocalVariableTag)t).getSlot() != index) continue;
            return lvt;
        }
        return null;
    }

    static int getLineNumber(InstructionHandle ih, int prevLine) {
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters == null) {
            return prevLine;
        }
        for (int i = targeters.length - 1; i >= 0; --i) {
            InstructionTargeter t = targeters[i];
            if (!(t instanceof LineNumberTag)) continue;
            return ((LineNumberTag)t).getLineNumber();
        }
        return prevLine;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getAccessFlags());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getAccessFlags());
    }

    public void addExceptionHandler(InstructionHandle start, InstructionHandle end, InstructionHandle handlerStart, ObjectType catchType, boolean highPriority) {
        InstructionHandle start1 = Range.genStart(this.body, start);
        InstructionHandle end1 = Range.genEnd(this.body, end);
        ExceptionRange er = new ExceptionRange(this.body, BcelWorld.fromBcel(catchType), highPriority);
        er.associateWithTargets(start1, end1, handlerStart);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public Type[] getArgumentTypes() {
        this.initialize();
        return this.argumentTypes;
    }

    public LazyClassGen getEnclosingClass() {
        return this.enclosingClass;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public String getName() {
        return this.name;
    }

    public Type getReturnType() {
        this.initialize();
        return this.returnType;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public InstructionList getBody() {
        this.markAsChanged();
        return this.body;
    }

    public boolean hasBody() {
        if (this.savedMethod != null) {
            return this.savedMethod.getCode() != null;
        }
        return this.body != null;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String[] getDeclaredExceptions() {
        return this.declaredExceptions;
    }

    public String getClassName() {
        return this.enclosingClass.getName();
    }

    public MethodGen pack() {
        int i;
        MethodGen gen = new MethodGen(this.getAccessFlags(), this.getReturnType(), this.getArgumentTypes(), null, this.getName(), this.getEnclosingClass().getName(), new InstructionList(), this.getEnclosingClass().getConstantPoolGen());
        int len = this.declaredExceptions.length;
        for (i = 0; i < len; ++i) {
            gen.addException(this.declaredExceptions[i]);
        }
        len = this.attributes.length;
        for (i = 0; i < len; ++i) {
            gen.addAttribute(this.attributes[i]);
        }
        if (this.isSynthetic) {
            ConstantPoolGen cpg = gen.getConstantPool();
            int index = cpg.addUtf8("Synthetic");
            gen.addAttribute(new Synthetic(index, 0, new byte[0], cpg.getConstantPool()));
        }
        if (this.hasBody()) {
            this.packBody(gen);
            gen.setMaxLocals();
            gen.setMaxStack();
        } else {
            gen.setInstructionList(null);
        }
        return gen;
    }

    public void makeSynthetic() {
        this.isSynthetic = true;
    }

    public void packBody(MethodGen gen) {
        InstructionHandle ih;
        HashMap<InstructionHandle, InstructionHandle> map = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList fresh = gen.getInstructionList();
        for (ih = this.getBody().getStart(); ih != null; ih = ih.getNext()) {
            if (Range.isRangeHandle(ih)) continue;
            Instruction i = ih.getInstruction();
            Instruction c = Utility.copyInstruction(i);
            if (c instanceof BranchInstruction) {
                map.put(ih, fresh.append((BranchInstruction)c));
                continue;
            }
            map.put(ih, fresh.append(c));
        }
        ih = this.getBody().getStart();
        InstructionHandle jh = fresh.getStart();
        LinkedList exnList = new LinkedList();
        HashMap<LocalVariableTag, InstructionHandle> localVariableStarts = new HashMap<LocalVariableTag, InstructionHandle>();
        HashMap<LocalVariableTag, InstructionHandle> localVariableEnds = new HashMap<LocalVariableTag, InstructionHandle>();
        int currLine = -1;
        while (ih != null) {
            int lineNumberOffset;
            if (map.get(ih) == null) {
                ExceptionRange er;
                Range r = Range.getRange(ih);
                if (r instanceof ExceptionRange && (er = (ExceptionRange)r).getStart() == ih && !er.isEmpty()) {
                    LazyMethodGen.insertHandler(er, exnList);
                }
                ih = ih.getNext();
                continue;
            }
            Instruction i = ih.getInstruction();
            Instruction j = jh.getInstruction();
            if (i instanceof BranchInstruction) {
                BranchInstruction bi = (BranchInstruction)i;
                BranchInstruction bj = (BranchInstruction)j;
                InstructionHandle itarget = bi.getTarget();
                bj.setTarget(LazyMethodGen.remap(itarget, map));
                if (bi instanceof Select) {
                    InstructionHandle[] itargets = ((Select)bi).getTargets();
                    InstructionHandle[] jtargets = ((Select)bj).getTargets();
                    for (int k = itargets.length - 1; k >= 0; --k) {
                        jtargets[k] = LazyMethodGen.remap(itargets[k], map);
                        jtargets[k].addTargeter(bj);
                    }
                }
            }
            InstructionTargeter[] targeters = ih.getTargeters();
            int n = lineNumberOffset = this.fromFilename == null ? 0 : this.getEnclosingClass().getSourceDebugExtensionOffset(this.fromFilename);
            if (targeters != null) {
                for (int k = targeters.length - 1; k >= 0; --k) {
                    InstructionTargeter targeter = targeters[k];
                    if (targeter instanceof LineNumberTag) {
                        int line = ((LineNumberTag)targeter).getLineNumber();
                        if (line == currLine) continue;
                        gen.addLineNumber(jh, line + lineNumberOffset);
                        currLine = line;
                        continue;
                    }
                    if (!(targeter instanceof LocalVariableTag)) continue;
                    LocalVariableTag lvt = (LocalVariableTag)targeter;
                    if (localVariableStarts.get(lvt) == null) {
                        localVariableStarts.put(lvt, jh);
                    }
                    localVariableEnds.put(lvt, jh);
                }
            }
            ih = ih.getNext();
            jh = jh.getNext();
        }
        Iterator iter = exnList.iterator();
        while (iter.hasNext()) {
            ExceptionRange r = (ExceptionRange)iter.next();
            if (r.isEmpty()) continue;
            gen.addExceptionHandler(LazyMethodGen.remap(r.getRealStart(), map), LazyMethodGen.remap(r.getRealEnd(), map), LazyMethodGen.remap(r.getHandler(), map), r.getCatchType() == null ? null : (ObjectType)BcelWorld.makeBcelType(r.getCatchType()));
        }
        gen.removeLocalVariables();
        HashMap duplicatedLocalMap = new HashMap();
        ArrayList keys = new ArrayList();
        keys.addAll(localVariableStarts.keySet());
        Iterator iter2 = keys.iterator();
        while (iter2.hasNext()) {
            LocalVariableTag tag = (LocalVariableTag)iter2.next();
            InstructionHandle start = (InstructionHandle)localVariableStarts.get(tag);
            HashSet<Integer> slots = (HashSet<Integer>)duplicatedLocalMap.get(start);
            if (slots == null) {
                slots = new HashSet<Integer>();
                duplicatedLocalMap.put(start, slots);
            }
            if (slots.contains(new Integer(tag.getSlot()))) continue;
            slots.add(new Integer(tag.getSlot()));
            gen.addLocalVariable(tag.getName(), BcelWorld.makeBcelType(tag.getType()), tag.getSlot(), (InstructionHandle)localVariableStarts.get(tag), (InstructionHandle)localVariableEnds.get(tag));
        }
    }

    private static InstructionHandle remap(InstructionHandle ih, Map map) {
        Object ret;
        while ((ret = map.get(ih)) == null) {
            ih = ih.getNext();
        }
        return (InstructionHandle)ret;
    }

    static void insertHandler(ExceptionRange fresh, LinkedList l) {
        l.add(0, fresh);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getAccessFlags());
    }

    public void assertGoodBody() {
    }

    public static void assertGoodBody(InstructionList il, String from) {
    }

    private static void assertGoodHandle(InstructionHandle ih, Set body, Stack ranges, String from) {
        Instruction inst = ih.getInstruction();
        if (inst instanceof BranchInstruction ^ ih instanceof BranchHandle) {
            throw new BCException("bad instruction/handle pair in " + from);
        }
        if (Range.isRangeHandle(ih)) {
            LazyMethodGen.assertGoodRangeHandle(ih, body, ranges, from);
        } else if (inst instanceof BranchInstruction) {
            LazyMethodGen.assertGoodBranchInstruction((BranchHandle)ih, (BranchInstruction)inst, body, ranges, from);
        }
    }

    private static void assertGoodBranchInstruction(BranchHandle ih, BranchInstruction inst, Set body, Stack ranges, String from) {
        if (ih.getTarget() != inst.getTarget()) {
            throw new BCException("bad branch instruction/handle pair in " + from);
        }
        InstructionHandle target = ih.getTarget();
        LazyMethodGen.assertInBody(target, body, from);
        LazyMethodGen.assertTargetedBy(target, inst, from);
        if (inst instanceof Select) {
            Select sel = (Select)inst;
            InstructionHandle[] itargets = sel.getTargets();
            for (int k = itargets.length - 1; k >= 0; --k) {
                LazyMethodGen.assertInBody(itargets[k], body, from);
                LazyMethodGen.assertTargetedBy(itargets[k], inst, from);
            }
        }
    }

    private static void assertInBody(Object ih, Set body, String from) {
        if (!body.contains(ih)) {
            throw new BCException("thing not in body in " + from);
        }
    }

    private static void assertGoodRangeHandle(InstructionHandle ih, Set body, Stack ranges, String from) {
        Range r = LazyMethodGen.getRangeAndAssertExactlyOne(ih, from);
        LazyMethodGen.assertGoodRange(r, body, from);
        if (r.getStart() == ih) {
            ranges.push(r);
        } else if (r.getEnd() == ih) {
            if (ranges.peek() != r) {
                throw new BCException("bad range inclusion in " + from);
            }
            ranges.pop();
        }
    }

    private static void assertGoodRange(Range r, Set body, String from) {
        LazyMethodGen.assertInBody(r.getStart(), body, from);
        LazyMethodGen.assertRangeHandle(r.getStart(), from);
        LazyMethodGen.assertTargetedBy(r.getStart(), r, from);
        LazyMethodGen.assertInBody(r.getEnd(), body, from);
        LazyMethodGen.assertRangeHandle(r.getEnd(), from);
        LazyMethodGen.assertTargetedBy(r.getEnd(), r, from);
        if (r instanceof ExceptionRange) {
            ExceptionRange er = (ExceptionRange)r;
            LazyMethodGen.assertInBody(er.getHandler(), body, from);
            LazyMethodGen.assertTargetedBy(er.getHandler(), r, from);
        }
    }

    private static void assertRangeHandle(InstructionHandle ih, String from) {
        if (!Range.isRangeHandle(ih)) {
            throw new BCException("bad range handle " + ih + " in " + from);
        }
    }

    private static void assertTargetedBy(InstructionHandle target, InstructionTargeter targeter, String from) {
        InstructionTargeter[] ts = target.getTargeters();
        if (ts == null) {
            throw new BCException("bad targeting relationship in " + from);
        }
        for (int i = ts.length - 1; i >= 0; --i) {
            if (ts[i] != targeter) continue;
            return;
        }
        throw new RuntimeException("bad targeting relationship in " + from);
    }

    private static void assertTargets(InstructionTargeter targeter, InstructionHandle target, String from) {
        if (targeter instanceof Range) {
            Range r = (Range)targeter;
            if (r.getStart() == target || r.getEnd() == target) {
                return;
            }
            if (r instanceof ExceptionRange && ((ExceptionRange)r).getHandler() == target) {
                return;
            }
        } else if (targeter instanceof BranchInstruction) {
            BranchInstruction bi = (BranchInstruction)targeter;
            if (bi.getTarget() == target) {
                return;
            }
            if (targeter instanceof Select) {
                Select sel = (Select)targeter;
                InstructionHandle[] itargets = sel.getTargets();
                for (int k = itargets.length - 1; k >= 0; --k) {
                    if (itargets[k] != target) continue;
                    return;
                }
            }
        } else if (targeter instanceof Tag) {
            return;
        }
        throw new BCException(targeter + " doesn't target " + target + " in " + from);
    }

    private static Range getRangeAndAssertExactlyOne(InstructionHandle ih, String from) {
        Range ret = null;
        InstructionTargeter[] ts = ih.getTargeters();
        if (ts == null) {
            throw new BCException("range handle with no range in " + from);
        }
        for (int i = ts.length - 1; i >= 0; --i) {
            if (!(ts[i] instanceof Range)) continue;
            if (ret != null) {
                throw new BCException("range handle with multiple ranges in " + from);
            }
            ret = (Range)ts[i];
        }
        if (ret == null) {
            throw new BCException("range handle with no range in " + from);
        }
        return ret;
    }

    private static void assertGoodTargeter(InstructionTargeter t, InstructionHandle ih, Set body, String from) {
        LazyMethodGen.assertTargets(t, ih, from);
        if (t instanceof Range) {
            LazyMethodGen.assertGoodRange((Range)t, body, from);
        } else if (t instanceof BranchInstruction) {
            LazyMethodGen.assertInBody(t, body, from);
        }
    }

    boolean isAdviceMethod() {
        return this.memberView.getAssociatedShadowMunger() != null;
    }

    boolean isAjSynthetic() {
        if (this.memberView == null) {
            return true;
        }
        return this.memberView.isAjSynthetic();
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return this.memberView.getEffectiveSignature();
    }

    public String getSignature() {
        if (this.memberView != null) {
            return this.memberView.getSignature();
        }
        return Member.typesToSignature(BcelWorld.fromBcel(this.getReturnType()), BcelWorld.fromBcel(this.getArgumentTypes()));
    }

    public BcelMethod getMemberView() {
        return this.memberView;
    }

    public void forcePublic() {
        this.markAsChanged();
        this.accessFlags = Utility.makePublic(this.accessFlags);
    }

    public boolean getCanInline() {
        return this.canInline;
    }

    public void setCanInline(boolean canInline) {
        this.canInline = canInline;
    }

    private class BodyPrinter {
        Map prefixMap = new HashMap();
        Map suffixMap = new HashMap();
        Map labelMap = new HashMap();
        InstructionList body;
        PrintStream out;
        ConstantPool pool;
        List ranges;
        static final int BODY_INDENT = 4;
        static final int CODE_INDENT = 16;

        BodyPrinter(PrintStream out) {
            this.pool = LazyMethodGen.this.enclosingClass.getConstantPoolGen().getConstantPool();
            this.body = LazyMethodGen.this.getBody();
            this.out = out;
        }

        void run() {
            this.assignLabels();
            this.print();
        }

        void assignLabels() {
            LinkedList exnTable = new LinkedList();
            String pendingLabel = null;
            int lcounter = 0;
            for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
                InstructionTargeter[] targeters = ih.getTargeters();
                if (targeters != null) {
                    for (int i = targeters.length - 1; i >= 0; --i) {
                        InstructionTargeter t = targeters[i];
                        if (t instanceof ExceptionRange) {
                            ExceptionRange r = (ExceptionRange)t;
                            if (r.getStart() != ih) continue;
                            LazyMethodGen.insertHandler(r, exnTable);
                            continue;
                        }
                        if (!(t instanceof BranchInstruction) || pendingLabel != null) continue;
                        pendingLabel = "L" + lcounter++;
                    }
                }
                if (pendingLabel == null) continue;
                this.labelMap.put(ih, pendingLabel);
                if (Range.isRangeHandle(ih)) continue;
                pendingLabel = null;
            }
            int ecounter = 0;
            Iterator i = exnTable.iterator();
            while (i.hasNext()) {
                ExceptionRange er = (ExceptionRange)i.next();
                String exceptionLabel = "E" + ecounter++;
                this.labelMap.put(Range.getRealStart(er.getHandler()), exceptionLabel);
                this.labelMap.put(er.getHandler(), exceptionLabel);
            }
        }

        void print() {
            int depth = 0;
            int currLine = -1;
            block0: for (InstructionHandle ih = this.body.getStart(); ih != null; ih = ih.getNext()) {
                if (Range.isRangeHandle(ih)) {
                    Range r = Range.getRange(ih);
                    InstructionHandle xx = r.getStart();
                    while (Range.isRangeHandle(xx)) {
                        if (xx == r.getEnd()) continue block0;
                        xx = xx.getNext();
                    }
                    if (r.getStart() == ih) {
                        this.printRangeString(r, depth++);
                        continue;
                    }
                    if (r.getEnd() != ih) {
                        throw new RuntimeException("bad");
                    }
                    this.printRangeString(r, --depth);
                    continue;
                }
                this.printInstruction(ih, depth);
                int line = LazyMethodGen.getLineNumber(ih, currLine);
                if (line != currLine) {
                    currLine = line;
                    this.out.println("   (line " + line + ")");
                    continue;
                }
                this.out.println();
            }
        }

        void printRangeString(Range r, int depth) {
            this.printDepth(depth);
            this.out.println(this.getRangeString(r, this.labelMap));
        }

        String getRangeString(Range r, Map labelMap) {
            if (r instanceof ExceptionRange) {
                ExceptionRange er = (ExceptionRange)r;
                return er.toString() + " -> " + labelMap.get(er.getHandler());
            }
            return r.toString();
        }

        void printDepth(int depth) {
            this.pad(4);
            while (depth > 0) {
                this.out.print("| ");
                --depth;
            }
        }

        void printLabel(String s, int depth) {
            int space = Math.max(16 - depth * 2, 0);
            if (s == null) {
                this.pad(space);
            } else {
                space = Math.max(space - (s.length() + 2), 0);
                this.pad(space);
                this.out.print(s);
                this.out.print(": ");
            }
        }

        void printInstruction(InstructionHandle h, int depth) {
            this.printDepth(depth);
            this.printLabel((String)this.labelMap.get(h), depth);
            Instruction inst = h.getInstruction();
            if (inst instanceof CPInstruction) {
                CPInstruction cpinst = (CPInstruction)inst;
                this.out.print(Constants.OPCODE_NAMES[cpinst.getOpcode()].toUpperCase());
                this.out.print(" ");
                this.out.print(this.pool.constantToString(this.pool.getConstant(cpinst.getIndex())));
            } else if (inst instanceof Select) {
                Select sinst = (Select)inst;
                this.out.println(Constants.OPCODE_NAMES[sinst.getOpcode()].toUpperCase());
                int[] matches = sinst.getMatchs();
                InstructionHandle[] targets = sinst.getTargets();
                InstructionHandle defaultTarget = sinst.getTarget();
                int len = matches.length;
                for (int i = 0; i < len; ++i) {
                    this.printDepth(depth);
                    this.printLabel(null, depth);
                    this.out.print("  ");
                    this.out.print(matches[i]);
                    this.out.print(": \t");
                    this.out.println(this.labelMap.get(targets[i]));
                }
                this.printDepth(depth);
                this.printLabel(null, depth);
                this.out.print("  ");
                this.out.print("default: \t");
                this.out.print(this.labelMap.get(defaultTarget));
            } else if (inst instanceof BranchInstruction) {
                BranchInstruction brinst = (BranchInstruction)inst;
                this.out.print(Constants.OPCODE_NAMES[brinst.getOpcode()].toUpperCase());
                this.out.print(" ");
                this.out.print(this.labelMap.get(brinst.getTarget()));
            } else if (inst instanceof LocalVariableInstruction) {
                LocalVariableInstruction lvinst = (LocalVariableInstruction)inst;
                this.out.print(inst.toString(false).toUpperCase());
                int index = lvinst.getIndex();
                LocalVariableTag tag = LazyMethodGen.getLocalVariableTag(h, index);
                if (tag != null) {
                    this.out.print("     // ");
                    this.out.print(tag.getType());
                    this.out.print(" ");
                    this.out.print(tag.getName());
                }
            } else {
                this.out.print(inst.toString(false).toUpperCase());
            }
        }

        void pad(int size) {
            for (int i = 0; i < size; ++i) {
                this.out.print(" ");
            }
        }
    }
}

