/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.javaelements;

import java.util.List;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.core.javaelements.AspectJMemberElementInfo;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.core.javaelements.IAspectJElementInfo;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.util.Util;

public class AspectJMemberElement
extends Member
implements IMethod,
IAspectJElement {
    protected String[] fParameterTypes;
    protected static final String[] fgEmptyList = new String[0];

    public AspectJMemberElement(JavaElement parent, String name, String[] parameterTypes) {
        super(parent, name);
        this.fParameterTypes = parameterTypes == null ? fgEmptyList : parameterTypes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AspectJMemberElement)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull((Object[])this.fParameterTypes, (Object[])((AspectJMemberElement)o).fParameterTypes);
    }

    protected boolean equalsDOMNode(IDOMNode node) {
        if (node.getNodeType() == 6) {
            try {
                IDOMMethod m = (IDOMMethod)node;
                if (this.isConstructor()) {
                    return (m.isConstructor() || m.getName().equals(this.getElementName())) && this.signatureEquals(m);
                }
                return super.equalsDOMNode(node) && this.signatureEquals(m);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    public int getElementType() {
        return 9;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        AspectJMemberElementInfo info = (AspectJMemberElementInfo)this.getElementInfo();
        char[][] exs = info.getExceptionTypeNames();
        return AspectJMemberElement.convertTypeNamesToSigs(exs);
    }

    static String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return new String[0];
        }
        int n = typeNames.length;
        if (n == 0) {
            return new String[0];
        }
        String[] typeSigs = new String[n];
        int i = 0;
        while (i < n) {
            typeSigs[i] = Signature.createTypeSignature((char[])typeNames[i], (boolean)false);
            ++i;
        }
        return typeSigs;
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append(delimiter);
            buff.append(this.fParameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        AspectJMemberElementInfo info = (AspectJMemberElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        if (names == null || names.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        return new String[0];
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        IJavaElement primaryParent = this.parent.getPrimaryElement(false);
        return ((IType)primaryParent).getMethod(this.name, this.fParameterTypes);
    }

    public String getReturnType() throws JavaModelException {
        AspectJMemberElementInfo info = (AspectJMemberElementInfo)this.getElementInfo();
        return Signature.createTypeSignature((char[])info.getReturnTypeName(), (boolean)false);
    }

    public String getSignature() throws JavaModelException {
        AspectJMemberElementInfo info = (AspectJMemberElementInfo)this.getElementInfo();
        return info.getSignature();
    }

    public int hashCode() {
        int hash = super.hashCode();
        int i = 0;
        int length = this.fParameterTypes.length;
        while (i < length) {
            hash = Util.combineHashCodes((int)hash, (int)this.fParameterTypes[i].hashCode());
            ++i;
        }
        return hash;
    }

    public boolean isConstructor() throws JavaModelException {
        AspectJMemberElementInfo info = (AspectJMemberElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isSimilar(IMethod method) {
        return this.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    protected boolean signatureEquals(IDOMMethod method) {
        String[] otherTypes = method.getParameterTypes();
        String[] types = this.getParameterTypes();
        boolean ok = true;
        if (otherTypes == null || otherTypes.length == 0) {
            ok = types == null || types.length == 0;
        } else if (types != null) {
            ok = otherTypes.length == types.length;
        } else {
            return false;
        }
        if (ok && types != null) {
            int i = 0;
            while (i < types.length) {
                String otherType = Signature.createTypeSignature((char[])otherTypes[i].toCharArray(), (boolean)false);
                if (!types[i].equals(otherType)) {
                    ok = false;
                    break;
                }
                ++i;
            }
        }
        return ok;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                if (Flags.isStatic((int)this.getFlags())) {
                    buffer.append("static ");
                }
                if (!this.isConstructor()) {
                    buffer.append(Signature.toString((String)this.getReturnType()));
                    buffer.append(' ');
                }
                this.toStringName(buffer);
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    public int getType() {
        return 9;
    }

    public IProgramElement.Kind getAJKind() throws JavaModelException {
        IAspectJElementInfo info = (IAspectJElementInfo)this.getElementInfo();
        return info.getAJKind();
    }

    public IProgramElement.Accessibility getAJAccessibility() throws JavaModelException {
        IAspectJElementInfo info = (IAspectJElementInfo)this.getElementInfo();
        return info.getAJAccessibility();
    }

    public List getAJModifiers() throws JavaModelException {
        IAspectJElementInfo info = (IAspectJElementInfo)this.getElementInfo();
        return info.getAJModifiers();
    }

    public IProgramElement.ExtraInformation getAJExtraInformation() throws JavaModelException {
        IAspectJElementInfo info = (IAspectJElementInfo)this.getElementInfo();
        return info.getAJExtraInfo();
    }
}

