/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.builder;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.core.builder.ClasspathLocation;
import org.eclipse.ajdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class BuildClasspathResolver {
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;

    public String getClasspath(IWorkspaceRoot root, IJavaProject javaProject) {
        if (this.binaryLocations == null) {
            try {
                this.computeClasspathLocations(root, (JavaProject)javaProject, new SimpleLookupTable());
            }
            catch (CoreException e) {
                AspectJPlugin.logException(e);
            }
        }
        StringBuffer classpath = new StringBuffer();
        int i = 0;
        while (i < this.binaryLocations.length) {
            classpath.append(this.binaryLocations[i].toOSString());
            classpath.append(File.pathSeparator);
            ++i;
        }
        return classpath.toString();
    }

    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        IMarker cycleMarker = javaProject.getCycleMarker();
        if (cycleMarker != null) {
            int severity;
            int n = severity = "error".equals(javaProject.getOption("org.eclipse.jdt.core.circularClasspath", true)) ? 2 : 1;
            if (severity != (Integer)cycleMarker.getAttribute("severity")) {
                cycleMarker.setAttribute("severity", severity);
            }
        }
        IClasspathEntry[] classpathEntries = javaProject.getExpandedClasspath(true, false, null, null);
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        int i = 0;
        int l = classpathEntries.length;
        while (i < l) {
            ClasspathEntry entry = (ClasspathEntry)classpathEntries[i];
            IPath path = entry.getPath();
            Object target = JavaModel.getTarget((IContainer)root, (IPath)path, (boolean)true);
            if (target != null) {
                switch (entry.getEntryKind()) {
                    case 3: {
                        IProject outputFolder;
                        IPath outputPath;
                        if (!(target instanceof IContainer)) break;
                        IPath iPath = outputPath = entry.getOutputLocation() != null ? entry.getOutputLocation() : javaProject.getOutputLocation();
                        if (outputPath.segmentCount() == 1) {
                            outputFolder = javaProject.getProject();
                        } else {
                            outputFolder = root.getFolder(outputPath);
                            if (!outputFolder.exists()) {
                                this.createFolder((IContainer)outputFolder);
                            }
                        }
                        sLocations.add(ClasspathLocation.forSourceFolder((IContainer)target, (IContainer)outputFolder, entry.fullInclusionPatternChars(), entry.fullExclusionPatternChars()));
                        break;
                    }
                    case 2: {
                        IProject prereqProject;
                        if (!(target instanceof IProject) || !JavaProject.hasJavaNature((IProject)(prereqProject = (IProject)target))) break;
                        JavaProject prereqJavaProject = (JavaProject)JavaCore.create((IProject)prereqProject);
                        IClasspathEntry[] prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                        ArrayList<IContainer> seen = new ArrayList<IContainer>();
                        int j = 0;
                        int m = prereqClasspathEntries.length;
                        while (j < m) {
                            Object prereqTarget;
                            IClasspathEntry prereqEntry = prereqClasspathEntries[j];
                            if (prereqEntry.getEntryKind() == 3 && (prereqTarget = JavaModel.getTarget((IContainer)root, (IPath)prereqEntry.getPath(), (boolean)true)) instanceof IContainer) {
                                IContainer binaryFolder;
                                IPath prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                                IContainer iContainer = binaryFolder = prereqOutputPath.segmentCount() == 1 ? (IContainer)prereqProject : (IContainer)root.getFolder(prereqOutputPath);
                                if (binaryFolder.exists() && !seen.contains(binaryFolder)) {
                                    seen.add(binaryFolder);
                                    ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder(binaryFolder, true);
                                    bLocations.add(bLocation);
                                    if (binaryLocationsPerProject != null) {
                                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get((Object)prereqProject);
                                        if (existingLocations == null) {
                                            existingLocations = new ClasspathLocation[]{bLocation};
                                        } else {
                                            int size = existingLocations.length;
                                            ClasspathLocation[] classpathLocationArray = existingLocations;
                                            existingLocations = new ClasspathLocation[size + 1];
                                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                            existingLocations[size] = bLocation;
                                        }
                                        binaryLocationsPerProject.put((Object)prereqProject, (Object)existingLocations);
                                    }
                                }
                            }
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        if (target instanceof IResource) {
                            IResource resource = (IResource)target;
                            ClasspathLocation bLocation = null;
                            if (resource instanceof IFile) {
                                if (!Util.isArchiveFileName((String)path.lastSegment())) break;
                                bLocation = ClasspathLocation.forLibrary((IFile)resource);
                            } else if (resource instanceof IContainer) {
                                bLocation = ClasspathLocation.forBinaryFolder((IContainer)target, false);
                            }
                            bLocations.add(bLocation);
                            if (binaryLocationsPerProject == null) break;
                            IProject p = resource.getProject();
                            ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get((Object)p);
                            if (existingLocations == null) {
                                existingLocations = new ClasspathLocation[]{bLocation};
                            } else {
                                int size = existingLocations.length;
                                ClasspathLocation[] classpathLocationArray = existingLocations;
                                existingLocations = new ClasspathLocation[size + 1];
                                System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                existingLocations[size] = bLocation;
                            }
                            binaryLocationsPerProject.put((Object)p, (Object)existingLocations);
                            break;
                        }
                        if (!(target instanceof File) || !Util.isArchiveFileName((String)path.lastSegment())) break;
                        bLocations.add(ClasspathLocation.forLibrary(path.toString()));
                    }
                }
            }
            ++i;
        }
        ArrayList<ClasspathMultiDirectory> outputFolders = new ArrayList<ClasspathMultiDirectory>(1);
        this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
        if (!sLocations.isEmpty()) {
            sLocations.toArray(this.sourceLocations);
            int i2 = 0;
            int l2 = this.sourceLocations.length;
            while (i2 < l2) {
                block32: {
                    ClasspathMultiDirectory md = this.sourceLocations[i2];
                    IPath outputPath = md.binaryFolder.getFullPath();
                    int j = 0;
                    while (j < i2) {
                        if (outputPath.equals((Object)this.sourceLocations[j].binaryFolder.getFullPath())) {
                            md.hasIndependentOutputFolder = this.sourceLocations[j].hasIndependentOutputFolder;
                            break block32;
                        }
                        ++j;
                    }
                    outputFolders.add(md);
                    j = 0;
                    int m = this.sourceLocations.length;
                    while (j < m) {
                        if (!outputPath.equals((Object)this.sourceLocations[j].sourceFolder.getFullPath())) {
                            ++j;
                            continue;
                        }
                        break block32;
                    }
                    md.hasIndependentOutputFolder = true;
                }
                ++i2;
            }
        }
        this.binaryLocations = new ClasspathLocation[outputFolders.size() + bLocations.size()];
        int index = 0;
        int i3 = 0;
        int l3 = outputFolders.size();
        while (i3 < l3) {
            this.binaryLocations[index++] = (ClasspathLocation)outputFolders.get(i3);
            ++i3;
        }
        i3 = 0;
        l3 = bLocations.size();
        while (i3 < l3) {
            this.binaryLocations[index++] = (ClasspathLocation)bLocations.get(i3);
            ++i3;
        }
    }

    private void createFolder(IContainer folder) throws CoreException {
        if (!folder.exists()) {
            this.createFolder(folder.getParent());
            ((IFolder)folder).create(true, true, null);
        }
    }
}

