/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.isolation;

import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.isolation.EclipseVersionStrategy;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.osgi.framework.Bundle;

public class EclipseVersionIsolationLayer {
    private static final String STRATEGY_PREFIX = "org.eclipse.ajdt.internal.isolation.EclipseVersionStrategyImpl_";
    private static boolean strategyLoaded = false;
    private static EclipseVersionStrategy strategy = null;

    public static EclipseVersionStrategy getStrategy() {
        if (!strategyLoaded) {
            EclipseVersionIsolationLayer.loadStrategy();
        }
        return strategy;
    }

    private EclipseVersionIsolationLayer() {
    }

    private static void loadStrategy() {
        if (!strategyLoaded) {
            Bundle bundle = AspectJPlugin.getDefault().getBundle();
            String bundleVersion = (String)bundle.getHeaders().get("Bundle-Version");
            PluginVersionIdentifier ident = new PluginVersionIdentifier(bundleVersion);
            String version = String.valueOf(ident.getMajorComponent()) + "_" + ident.getMinorComponent() + "_" + ident.getServiceComponent();
            try {
                Class<?> strategyClass = Class.forName(STRATEGY_PREFIX + version);
                strategy = (EclipseVersionStrategy)strategyClass.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {}
        }
        strategyLoaded = true;
    }
}

