/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.views.Menu;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class VisualiserPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.contribution.visualiser";
    public static int LOGLEVEL = 2;
    public static Visualiser visualiser;
    public static Menu menu;
    private static VisualiserPlugin plugin;
    private ResourceBundle resourceBundle;

    public VisualiserPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.contribution.visualiser.VisualiserPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static ProviderManager getProviderManager() {
        return ProviderManager.getProviderManager();
    }

    public static void refresh() {
        if (visualiser != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IViewPart ivp;
                    IWorkbenchPage iwp;
                    IWorkbenchWindow iww;
                    if (visualiser != null && (iww = VisualiserPlugin.getActiveWorkbenchWindow()) != null && (iwp = iww.getActivePage()) != null && (ivp = iwp.findView("org.eclipse.contribution.visualiser.views.Visualiser")) != null) {
                        visualiser.updateDisplay(true);
                    }
                }
            });
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static VisualiserPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = VisualiserPlugin.getDefault().getResourceBundle();
        if (bundle == null) {
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void trace(String string) {
        System.err.println(string);
    }

    public void setVisualiser(Visualiser visualiser) {
        VisualiserPlugin.visualiser = visualiser;
        VisualiserPlugin.visualiser.setVisContentProvider(ProviderManager.getContentProvider());
        VisualiserPlugin.visualiser.setVisMarkupProvider(ProviderManager.getMarkupProvider());
    }

    public void removeVisualiser() {
        visualiser = null;
    }

    public void setMenu(Menu menu) {
        VisualiserPlugin.menu = menu;
        VisualiserPlugin.menu.setVisMarkupProvider(ProviderManager.getMarkupProvider());
    }

    public void removeMenu() {
        menu = null;
    }

    public static void log(int logLevel, String message) {
    }

    public static void logException(Throwable e) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        VisualiserPlugin.getDefault().getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ProviderManager.initialise();
        VisualiserPreferences.initDefaults();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

