/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.core;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;

public class ProviderDefinition {
    private String name;
    private String id;
    private boolean enabled = false;
    private String description = "";
    private String title;
    private IContentProvider contentInstance;
    private IMarkupProvider markupInstance;
    private int priority = 0;
    private String paletteID;

    public ProviderDefinition(String id, String className, IContentProvider contentP, IMarkupProvider markupP) {
        this.id = id;
        this.name = className;
        this.contentInstance = contentP;
        this.markupInstance = markupP;
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEnabled(boolean checked) {
        this.enabled = checked;
        if (this.enabled) {
            ProviderManager.setCurrent(this);
            VisualiserPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.contribution.visualiser.preferences.provider", this.getName());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public IContentProvider getContentProvider() {
        return this.contentInstance;
    }

    public IMarkupProvider getMarkupInstance() {
        return this.markupInstance;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.getName();
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPaletteID(String paletteID) {
        this.paletteID = paletteID;
    }

    public String getPaletteID() {
        return this.paletteID;
    }
}

