/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleContentProvider;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleGroup;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMember;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class FileContentProvider
extends SimpleContentProvider {
    private static final boolean debugLoading = false;

    public void initialise() {
        if (this.numberOfGroupsDefined() == 0) {
            try {
                URL url = VisualiserPlugin.getDefault().getBundle().getEntry("/");
                URL resolved = Platform.resolve((URL)url);
                URL fileURL = new URL(resolved, "Content.vis");
                InputStream in = fileURL.openStream();
                this.loadVisContents(in);
                in.close();
            }
            catch (IOException ioe) {
                VisualiserPlugin.logException(ioe);
            }
        }
    }

    public static void log(int msgType, String msg, Exception e) {
        VisualiserPlugin.getDefault().getLog().log((IStatus)new Status(msgType, "org.eclipse.contribution.visualiser", 0, msg, (Throwable)e));
    }

    public void loadVisContents(InputStream in) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            SimpleGroup grp = null;
            while (line != null && line.length() != 0) {
                if (line.startsWith("Group:")) {
                    String grpname = FileContentProvider.retrieveKeyValue("Group:", line);
                    grp = new SimpleGroup(grpname);
                    this.addGroup(grp);
                } else if (line.startsWith("Member:")) {
                    String tipStr;
                    String memname = FileContentProvider.retrieveKeyValue("Member:", line);
                    SimpleMember mem = new SimpleMember(memname);
                    String sizeStr = FileContentProvider.retrieveKeyValue("Size:", line);
                    if (sizeStr != null) {
                        mem.setSize(Integer.parseInt(sizeStr));
                    }
                    if ((tipStr = FileContentProvider.retrieveKeyValue("Tip:", line)) != null) {
                        mem.setTooltip(tipStr);
                    }
                    grp.add(mem);
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            FileContentProvider.log(4, "FileContentProvider failed to load file (FNF)", e);
        }
        catch (IOException e) {
            FileContentProvider.log(4, "FileContentProvider failed to load file (FNF)", e);
        }
    }

    private static String retrieveKeyValue(String what, String where) {
        if (where.indexOf(what) == -1) {
            return null;
        }
        String postWhat = where.substring(where.indexOf(what) + what.length());
        String result = postWhat;
        if (result.indexOf(" ") != -1) {
            result = postWhat.substring(0, postWhat.indexOf(" "));
        }
        result = result.replace('_', ' ');
        return result;
    }

    public String getEmptyMessage() {
        return VisualiserPlugin.getResourceString("FileContentProvider_EmptyMessage");
    }
}

