/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.interfaces.simpleImpl;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.simpleImpl.SimpleMarkupProvider;
import org.eclipse.core.runtime.Platform;

public class FileMarkupProvider
extends SimpleMarkupProvider {
    private static final boolean debugLoading = false;
    private Map kinds;

    public void initialise() {
        this.kinds = new HashMap();
        if (this.markups == null) {
            try {
                URL url = VisualiserPlugin.getDefault().getBundle().getEntry("/");
                URL resolved = Platform.resolve((URL)url);
                URL fileURL = new URL(resolved, "Markup.mvis");
                InputStream in = fileURL.openStream();
                this.loadMarkups(in);
                in.close();
            }
            catch (IOException ioe) {
                VisualiserPlugin.logException(ioe);
            }
        }
    }

    public void loadMarkups(InputStream in) {
        int scount = 0;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = br.readLine();
            while (line != null && line.length() != 0) {
                if (line.startsWith("Stripe:")) {
                    IMarkupKind kind;
                    String membername = null;
                    String kindStr = null;
                    int offset = 0;
                    int depth = 1;
                    membername = this.retrieveKeyValue("Stripe:", line);
                    kindStr = this.retrieveKeyValue("Kind:", line);
                    if (this.kinds.get(kindStr) instanceof IMarkupKind) {
                        kind = (IMarkupKind)this.kinds.get(kindStr);
                    } else {
                        kind = new SimpleMarkupKind(kindStr);
                        this.kinds.put(kindStr, kind);
                    }
                    offset = Integer.parseInt(this.retrieveKeyValue("Offset:", line));
                    depth = Integer.parseInt(this.retrieveKeyValue("Depth:", line));
                    Stripe newstripe = new Stripe(kind, offset, depth);
                    this.addMarkup(membername, newstripe);
                    ++scount;
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Problem loading markup data");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Problem loading markup data");
            e.printStackTrace();
        }
        this.processMarkups();
    }

    private String retrieveKeyValue(String what, String where) {
        if (where.indexOf(what) == -1) {
            return null;
        }
        String postWhat = where.substring(where.indexOf(what) + what.length());
        String result = postWhat;
        if (result.indexOf(" ") != -1) {
            result = postWhat.substring(0, postWhat.indexOf(" "));
        }
        result = result.replace('_', ' ');
        return result;
    }
}

