/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.jdtimpl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.resources.VisualiserImages;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtimpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class JDTContentProvider
implements IContentProvider,
ISelectionListener {
    protected IJavaProject currentProject;
    private IResource currentlySelectedResource;
    protected IJavaElement currentlySelectedJE;

    protected int getLength(ICompilationUnit element) {
        int lines = 0;
        try {
            String srccode = element.getSource();
            while (srccode.indexOf("\n") != -1) {
                ++lines;
                srccode = srccode.substring(srccode.indexOf("\n") + 1);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return lines;
    }

    public void trace(String string) {
        System.err.println(string);
    }

    public void selectionChanged(IWorkbenchPart iwp, ISelection is) {
        if (!ProviderManager.getContentProvider().equals(this)) {
            return;
        }
        boolean updateRequired = false;
        try {
            if (is instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)is;
                Object o = structuredSelection.getFirstElement();
                if (o != null) {
                    if (o instanceof IResource) {
                        this.currentlySelectedResource = (IResource)o;
                    } else if (o instanceof IJavaElement) {
                        IJavaElement je;
                        this.currentlySelectedJE = je = (IJavaElement)o;
                        if (je.getUnderlyingResource() != null) {
                            if (!je.getUnderlyingResource().equals((Object)this.currentlySelectedResource)) {
                                updateRequired = true;
                            }
                            this.currentlySelectedResource = je.getUnderlyingResource();
                        }
                        if (je.getJavaProject() != null) {
                            this.setCurrentProject(je.getJavaProject());
                        }
                    }
                }
            } else {
                boolean cfr_ignored_0 = is instanceof ITextSelection;
            }
            if (updateRequired) {
                VisualiserPlugin.refresh();
            }
        }
        catch (JavaModelException jme) {
            System.err.println("Exception in JDTContentProvider.selectionChanged processing" + (Object)((Object)jme));
        }
    }

    public List getAllMembers(IGroup group) {
        return group.getMembers();
    }

    public List getAllMembers() {
        ArrayList<JDTMember> retval;
        block5: {
            block6: {
                block4: {
                    retval = null;
                    if (!(this.currentlySelectedResource instanceof IProject) || this.currentlySelectedJE instanceof IPackageFragment) break block4;
                    retval = new ArrayList<JDTMember>();
                    if (this.getCurrentProject() == null) break block5;
                    List pkgfrags = this.getAllJDTGroups(this.getCurrentProject());
                    Iterator pkgfragiter = pkgfrags.iterator();
                    while (pkgfragiter.hasNext()) {
                        IGroup grp = (IGroup)pkgfragiter.next();
                        retval.addAll(grp.getMembers());
                    }
                    break block5;
                }
                if (!(this.currentlySelectedJE instanceof IPackageFragment)) break block6;
                retval = new ArrayList();
                JDTGroup group = this.getGroupForFragment((IPackageFragment)this.currentlySelectedJE);
                if (group == null) break block5;
                retval.addAll(group.getMembers());
                break block5;
            }
            if (this.currentlySelectedJE instanceof IJavaElement) {
                retval = new ArrayList();
                List pkgfrags = this.getAllJDTGroups(this.getCurrentProject());
                Iterator pkgfragiter = pkgfrags.iterator();
                block1: while (pkgfragiter.hasNext()) {
                    IGroup grp = (IGroup)pkgfragiter.next();
                    List mems = grp.getMembers();
                    Iterator memIter = mems.iterator();
                    while (memIter.hasNext()) {
                        JDTMember element = (JDTMember)memIter.next();
                        if (!element.getResource().equals(this.currentlySelectedJE)) continue;
                        retval.add(element);
                        continue block1;
                    }
                }
            }
        }
        return retval;
    }

    public void initialise() {
        if (VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    public void lookForData() {
        IWorkbenchPage iwp;
        IWorkbenchWindow iww = VisualiserPlugin.getActiveWorkbenchWindow();
        if (iww != null && (iwp = iww.getActivePage()) != null) {
            String[] views = new String[]{JavaUI.ID_PACKAGES_VIEW, JavaUI.ID_PROJECTS_VIEW, "org.eclipse.jdt.ui.PackageExplorer"};
            int i = 0;
            while (i < views.length) {
                IStructuredSelection ss;
                Object o;
                ISelection is;
                ISelectionProvider isp;
                IViewPart ivp = iwp.findView(views[i]);
                if (ivp != null && (isp = ivp.getViewSite().getSelectionProvider()) != null && (is = isp.getSelection()) instanceof IStructuredSelection && (o = (ss = (IStructuredSelection)is).getFirstElement()) != null && o instanceof IJavaElement) {
                    IJavaElement je;
                    this.currentlySelectedJE = je = (IJavaElement)o;
                    if (je.getJavaProject() != null) {
                        this.setCurrentProject(je.getJavaProject());
                    }
                    VisualiserPlugin.refresh();
                    return;
                }
                ++i;
            }
        }
    }

    public boolean processMouseclick(IMember member, boolean markupWasClicked, int buttonClicked) {
        IJavaElement jEl;
        if (buttonClicked != 1) {
            return true;
        }
        if (markupWasClicked) {
            return false;
        }
        if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
            JDTUtils.openInEditor(jEl.getResource(), JDTUtils.getClassDeclLineNum(jEl));
        }
        return false;
    }

    public List getAllGroups() {
        List<IGroup> retval = null;
        if (this.currentlySelectedResource instanceof IProject && !(this.currentlySelectedJE instanceof IPackageFragment)) {
            retval = this.getAllJDTGroups(this.getCurrentProject());
        } else if (this.currentlySelectedJE instanceof IPackageFragment) {
            retval = new ArrayList();
            JDTGroup oneGroup = this.getGroupForFragment((IPackageFragment)this.currentlySelectedJE);
            retval.add(oneGroup);
        } else if (this.currentlySelectedJE instanceof IJavaElement) {
            retval = new ArrayList();
            List pkgfrags = this.getAllJDTGroups(this.getCurrentProject());
            Iterator pkgfragiter = pkgfrags.iterator();
            block0: while (pkgfragiter.hasNext()) {
                IGroup grp = (IGroup)pkgfragiter.next();
                List mems = grp.getMembers();
                Iterator memIter = mems.iterator();
                while (memIter.hasNext()) {
                    JDTMember element = (JDTMember)memIter.next();
                    if (!element.getResource().equals(this.currentlySelectedJE)) continue;
                    retval.add(element.getContainingGroup());
                    continue block0;
                }
            }
        }
        return retval;
    }

    public JDTGroup getGroupForFragment(IPackageFragment ipf) {
        JDTGroup jdtg = null;
        try {
            if (ipf.getKind() != 2) {
                if (ipf.isDefaultPackage()) {
                    if (ipf.containsJavaResources()) {
                        jdtg = new JDTGroup("[default]");
                    }
                } else {
                    jdtg = new JDTGroup(ipf.getElementName());
                }
                if (jdtg != null) {
                    List members = this.getAllJDTMembers(ipf);
                    if (members.size() == 0) {
                        return null;
                    }
                    jdtg.addMembers(members);
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return jdtg;
    }

    public List getAllJDTGroups(IJavaProject JP) {
        LinkedList<JDTGroup> returningPackages = new LinkedList<JDTGroup>();
        try {
            IPackageFragment[] fragments = JP.getPackageFragments();
            int i = 0;
            while (i < fragments.length) {
                JDTGroup group = this.getGroupForFragment(fragments[i]);
                if (group != null) {
                    returningPackages.add(group);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return returningPackages;
    }

    public List getAllJDTMembers(IPackageFragment PF) {
        LinkedList<JDTMember> returningClasses = new LinkedList<JDTMember>();
        try {
            if (this.containsUsefulStuff(PF)) {
                IJavaElement[] ijes = PF.getChildren();
                int j = 0;
                while (j < ijes.length) {
                    if (ijes[j].getElementType() == 5) {
                        String memberName = ijes[j].getElementName();
                        if (memberName.endsWith(".java")) {
                            memberName = memberName.substring(0, memberName.length() - 5);
                        }
                        JDTMember member = new JDTMember(memberName, ijes[j]);
                        member.setSize(this.getLength((ICompilationUnit)ijes[j]));
                        returningClasses.add(member);
                    }
                    ++j;
                }
            }
        }
        catch (JavaModelException jme) {
            System.err.println((Object)jme);
        }
        return returningClasses;
    }

    protected boolean containsUsefulStuff(IPackageFragment fragment) {
        try {
            IPackageFragmentRoot ipfr;
            if (fragment.getKind() == 3 && (ipfr = (IPackageFragmentRoot)fragment).getKind() == 2) {
                return false;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return true;
    }

    public String getEmptyMessage() {
        return VisualiserPlugin.getResourceString("JDTContentProvider_EmptyMessage");
    }

    public ImageDescriptor getMemberViewIcon() {
        return VisualiserImages.CLASS_VIEW;
    }

    public ImageDescriptor getGroupViewIcon() {
        return VisualiserImages.PACKAGE_VIEW;
    }

    protected void setCurrentProject(IJavaProject currentProject) {
        this.currentProject = currentProject;
    }

    public IJavaProject getCurrentProject() {
        return this.currentProject;
    }
}

