/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.views.ClassicVisualiserRenderer;
import org.eclipse.contribution.visualiser.views.VisualiserCanvas;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class DefaultVisualiserRenderer
extends ClassicVisualiserRenderer {
    private int spacing = 4;
    private int columnTitleHeight = -1;
    private int margin = 6;
    private Font sysFont;
    protected Color outlineColor = new Color((Device)Display.getDefault(), 172, 168, 153);
    protected Color outlineColor2 = new Color((Device)Display.getDefault(), 214, 211, 195);
    protected Color lightGrayGradientColor = new Color((Device)Display.getDefault(), 230, 230, 230);
    protected Color[] colorList = new Color[]{VisualiserCanvas.VIS_BG_COLOUR, this.outlineColor2, this.outlineColor};
    protected static int cornerSize = 6;
    protected static byte[][] cornerData;
    private static ImageData header;

    static {
        byte[][] byArrayArray = new byte[11][];
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        byArray[1] = 5;
        byArray[3] = 5;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[1] = 1;
        byArray2[2] = 1;
        byArray2[3] = 2;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byArrayArray[2] = new byte[]{1, 3, 1, 3, 1};
        byArrayArray[3] = new byte[]{2, 4, 1, 5, 1};
        byte[] byArray3 = new byte[5];
        byArray3[1] = 1;
        byArray3[2] = 2;
        byArray3[3] = 1;
        byArray3[4] = 2;
        byArrayArray[4] = byArray3;
        byArrayArray[5] = new byte[]{1, 2, 2, 2, 2};
        byArrayArray[6] = new byte[]{2, 3, 2, 3, 2};
        byArrayArray[7] = new byte[]{1, 1, 3, 1, 3};
        byArrayArray[8] = new byte[]{2, 2, 3, 2, 3};
        byte[] byArray4 = new byte[5];
        byArray4[0] = 1;
        byArray4[2] = 4;
        byArray4[4] = 5;
        byArrayArray[9] = byArray4;
        byArrayArray[10] = new byte[]{2, 1, 4, 1, 5};
        cornerData = byArrayArray;
    }

    public int getColumnHeaderHeight() {
        return super.getColumnHeaderHeight() + 2;
    }

    private void createHeader(int width) {
        byte[] b;
        Image headerImg = new Image((Device)Display.getDefault(), width, this.getColumnHeaderHeight());
        GC gc = new GC((Drawable)headerImg);
        gc.setBackground(this.colorList[0]);
        gc.fillRectangle(0, 0, width, this.getColumnHeaderHeight());
        gc.setForeground(ColorConstants.titleBackground);
        gc.setBackground(ColorConstants.titleGradient);
        gc.fillGradientRectangle(1, 1, width - 1, this.getColumnHeaderHeight() - 1, true);
        int i = 0;
        while (i < cornerData.length) {
            b = cornerData[i];
            gc.setForeground(this.colorList[b[0]]);
            gc.drawLine((int)b[1], (int)b[2], (int)b[3], (int)b[4]);
            ++i;
        }
        i = 0;
        while (i < cornerData.length) {
            b = cornerData[i];
            gc.setForeground(this.colorList[b[0]]);
            gc.drawLine(width - b[1], (int)b[2], width - b[3], (int)b[4]);
            ++i;
        }
        header = headerImg.getImageData();
        gc.dispose();
        headerImg.dispose();
    }

    public void paintColumnHeader(GC gc, IMember m, int x, int colWidth) {
        int title_y_start = this.getMarginSize();
        int title_y_height = this.getColumnHeaderHeight();
        if (header == null || DefaultVisualiserRenderer.header.width != colWidth) {
            this.createHeader(colWidth);
        }
        Image headerImg = new Image((Device)Display.getDefault(), header);
        gc.drawImage(headerImg, x, title_y_start);
        headerImg.dispose();
        String name = this.getConstrainedString(gc, m.getName(), colWidth - 4);
        int xoff = (colWidth - gc.stringExtent((String)name).x) / 2;
        gc.setForeground(ColorConstants.white);
        gc.drawString(name, x + xoff, title_y_start + 4, true);
        gc.setForeground(ColorConstants.black);
        gc.setForeground(this.outlineColor);
        gc.drawLine(x, title_y_start + cornerSize, x, title_y_start + title_y_height);
        gc.drawLine(x + cornerSize, title_y_start, x + colWidth - cornerSize, title_y_start);
        gc.drawLine(x + colWidth, title_y_start + cornerSize, x + colWidth, title_y_start + title_y_height);
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getMarginSize() {
        return this.margin;
    }

    public void paintColumn(GC gc, IMember m, int x, int yoff, int colWidth, int colHeight, boolean affected) {
        if (affected) {
            gc.setBackground(ColorConstants.white);
        } else {
            gc.setBackground(ColorConstants.buttonDarkest);
        }
        gc.fillRectangle(x, yoff, colWidth, colHeight);
        gc.drawRectangle(x, yoff, colWidth, colHeight);
    }
}

