/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.core.resources.VisualiserImages;
import org.eclipse.contribution.visualiser.interfaces.IContentProvider;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.IMarkupProvider;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferencesDialog;
import org.eclipse.contribution.visualiser.views.VisualiserCanvas;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class Visualiser
extends ViewPart {
    private VisualiserCanvas visCanvas;
    protected static IContentProvider contentP;
    protected static IMarkupProvider markupP;
    private static ImageDescriptor groupViewImage;
    private static ImageDescriptor memberViewImage;
    private static List data;
    private Action limitAction;
    private Action lockAction;
    private Action preferencesAction;
    private Action fitToViewAction;
    private static Action groupViewAction;
    private static Action memberViewAction;
    private Action zoomInAction;
    private Action zoomOutAction;
    private Action changeStripeModeAction;
    private static boolean inGroupView;
    private static boolean inLimitMode;
    private static boolean locked;
    private static boolean fitToView;
    private int maxBarWidth = 200;
    private String title;
    private String zoomString;

    static {
        groupViewImage = VisualiserImages.GROUP_VIEW;
        memberViewImage = VisualiserImages.MEMBER_VIEW;
        data = null;
        inGroupView = false;
        inLimitMode = false;
        locked = false;
        fitToView = false;
    }

    public Visualiser() {
        VisualiserPlugin.getDefault().setVisualiser(this);
    }

    public void createPartControl(Composite parent) {
        try {
            this.getSite().getPage().showView("org.eclipse.contribution.visualiser.views.Menu");
        }
        catch (PartInitException pie) {
            VisualiserPlugin.logException(pie);
        }
        this.visCanvas = new VisualiserCanvas(parent, this);
        this.makeActions();
        this.contributeToActionBars();
        memberViewAction.setChecked(true);
        String title = ProviderManager.getCurrent().getTitle();
        this.refreshTitle(title);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        boolean includeChangeStripeModeAction = false;
        if (markupP != null) {
            includeChangeStripeModeAction = markupP.hasMultipleModes();
        }
        this.fillLocalToolBar(bars.getToolBarManager(), includeChangeStripeModeAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.preferencesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.limitAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)groupViewAction);
        manager.add((IAction)memberViewAction);
    }

    private void fillLocalToolBar(IToolBarManager manager, boolean includeChangeStripeMode) {
        manager.add((IAction)this.zoomInAction);
        manager.add((IAction)this.zoomOutAction);
        manager.add((IAction)this.fitToViewAction);
        manager.add((IAction)this.lockAction);
        if (includeChangeStripeMode) {
            manager.add((IAction)this.changeStripeModeAction);
        }
        manager.add((IAction)this.limitAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)groupViewAction);
        manager.add((IAction)memberViewAction);
    }

    private void makeActions() {
        this.makeActionPreferences();
        this.makeActionChangeStripeMode();
        this.makeActionZoomin();
        this.makeActionZoomout();
        this.makeActionLimitvis();
        this.makeActionGroupView();
        this.makeActionMemberView();
        this.makeActionFitToView();
        this.makeActionLock();
    }

    private void makeActionPreferences() {
        this.preferencesAction = new Action(){

            public void run() {
                VisualiserPreferencesDialog vpd = new VisualiserPreferencesDialog(Visualiser.this.getViewSite().getShell());
                vpd.create();
                vpd.open();
            }
        };
        this.preferencesAction.setText(VisualiserPlugin.getResourceString("Preferences_24"));
        this.preferencesAction.setToolTipText(VisualiserPlugin.getResourceString("Preferences_Tip_25"));
        this.preferencesAction.setImageDescriptor(VisualiserImages.PREFERENCES);
    }

    private void makeActionLimitvis() {
        this.limitAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!inLimitMode) {
                    inLimitMode = true;
                } else {
                    inLimitMode = false;
                }
                this.setChecked(inLimitMode);
                Visualiser.this.updateDisplay(false);
            }
        };
        this.limitAction.setText(VisualiserPlugin.getResourceString("Limit_view_9"));
        this.limitAction.setToolTipText(VisualiserPlugin.getResourceString("Limits_visualisation_to_affected_bars_only_10"));
        this.limitAction.setImageDescriptor(VisualiserImages.LIMIT_MODE);
    }

    private void makeActionLock() {
        this.lockAction = new Action(){

            public void run() {
                locked = !locked;
                if (!locked) {
                    Visualiser.this.updateDisplay(true);
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this.lockAction.setText(VisualiserPlugin.getResourceString("Lock"));
        this.lockAction.setToolTipText(VisualiserPlugin.getResourceString("Lock_Tooltip"));
        this.lockAction.setImageDescriptor(VisualiserImages.LOCK);
    }

    private void makeActionFitToView() {
        this.fitToViewAction = new Action(){
            private String zString;

            public void run() {
                fitToView = !fitToView;
                if (fitToView) {
                    this.zString = Visualiser.this.zoomString;
                    Visualiser.this.setZoomString(VisualiserPlugin.getResourceString("Zoom.fittoview"));
                } else {
                    Visualiser.this.setZoomString(this.zString);
                }
                Visualiser.this.updateDisplay(false);
                Visualiser.this.zoomInAction.setEnabled(!fitToView);
                Visualiser.this.zoomOutAction.setEnabled(!fitToView);
            }

            public int getStyle() {
                return 2;
            }
        };
        this.fitToViewAction.setText(VisualiserPlugin.getResourceString("Absolute_Proportions"));
        this.fitToViewAction.setToolTipText(VisualiserPlugin.getResourceString("Absolute_Proportions"));
        this.fitToViewAction.setImageDescriptor(VisualiserImages.FIT_TO_VIEW);
    }

    private void makeActionChangeStripeMode() {
        this.changeStripeModeAction = new Action(){

            public void run() {
                if (markupP.changeMode()) {
                    Visualiser.this.updateDisplay(true);
                }
            }
        };
        this.changeStripeModeAction.setText(VisualiserPlugin.getResourceString("Change_Mode_22"));
        this.changeStripeModeAction.setToolTipText(VisualiserPlugin.getResourceString("Change_Mode_23"));
        ImageDescriptor changeID = VisualiserImages.CHANGE_STRIPE_MODE;
        this.changeStripeModeAction.setImageDescriptor(changeID);
    }

    private void makeActionMemberView() {
        memberViewAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                Visualiser.activateMemberView();
                Visualiser.this.updateDisplay(false);
            }
        };
        memberViewAction.setText(VisualiserPlugin.getResourceString("Class_View_15"));
        memberViewAction.setToolTipText(VisualiserPlugin.getResourceString("Changes_to_member_view_16"));
        memberViewAction.setImageDescriptor(memberViewImage);
    }

    private void makeActionGroupView() {
        groupViewAction = new Action(){

            public int getStyle() {
                return 2;
            }

            public void run() {
                if (!inGroupView) {
                    this.setChecked(true);
                    memberViewAction.setChecked(false);
                    inGroupView = true;
                } else {
                    this.setChecked(true);
                }
                Visualiser.activateGroupView();
                Visualiser.this.updateDisplay(false);
            }
        };
        groupViewAction.setText(VisualiserPlugin.getResourceString("Package_View_12"));
        groupViewAction.setToolTipText(VisualiserPlugin.getResourceString("Changes_to_group_view_13"));
        groupViewAction.setImageDescriptor(groupViewImage);
    }

    private void makeActionZoomout() {
        this.zoomOutAction = new Action(){

            public void run() {
                Visualiser.this.visCanvas.zoomOut();
            }
        };
        this.zoomOutAction.setText(VisualiserPlugin.getResourceString("Zoom_Out_6"));
        this.zoomOutAction.setToolTipText(VisualiserPlugin.getResourceString("Zooms_out_7"));
        this.zoomOutAction.setImageDescriptor(VisualiserImages.ZOOM_OUT);
    }

    private void makeActionZoomin() {
        this.zoomInAction = new Action(){

            public void run() {
                Visualiser.this.visCanvas.zoomIn();
            }
        };
        this.zoomInAction.setText(VisualiserPlugin.getResourceString("Zoom_In_3"));
        this.zoomInAction.setToolTipText(VisualiserPlugin.getResourceString("Zooms_in_on_visualisation_4"));
        this.zoomInAction.setImageDescriptor(VisualiserImages.ZOOM_IN);
    }

    public void zoominSetEnabled(boolean enabled) {
        this.zoomInAction.setEnabled(enabled);
    }

    public void zoomoutSetEnabled(boolean enabled) {
        this.zoomOutAction.setEnabled(enabled);
    }

    private static void activateGroupView() {
        inGroupView = true;
        memberViewAction.setChecked(false);
        groupViewAction.setChecked(true);
    }

    private static void activateMemberView() {
        inGroupView = false;
        memberViewAction.setChecked(true);
        groupViewAction.setChecked(false);
    }

    public void refreshTitle(String title) {
        this.title = title;
        this.refreshTitle();
    }

    private void refreshTitle() {
        String s = String.valueOf(VisualiserPlugin.getResourceString("Visualiser")) + " - " + this.title;
        if (this.zoomString != null && this.zoomString.length() > 0) {
            s = String.valueOf(s) + " (" + this.zoomString + ")";
        }
        this.setContentDescription(s);
    }

    public void setZoomString(String s) {
        this.zoomString = s;
        this.refreshTitle();
    }

    public void setMaxBarSize(int size) {
        this.maxBarWidth = size;
        if (data != null) {
            this.visCanvas.redraw(data);
        }
    }

    public int getMaxBarSize() {
        return this.maxBarWidth;
    }

    public int getMinBarSize() {
        return VisualiserPreferences.getMinBarSize();
    }

    public boolean isFitToView() {
        return fitToView;
    }

    public boolean isGroupView() {
        return inGroupView;
    }

    public void setFocus() {
        this.visCanvas.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.visCanvas.dispose();
    }

    public void draw() {
        this.visCanvas.redraw(data);
    }

    public void updateDisplay(boolean updateMenu) {
        if (!locked) {
            data = inGroupView ? (inLimitMode ? Visualiser.limitData(contentP.getAllGroups()) : contentP.getAllGroups()) : (inLimitMode ? Visualiser.limitData(contentP.getAllMembers()) : contentP.getAllMembers());
        }
        if (VisualiserPlugin.menu != null && updateMenu) {
            VisualiserPlugin.menu.reset();
            VisualiserPlugin.menu.ensureUptodate();
        }
        this.visCanvas.redraw(data);
    }

    private static List limitData(List data) {
        if (data == null) {
            return null;
        }
        Visualiser.log(3, "In limit processing: Input size: " + data.size());
        ArrayList activeBars = new ArrayList();
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            List stripes;
            Object element = iter.next();
            if (element instanceof IGroup) {
                IGroup aGroup = (IGroup)element;
                stripes = markupP.getGroupMarkups(aGroup);
                if (!Visualiser.containsActiveStripe(stripes)) continue;
                activeBars.add(element);
                continue;
            }
            IMember aMember = (IMember)element;
            stripes = markupP.getMemberMarkups(aMember);
            if (!Visualiser.containsActiveStripe(stripes)) continue;
            activeBars.add(element);
        }
        Visualiser.log(3, "Finished limit processing: Output size: " + activeBars.size());
        return activeBars;
    }

    private static boolean containsActiveStripe(List stripes) {
        if (stripes == null) {
            return false;
        }
        Iterator iter = stripes.iterator();
        while (iter.hasNext()) {
            Stripe element = (Stripe)iter.next();
            List kinds = element.getKinds();
            Iterator iterator = kinds.iterator();
            while (iterator.hasNext()) {
                IMarkupKind kind = (IMarkupKind)iterator.next();
                if (VisualiserPlugin.menu == null) {
                    return true;
                }
                if (!VisualiserPlugin.menu.getActive(kind)) continue;
                return true;
            }
        }
        return false;
    }

    public void setVisContentProvider(IContentProvider vcp) {
        contentP = vcp;
        memberViewImage = vcp.getMemberViewIcon() == null ? VisualiserImages.MEMBER_VIEW : vcp.getMemberViewIcon();
        ImageDescriptor imageDescriptor = groupViewImage = vcp.getGroupViewIcon() == null ? VisualiserImages.GROUP_VIEW : vcp.getGroupViewIcon();
        if (groupViewAction != null) {
            groupViewAction.setImageDescriptor(groupViewImage);
        }
        if (memberViewAction != null) {
            memberViewAction.setImageDescriptor(memberViewImage);
        }
    }

    public IMarkupProvider getVisMarkupProvider() {
        return markupP;
    }

    public void setVisMarkupProvider(IMarkupProvider vmp) {
        markupP = vmp;
    }

    protected void onlyShowColorsAffecting(String name) {
        ArrayList<String> names = new ArrayList<String>();
        List members = contentP.getAllMembers();
        boolean found = false;
        Iterator it = members.iterator();
        while (it.hasNext()) {
            IMember member = (IMember)it.next();
            if (!member.getToolTip().equals(name)) continue;
            found = true;
            List markups = markupP.getMemberMarkups(member);
            if (markups == null) {
                VisualiserPlugin.menu.onlyShow(null);
                return;
            }
            Iterator it2 = markups.iterator();
            while (it2.hasNext()) {
                Stripe stripe = (Stripe)it2.next();
                List kinds = stripe.getKinds();
                Iterator it3 = kinds.iterator();
                while (it3.hasNext()) {
                    IMarkupKind kind = (IMarkupKind)it3.next();
                    if (names.contains(kind.getName())) continue;
                    names.add(kind.getName());
                }
            }
        }
        if (!found) {
            List groups = contentP.getAllGroups();
            Iterator it2 = groups.iterator();
            while (it2.hasNext()) {
                IGroup group = (IGroup)it2.next();
                if (!group.getToolTip().equals(name)) continue;
                List markups = markupP.getGroupMarkups(group);
                if (markups == null) {
                    VisualiserPlugin.menu.onlyShow(null);
                    return;
                }
                Iterator it22 = markups.iterator();
                while (it22.hasNext()) {
                    Stripe stripe = (Stripe)it22.next();
                    List kinds = stripe.getKinds();
                    Iterator it3 = kinds.iterator();
                    while (it3.hasNext()) {
                        IMarkupKind kind = (IMarkupKind)it3.next();
                        if (names.contains(kind.getName())) continue;
                        names.add(kind.getName());
                    }
                }
            }
        }
        VisualiserPlugin.menu.onlyShow(names);
    }

    protected void handleClick(IMember member, Stripe stripe, int buttonClicked) {
        boolean proceed = contentP.processMouseclick(member != null ? member : null, stripe != null, buttonClicked);
        if (stripe != null) {
            boolean bl = proceed = markupP.processMouseclick(member != null ? member : null, stripe, buttonClicked) && proceed;
        }
        if (proceed && buttonClicked != 3) {
            if (inGroupView) {
                Visualiser.activateMemberView();
            }
            this.updateDisplay(false);
        }
    }

    private static void log(int level, String string) {
        if (level <= VisualiserPlugin.LOGLEVEL) {
            System.err.println(string);
        }
    }
}

