/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AutomaticRouter;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;

public class FanRouter
extends AutomaticRouter {
    private int separation = 10;

    public int getSeparation() {
        return this.separation;
    }

    protected void handleCollision(PointList points, int index) {
        Point start = points.getFirstPoint();
        Point end = points.getLastPoint();
        Point midPoint = new Point((end.x + start.x) / 2, (end.y + start.y) / 2);
        Ray ray = new Ray(start, end);
        double length = ray.length();
        double xSeparation = (double)(this.separation * ray.x) / length;
        double ySeparation = (double)(this.separation * ray.y) / length;
        Point bendPoint = index % 2 == 0 ? new Point((double)midPoint.x + (double)(index / 2) * (-1.0 * ySeparation), (double)midPoint.y + (double)(index / 2) * xSeparation) : new Point((double)midPoint.x + (double)(index / 2) * ySeparation, (double)midPoint.y + (double)(index / 2) * (-1.0 * xSeparation));
        if (!bendPoint.equals(midPoint)) {
            points.insertPoint(bendPoint, 1);
        }
    }

    public void setSeparation(int value) {
        this.separation = value;
    }
}

