/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.AbstractLabeledBorder;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class GroupBoxBorder
extends AbstractLabeledBorder {
    public GroupBoxBorder() {
    }

    public GroupBoxBorder(String s) {
        super(s);
    }

    protected Insets calculateInsets(IFigure figure) {
        int height = this.getTextExtents((IFigure)figure).height;
        return new Insets(height);
    }

    public Dimension getPreferredSize(IFigure fig) {
        Dimension textSize = this.getTextExtents(fig);
        return textSize.getCopy().expand(textSize.height * 2, 0);
    }

    public boolean isOpaque() {
        return false;
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        AbstractBorder.tempRect.setBounds(AbstractBorder.getPaintRectangle(figure, insets));
        Rectangle r = AbstractBorder.tempRect;
        if (r.isEmpty()) {
            return;
        }
        Rectangle textLoc = new Rectangle(r.getTopLeft(), this.getTextExtents(figure));
        r.crop(new Insets(this.getTextExtents((IFigure)figure).height / 2));
        FigureUtilities.paintEtchedBorder(g, r);
        textLoc.x += this.getInsets((IFigure)figure).left;
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.clipRect(textLoc);
        g.fillText(this.getLabel(), textLoc.getTopLeft());
    }
}

