/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ajdocexport;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.ajdt.ajdocexport.JavadocOptionsManager;
import org.eclipse.ajdt.ajdocexport.JavadocProjectContentProvider;
import org.eclipse.ajdt.ajdocexport.JavadocWizardPage;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.jarpackager.CheckboxTreeAndListGroup;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocMemberContentProvider;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavadocTreeWizardPage
extends JavadocWizardPage {
    private CheckboxTreeAndListGroup fInputGroup;
    private Text fDestinationText;
    private Button fStandardButton;
    private Button fDestinationBrowserButton;
    private Button fPrivateVisibility;
    private Button fProtectedVisibility;
    private Button fPackageVisibility;
    private Button fPublicVisibility;
    private Label fDestinationLabel;
    private CLabel fDescriptionLabel;
    private String fVisibilitySelection;
    private JavadocOptionsManager fStore;
    private StatusInfo fJavadocStatus;
    private StatusInfo fDestinationStatus;
    private StatusInfo fDocletStatus;
    private StatusInfo fTreeStatus;
    private StatusInfo fPreferenceStatus;
    private StatusInfo fWizardStatus;
    private final int PREFERENCESTATUS = 0;
    private final int CUSTOMSTATUS = 1;
    private final int STANDARDSTATUS = 2;
    private final int TREESTATUS = 3;
    private final int JAVADOCSTATUS = 4;
    public ProjectProperties.FilenameFilter ajFileFilter = new ProjectProperties.FilenameFilter(){

        public boolean accept(String name) {
            return name.endsWith(".aj");
        }
    };

    protected JavadocTreeWizardPage(String pageName, JavadocOptionsManager store) {
        super(pageName);
        this.setDescription(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.javadoctreewizardpage.description"));
        this.fStore = store;
        this.fJavadocStatus = new StatusInfo();
        this.fDestinationStatus = new StatusInfo();
        this.fDocletStatus = new StatusInfo();
        this.fTreeStatus = new StatusInfo();
        this.fPreferenceStatus = new StatusInfo();
        this.fWizardStatus = store.getWizardStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        composite.setLayout((Layout)layout);
        this.createInputGroup(composite);
        this.createVisibilitySet(composite);
        this.createOptionsSet(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.javadoc_tree_page_context");
    }

    protected void createInputGroup(Composite composite) {
        this.createLabel(composite, 0, AspectJUIPlugin.getResourceString("ajdoc.info.projectselection"), this.createGridData(6));
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        c.setLayoutData((Object)this.createGridData(768, 6, 0));
        JavadocProjectContentProvider treeContentProvider = new JavadocProjectContentProvider();
        JavadocMemberContentProvider listContentProvider = new JavadocMemberContentProvider();
        this.fInputGroup = new CheckboxTreeAndListGroup(c, (Object)this, (ITreeContentProvider)treeContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (IStructuredContentProvider)listContentProvider, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), 0, this.convertWidthInCharsToPixels(60), this.convertHeightInCharsToPixels(7));
        this.fInputGroup.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                JavadocTreeWizardPage.this.doValidation(3);
            }
        });
        this.fInputGroup.setTreeSorter((ViewerSorter)new JavaElementSorter());
        IJavaElement[] elements = this.fStore.getInitialElements();
        this.setTreeChecked(elements);
        if (elements.length > 0) {
            this.fInputGroup.setTreeSelection((ISelection)new StructuredSelection((Object)elements[0].getJavaProject()));
        }
        this.fInputGroup.aboutToOpen();
    }

    private void createVisibilitySet(Composite composite) {
        GridLayout visibilityLayout = this.createGridLayout(4);
        visibilityLayout.marginHeight = 0;
        visibilityLayout.marginWidth = 0;
        Composite visibilityGroup = new Composite(composite, 0);
        visibilityGroup.setLayoutData((Object)this.createGridData(768, 6, 0));
        visibilityGroup.setLayout((Layout)visibilityLayout);
        this.createLabel(visibilityGroup, 0, AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.visibilitygroup.label"), this.createGridData(768, 4, 0));
        this.fPrivateVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.privatebutton.label"), this.createGridData(768, 1, 0));
        this.fPackageVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.packagebutton.label"), this.createGridData(768, 1, 0));
        this.fProtectedVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.protectedbutton.label"), this.createGridData(768, 1, 0));
        this.fPublicVisibility = this.createButton(visibilityGroup, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.publicbutton.label"), this.createGridData(768, 1, 0));
        this.fDescriptionLabel = new CLabel(visibilityGroup, 16384);
        this.fDescriptionLabel.setLayoutData((Object)this.createGridData(768, 4, this.convertWidthInCharsToPixels(3) - 3));
        this.fPrivateVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PRIVATE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.privatevisibilitydescription.label"));
                }
            }
        });
        this.fPackageVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PACKAGE;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.packagevisibledescription.label"));
                }
            }
        });
        this.fProtectedVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PROTECTED;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.protectedvisibilitydescription.label"));
                }
            }
        });
        this.fPublicVisibility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    JavadocTreeWizardPage.this.fVisibilitySelection = ((JavadocTreeWizardPage)JavadocTreeWizardPage.this).fStore.PUBLIC;
                    JavadocTreeWizardPage.this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.publicvisibilitydescription.label"));
                }
            }
        });
        this.setVisibilitySettings();
    }

    protected void setVisibilitySettings() {
        this.fVisibilitySelection = this.fStore.getAccess();
        this.fPrivateVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PRIVATE));
        if (this.fPrivateVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.privatevisibilitydescription.label"));
        }
        this.fProtectedVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PROTECTED));
        if (this.fProtectedVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.protectedvisibilitydescription.label"));
        }
        this.fPackageVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PACKAGE));
        if (this.fPackageVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.packagevisibledescription.label"));
        }
        this.fPublicVisibility.setSelection(this.fVisibilitySelection.equals(this.fStore.PUBLIC));
        if (this.fPublicVisibility.getSelection()) {
            this.fDescriptionLabel.setText(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.publicvisibilitydescription.label"));
        }
    }

    private void createOptionsSet(Composite composite) {
        GridLayout layout = this.createGridLayout(4);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite group = new Composite(composite, 0);
        group.setLayoutData((Object)this.createGridData(768, 6, 0));
        group.setLayout((Layout)layout);
        this.fStandardButton = this.createButton(group, 16, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.standarddocletbutton.label"), this.createGridData(256, 4, 0));
        this.fDestinationLabel = this.createLabel(group, 0, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationfield.label"), this.createGridData(256, 1, this.convertWidthInCharsToPixels(3)));
        this.fDestinationText = this.createText(group, 2052, null, this.createGridData(768, 2, 0));
        ((GridData)this.fDestinationText.getLayoutData()).widthHint = 0;
        this.fDestinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocTreeWizardPage.this.doValidation(2);
            }
        });
        this.fDestinationBrowserButton = this.createButton(group, 8, JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationbrowse.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint((Button)this.fDestinationBrowserButton);
        this.fDestinationBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String text = JavadocTreeWizardPage.this.handleFolderBrowseButtonPressed(JavadocTreeWizardPage.this.fDestinationText.getText(), JavadocTreeWizardPage.this.fDestinationText.getShell(), JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationbrowsedialog.title"), JavadocExportMessages.getString((String)"JavadocTreeWizardPage.destinationbrowsedialog.label"));
                JavadocTreeWizardPage.this.fDestinationText.setText(text);
            }
        });
        this.setOptionSetSettings();
    }

    private void setOptionSetSettings() {
        if (!this.fStore.isFromStandard()) {
            this.fDestinationText.setText(this.fStore.getDestination());
            this.fDestinationText.setEnabled(false);
            this.fDestinationBrowserButton.setEnabled(false);
            this.fDestinationLabel.setEnabled(false);
        } else {
            this.fStandardButton.setSelection(true);
            this.fDestinationText.setText(this.fStore.getDestination());
        }
    }

    private void setTreeChecked(IJavaElement[] sourceElements) {
        int i = 0;
        while (i < sourceElements.length) {
            IPackageFragmentRoot root;
            IJavaElement curr = sourceElements[i];
            if (curr instanceof ICompilationUnit) {
                this.fInputGroup.initialCheckListItem((Object)curr);
            } else if (curr instanceof IPackageFragment) {
                this.fInputGroup.initialCheckTreeItem((Object)curr);
            } else if (curr instanceof IJavaProject) {
                this.fInputGroup.initialCheckTreeItem((Object)curr);
            } else if (curr instanceof IPackageFragmentRoot && !(root = (IPackageFragmentRoot)curr).isArchive()) {
                this.fInputGroup.initialCheckTreeItem((Object)curr);
            }
            ++i;
        }
    }

    private IPath[] getSourcePath(IJavaProject[] projects) {
        HashSet<IPath> res = new HashSet<IPath>();
        int k = 0;
        while (k < projects.length) {
            IJavaProject iJavaProject = projects[k];
            try {
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPath p;
                    IResource resource;
                    IPackageFragmentRoot curr = roots[i];
                    if (curr.getKind() == 1 && (resource = curr.getResource()) != null && (p = resource.getLocation()) != null) {
                        res.add(p);
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log((Throwable)e);
            }
            ++k;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPath[] getClassPath(IJavaProject[] javaProjects) {
        HashSet<Path> res = new HashSet<Path>();
        int j = 0;
        while (j < javaProjects.length) {
            IJavaProject curr = javaProjects[j];
            try {
                IPath p = curr.getProject().getLocation();
                if (p != null) {
                    IPath outputLocation = p.append(curr.getOutputLocation());
                    String[] classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)curr);
                    int i = 0;
                    while (i < classPath.length) {
                        Path path = new Path(classPath[i]);
                        if (!outputLocation.equals((Object)path)) {
                            res.add(path);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                JavaPlugin.log((Throwable)e);
            }
            ++j;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IJavaElement[] getSourceElements(IJavaProject[] projects) {
        ArrayList<Object> res = new ArrayList<Object>();
        try {
            Set allChecked = this.fInputGroup.getAllCheckedTreeItems();
            HashSet<String> incompletePackages = new HashSet<String>();
            int h = 0;
            while (h < projects.length) {
                IJavaProject iJavaProject = projects[h];
                IPackageFragmentRoot[] roots = iJavaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IPackageFragmentRoot root = roots[i];
                    if (root.getKind() == 1) {
                        IJavaElement[] packs = root.getChildren();
                        int k = 0;
                        while (k < packs.length) {
                            IJavaElement curr = packs[k];
                            if (curr.getElementType() == 4 && (curr.getElementName().length() == 0 || !allChecked.contains(curr) || this.fInputGroup.isTreeItemGreyChecked((Object)curr))) {
                                incompletePackages.add(curr.getElementName());
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
                ++h;
            }
            Iterator checkedElements = this.fInputGroup.getAllCheckedListItems();
            while (checkedElements.hasNext()) {
                ICompilationUnit unit;
                Object element = checkedElements.next();
                if (!(element instanceof ICompilationUnit) || !incompletePackages.contains((unit = (ICompilationUnit)element).getParent().getElementName())) continue;
                res.add(unit);
            }
            HashSet<String> addedPackages = new HashSet<String>();
            checkedElements = allChecked.iterator();
            while (checkedElements.hasNext()) {
                IPackageFragment fragment;
                String name;
                Object element = checkedElements.next();
                if (!(element instanceof IPackageFragment) || incompletePackages.contains(name = (fragment = (IPackageFragment)element).getElementName()) || addedPackages.contains(name)) continue;
                res.add(fragment);
                addedPackages.add(name);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
        return res.toArray(new IJavaElement[res.size()]);
    }

    protected void updateStore(IJavaProject[] checkedProjects) {
        if (this.fStandardButton.getSelection()) {
            this.fStore.setFromStandard(true);
            this.fStore.setDestination(this.fDestinationText.getText());
        }
        this.fStore.setSourcepath(this.getSourcePath(checkedProjects));
        this.fStore.setClasspath(this.getClassPath(checkedProjects));
        this.fStore.setAccess(this.fVisibilitySelection);
        this.fStore.setCheckedProjects(checkedProjects);
    }

    public IJavaProject[] getCheckedProjects() {
        ArrayList<Object> res = new ArrayList<Object>();
        TreeItem[] treeItems = this.fInputGroup.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            Object curr;
            if (treeItems[i].getChecked() && (curr = treeItems[i].getData()) instanceof IJavaProject) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new IJavaProject[res.size()]);
    }

    protected void doValidation(int validate) {
        switch (validate) {
            case 0: {
                this.fPreferenceStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this.fStandardButton.getSelection()) break;
                this.fDestinationStatus = new StatusInfo();
                this.fDocletStatus = new StatusInfo();
                Path path = new Path(this.fDestinationText.getText());
                if (Path.ROOT.equals((Object)path) || Path.EMPTY.equals((Object)path)) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString((String)"JavadocTreeWizardPage.nodestination.error"));
                }
                File file = new File(path.toOSString());
                if (!path.isValidPath(path.toOSString()) || file.isFile()) {
                    this.fDestinationStatus.setError(JavadocExportMessages.getString((String)"JavadocTreeWizardPage.invaliddestination.error"));
                }
                if (path.append("package-list").toFile().exists() || path.append("index.html").toFile().exists()) {
                    this.fDestinationStatus.setWarning(AspectJUIPlugin.getResourceString("ajdocTreeWizardPage.warning.mayoverwritefiles"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
            case 3: {
                this.fTreeStatus = new StatusInfo();
                if (this.fInputGroup.getCheckedElementCount() == 0) {
                    this.fTreeStatus.setError(AspectJUIPlugin.getResourceString("ajdoc.error.noProjectSelected"));
                }
                this.updateStatus(this.findMostSevereStatus());
                break;
            }
        }
    }

    private boolean validDocletPath(String docletPath) {
        StringTokenizer tokens = new StringTokenizer(docletPath, ";");
        while (tokens.hasMoreTokens()) {
            File file = new File(tokens.nextToken());
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fTreeStatus, this.fPreferenceStatus, this.fDestinationStatus, this.fDocletStatus, this.fJavadocStatus, this.fWizardStatus});
    }

    public void init() {
        this.updateStatus((IStatus)new StatusInfo());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(4);
            this.doValidation(2);
            this.doValidation(1);
            this.doValidation(3);
            this.doValidation(0);
        }
    }
}

