/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurationCreationException;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.Util;
import org.eclipse.ajdt.buildconfigurator.editor.BuildProperties;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BuildConfiguration
implements Cloneable,
Util.Comparable {
    public static final String EXTENSION = "ajproperties";
    public static final String STANDARD_BUILD_CONFIGURATION_NAME = "build";
    public static final int LST_FILE_LINK = 5;
    private String name;
    private BuildProperties propertiesFile;
    private HashSet fileList;
    private ProjectBuildConfigurator pbc;
    private boolean listenToFileChanges = true;

    public BuildConfiguration(String name, IJavaProject jp, ProjectBuildConfigurator pbc) {
        this.pbc = pbc;
        this.name = name;
        this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
        if (this.fileList != null) {
            this.propertiesFile = new BuildProperties(this.getFileFromName(name), this.minimizeIncludes(this.fileList));
        } else {
            try {
                IClasspathEntry[] cpes2 = jp.getRawClasspath();
                if (BuildConfigurator.getBuildConfigurator().haveExclusionPatterns(cpes2)) {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getFileSetFromCPE(cpes2, jp);
                    this.propertiesFile = new BuildProperties(this.getFileFromName(name), this.minimizeIncludes(this.fileList));
                } else {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
                    if (this.fileList != null) {
                        this.propertiesFile = new BuildProperties(this.getFileFromName(name), this.minimizeIncludes(this.fileList));
                    } else {
                        ArrayList<IPath> pathes = new ArrayList<IPath>();
                        int i = 0;
                        while (i < cpes2.length) {
                            if (cpes2[i].getEntryKind() == 3) {
                                IPath p = cpes2[i].getPath();
                                IResource res = jp.getProject().getParent().findMember(p);
                                if (res != null && res.exists()) {
                                    pathes.add(res.getProjectRelativePath());
                                }
                            }
                            ++i;
                        }
                        this.propertiesFile = new BuildProperties(this.getFileFromName(name), pathes);
                    }
                }
            }
            catch (JavaModelException e) {
                AspectJUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    public IFile getFile() {
        return this.getFileFromName(this.name);
    }

    public BuildConfiguration(IFile existingFile, ProjectBuildConfigurator pbc) {
        this.pbc = pbc;
        this.loadDataFromFile(existingFile);
    }

    private HashSet getFileList() {
        if (this.fileList == null) {
            HashSet newList = new HashSet(20);
            newList.addAll(this.propertiesFile.getFiles(false));
            this.fileList = newList;
            return newList;
        }
        return this.fileList;
    }

    public BuildConfiguration(IFile lstFile2, Shell shell, ProjectBuildConfigurator pbc) {
        this.pbc = pbc;
        this.name = lstFile2.getName();
        this.name = this.name.substring(0, this.name.length() - 4);
        String title = AspectJUIPlugin.getResourceString("BCDialog.SaveLstAsAJProp.title");
        String msg = AspectJUIPlugin.getResourceString("BCDialog.SaveLstAsAJProp.message").replaceAll("%src", this.name);
        InputDialogWithCheck md = new InputDialogWithCheck(shell, title, msg, String.valueOf(this.name) + "." + EXTENSION, null);
        md.setBlockOnOpen(true);
        if (md.open() == 0 && md.getValue() != null) {
            String fileName = md.getValue();
            if (!fileName.endsWith(".ajproperties")) {
                fileName = String.valueOf(fileName) + "." + EXTENSION;
            }
            IFile file = pbc.getJavaProject().getProject().getFile(fileName);
            this.name = BuildConfiguration.getNameFromFile(file);
            if (file.exists() && !this.askUserOverwrite(fileName)) {
                return;
            }
            this.fileList = new HashSet();
            this.addLStFileContentsToFileList(lstFile2);
            this.propertiesFile = new BuildProperties(this.getFileFromName(this.name), this.minimizeIncludes(this.fileList));
            pbc.addBuildConfiguration(this);
            if (md.isChecked()) {
                pbc.setActiveBuildConfiguration(this);
            }
        }
    }

    private List minimizeIncludes(HashSet fileList) {
        HashSet temp1 = (HashSet)fileList.clone();
        HashSet temp2 = new HashSet();
        boolean hasChanged = true;
        Iterator iter = temp1.iterator();
        while (hasChanged) {
            hasChanged = false;
            iter = temp1.iterator();
            while (iter.hasNext()) {
                IResource f = (IResource)iter.next();
                IContainer cont = f.getParent();
                if (cont.getType() != 4) {
                    try {
                        IResource[] mems = cont.members();
                        boolean containsAll = true;
                        int i = 0;
                        while (i < mems.length) {
                            if (!temp1.contains(mems[i]) && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(mems[i].getName())) {
                                containsAll = false;
                                break;
                            }
                            if (!temp1.contains(mems[i]) && mems[i].getType() == 2) {
                                containsAll = false;
                                break;
                            }
                            ++i;
                        }
                        if (!containsAll) {
                            i = 0;
                            while (i < mems.length) {
                                if (temp1.remove(mems[i])) {
                                    temp2.add(mems[i]);
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < mems.length) {
                                temp1.remove(mems[i]);
                                ++i;
                            }
                            hasChanged = true;
                            temp2.add(cont);
                        }
                    }
                    catch (CoreException e1) {
                        AspectJUIPlugin.logException(e1);
                    }
                } else {
                    temp1.remove(f);
                    temp2.add(f);
                }
                iter = temp1.iterator();
            }
            HashSet temp3 = temp2;
            temp2 = temp1;
            temp1 = temp3;
        }
        return new ArrayList(temp1);
    }

    private void addLStFileContentsToFileList(IFile lstFile) {
        IFile f;
        String filename;
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents(lstFile.getLocation(), files, options, links);
        }
        catch (FileNotFoundException e) {
            AspectJUIPlugin.logException(e);
            return;
        }
        IProject pro = this.pbc.getJavaProject().getProject();
        IPath lstFileFolder = lstFile.getFullPath().removeLastSegments(1);
        int segs = lstFileFolder.matchingFirstSegments(pro.getFullPath());
        IPath relPath = lstFileFolder.removeFirstSegments(segs);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            filename = (String)iter.next();
            f = pro.getFile(relPath.append(filename));
            if (!f.exists()) continue;
            this.getFileList().add(f);
        }
        iter = links.iterator();
        while (iter.hasNext()) {
            filename = ((String)iter.next()).substring(1);
            f = pro.getFile(relPath.append(filename));
            if (!f.exists()) continue;
            this.addLStFileContentsToFileList(f);
        }
    }

    public BuildConfiguration(ProjectBuildConfigurator pbc, Shell parentShell) throws BuildConfigurationCreationException {
        this.pbc = pbc;
        String title = AspectJUIPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.title");
        String msg = AspectJUIPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.message");
        String def = AspectJUIPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.default");
        BuildConfiguration origBC = pbc.getActiveBuildConfiguration();
        final String forbiddenName = origBC.getName();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String input) {
                if (forbiddenName.equals(input) || (String.valueOf(forbiddenName) + "." + BuildConfiguration.EXTENSION).equals(input)) {
                    return AspectJUIPlugin.getResourceString("BCDialog.NameValidator.ExistsError");
                }
                return null;
            }
        };
        InputDialogWithCheck md = new InputDialogWithCheck(parentShell, title, msg, def, validator);
        md.setBlockOnOpen(true);
        if (md.open() == 0 && md.getValue() != null) {
            String newName;
            this.name = newName = md.getValue();
            IFile origFile = origBC.getFile();
            IFile newFile = this.getFile();
            if (newFile.exists()) {
                if (!this.askUserOverwrite(newFile.getName())) {
                    throw new BuildConfigurationCreationException();
                }
                try {
                    newFile.delete(true, null);
                }
                catch (CoreException e1) {
                    AspectJUIPlugin.logException(e1);
                }
            }
            try {
                origFile.copy(newFile.getFullPath(), true, null);
                this.propertiesFile = new BuildProperties(newFile);
            }
            catch (CoreException e) {
                this.propertiesFile = new BuildProperties(this.getFileFromName(this.name), new ArrayList(this.getFileList()));
                AspectJUIPlugin.logException(e);
            }
            this.fileList = new HashSet(this.propertiesFile.getFiles(false));
            pbc.addBuildConfiguration(this);
            if (md.isChecked()) {
                pbc.setActiveBuildConfiguration(this);
            }
        } else {
            throw new BuildConfigurationCreationException();
        }
    }

    IFile getFileFromName(String name) {
        return this.pbc.getJavaProject().getProject().getFile(String.valueOf(name) + "." + EXTENSION);
    }

    static String getNameFromFile(IFile file) {
        String n = file.getName();
        return n.substring(0, n.indexOf(".ajproperties"));
    }

    public void loadDataFromFile(IFile existingFile) {
        if (existingFile.exists()) {
            this.name = BuildConfiguration.getNameFromFile(existingFile);
            this.propertiesFile = new BuildProperties(existingFile);
        }
    }

    private String getLstContentFromData() {
        String files = "";
        Iterator iter = this.getFileList().iterator();
        while (iter.hasNext()) {
            files = files.concat(((IFile)iter.next()).getProjectRelativePath().toOSString().concat("\n"));
        }
        return files;
    }

    public String getName() {
        return this.name;
    }

    private boolean excludeFile(IResource file) throws CoreException {
        this.listenToFileChanges = false;
        this.propertiesFile.exclude(file);
        this.listenToFileChanges = true;
        if (file.getType() == 1) {
            this.getFileList().remove(file);
            return true;
        }
        return false;
    }

    public void excludeFiles(List exFiles) throws CoreException {
        Iterator iter = exFiles.iterator();
        boolean needsupdate = false;
        IResource res = null;
        while (iter.hasNext()) {
            res = (IResource)iter.next();
            if (this.excludeFile(res)) continue;
            needsupdate = true;
        }
        if (needsupdate) {
            this.update(false);
        }
        this.propertiesFile.writeFile();
    }

    private boolean includeFile(IResource file) {
        this.listenToFileChanges = false;
        this.propertiesFile.include(file);
        this.listenToFileChanges = true;
        if (file.getType() == 1) {
            this.getFileList().add(file);
            return true;
        }
        return false;
    }

    public void includeFiles(List exFiles) {
        Iterator iter = exFiles.iterator();
        boolean needsupdate = false;
        IResource res = null;
        while (iter.hasNext()) {
            res = (IResource)iter.next();
            if (this.includeFile(res)) continue;
            needsupdate = true;
        }
        if (needsupdate) {
            this.update(false);
        }
        this.propertiesFile.writeFile();
    }

    public boolean isIncluded(IResource file) {
        boolean isIncl = this.getFileList().contains(file);
        return isIncl;
    }

    public int compareTo(Util.Comparable o) {
        if (o instanceof BuildConfiguration) {
            return this.getName().compareToIgnoreCase(((BuildConfiguration)o).getName());
        }
        return 0;
    }

    public void update(boolean forceReadingFile) {
        if (this.listenToFileChanges) {
            if (this.fileList == null) {
                this.fileList = new HashSet();
            } else {
                this.fileList.clear();
            }
            List l = this.propertiesFile.getFiles(forceReadingFile);
            this.fileList.addAll(l);
        }
    }

    public List getIncludedJavaFiles(ProjectProperties.FilenameFilter filter) {
        Iterator iter = this.getFileList().iterator();
        ArrayList<File> list = new ArrayList<File>(this.getFileList().size());
        while (iter.hasNext()) {
            IResource res = (IResource)iter.next();
            if (!res.exists() || !filter.accept(res.getName())) continue;
            list.add(new File(res.getLocation().toOSString()));
        }
        return list;
    }

    public List getIncludedJavaFileNames(ProjectProperties.FilenameFilter filter) {
        Iterator iter = this.getFileList().iterator();
        ArrayList<String> list = new ArrayList<String>(this.getFileList().size());
        while (iter.hasNext()) {
            IResource res = (IResource)iter.next();
            if (!res.exists() || !filter.accept(res.getName())) continue;
            list.add(res.getLocation().toOSString());
        }
        return list;
    }

    public void writeLstFile() {
        this.update(false);
        String lstFileContent = this.getLstContentFromData();
        String title = AspectJUIPlugin.getResourceString("BCDialog.SaveAJPropAsLst.title");
        String msg = AspectJUIPlugin.getResourceString("BCDialog.SaveAJPropAsLst.message").replaceAll("%name", this.name);
        InputDialog md = new InputDialog(null, title, msg, String.valueOf(this.name) + ".lst", null);
        md.setBlockOnOpen(true);
        if (md.open() == 0 && md.getValue() != null) {
            String fileName = md.getValue();
            if (!fileName.endsWith(".lst")) {
                fileName = String.valueOf(fileName) + ".lst";
            }
            try {
                IFile file = this.pbc.getJavaProject().getProject().getFile(fileName);
                if (file.exists()) {
                    if (this.askUserOverwrite(fileName)) {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(lstFileContent.getBytes());
                        if (file.isReadOnly()) {
                            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null);
                        }
                        file.setContents((InputStream)inputStream, 1, null);
                    }
                } else {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(lstFileContent.getBytes());
                    file.create((InputStream)inputStream, 1, null);
                }
            }
            catch (CoreException e) {
                AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("buildConfig.exceptionWriting").replaceAll("%fileName", fileName), e);
            }
        }
    }

    private boolean askUserOverwrite(String fileName) {
        String msg;
        String[] options = new String[]{AspectJUIPlugin.getResourceString("BCDialog.Overwrite.yes"), AspectJUIPlugin.getResourceString("BCDialog.Overwrite.no")};
        String title = AspectJUIPlugin.getResourceString("BCDialog.Overwrite.title");
        MessageDialog mdiag = new MessageDialog(null, title, null, msg = AspectJUIPlugin.getResourceString("BCDialog.Overwrite.message").replaceAll("%fileName", fileName), 3, options, 1);
        return mdiag.open() == 0;
    }

    public boolean areFilesActive() {
        return this.getFileList().size() != 0;
    }

    public void updateSourceFolders(List sourcePathes) {
        this.propertiesFile.updateSourceFolders(sourcePathes);
        this.fileList = null;
    }

    private class InputDialogWithCheck
    extends InputDialog {
        private Button check;
        private boolean selected;

        public InputDialogWithCheck(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.check = new Button(composite, 32);
            this.check.setSelection(true);
            this.check.setText(AspectJUIPlugin.getResourceString("BCDialog.Activate.check"));
            return composite;
        }

        protected void okPressed() {
            this.selected = this.check.getSelection();
            super.okPressed();
        }

        public boolean isChecked() {
            return this.selected;
        }
    }
}

