/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.util.ArrayList;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.IAspectJElement;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.TreeHierarchyLayoutProblemsDecorator;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class ImageDecorator
implements ILabelDecorator {
    private ArrayList listeners;
    private ImageDescriptorRegistry fRegistry;
    private boolean preventRecursion = false;
    private TreeHierarchyLayoutProblemsDecorator problemsDecorator;
    private DecoratorManager decman;
    private ImageDescriptor halfFilledPackageID;
    private ImageDescriptor activeConfigFileImage;
    private BuildConfigurator buildConfor;
    private AspectJImages iconRegistry = new AspectJImages();

    public ImageDecorator() {
        this.listeners = new ArrayList(2);
        this.problemsDecorator = new TreeHierarchyLayoutProblemsDecorator();
        this.decman = WorkbenchPlugin.getDefault().getDecoratorManager();
        this.halfFilledPackageID = AspectJImages.BC_HALF_FILLED_PACKAGE.getImageDescriptor();
        this.activeConfigFileImage = AspectJImages.BC_SELECTED_FILE.getImageDescriptor();
        this.buildConfor = BuildConfigurator.getBuildConfigurator();
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image decorateImage(Image image, Object element) {
        if (this.preventRecursion) {
            return null;
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit comp = (ICompilationUnit)element;
            try {
                element = comp.getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                element = null;
            }
        }
        Image img = null;
        if (element instanceof IAspectJElement) {
            try {
                IAspectJElement ajElem = (IAspectJElement)element;
                IProgramElement.Accessibility acceb = ajElem.getAJAccessibility();
                AJDTIcon icon = acceb == null ? (ajElem.getAJKind() == IProgramElement.Kind.ADVICE ? (AJDTIcon)this.iconRegistry.getAdviceIcon(ajElem.getAJExtraInformation(), false) : (AJDTIcon)this.iconRegistry.getIcon(ajElem.getAJKind())) : (AJDTIcon)this.iconRegistry.getStructureIcon(ajElem.getAJKind(), ajElem.getAJAccessibility());
                if (icon != null) {
                    img = this.getImageLabel(this.getJavaImageDescriptor(icon.getImageDescriptor(), image.getBounds(), this.computeJavaAdornmentFlags((IJavaElement)ajElem)));
                }
            }
            catch (JavaModelException e) {
                AspectJUIPlugin.logException(e);
            }
        } else if (element instanceof IFile) {
            ProjectBuildConfigurator pbc;
            IFile file = (IFile)element;
            if (ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(file.getName())) {
                ProjectBuildConfigurator pbc2 = this.buildConfor.getProjectBuildConfigurator(file.getProject());
                if (pbc2 == null) {
                    return null;
                }
                if (pbc2.getActiveBuildConfiguration().isIncluded((IResource)file)) {
                    Rectangle rect = image.getBounds();
                    img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT, rect, 0));
                } else {
                    Rectangle rect = image.getBounds();
                    img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_CUNIT_RESOURCE, rect, 0));
                }
            } else if ("ajproperties".equals(file.getFileExtension()) && (pbc = this.buildConfor.getProjectBuildConfigurator(file.getProject())) != null && file.equals((Object)pbc.getActiveBuildConfiguration().getFile())) {
                img = this.getImageLabel(this.getJavaImageDescriptor(this.activeConfigFileImage, image.getBounds(), 0));
            }
        } else if (element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            ProjectBuildConfigurator pbc = this.buildConfor.getProjectBuildConfigurator(pack.getJavaProject());
            if (pbc == null) {
                return null;
            }
            BuildConfiguration bc = pbc.getActiveBuildConfiguration();
            try {
                if (ImageDecorator.containsIncludedFiles(bc, pack)) {
                    if (ImageDecorator.containsExcludedFiles(bc, pack)) {
                        img = this.getImageLabel(this.getJavaImageDescriptor(this.halfFilledPackageID, image.getBounds(), 0));
                    } else if (!pack.containsJavaResources()) {
                        img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_PACKAGE, image.getBounds(), 0));
                    }
                } else if (ImageDecorator.containsExcludedFiles(bc, pack)) {
                    img = this.getImageLabel(this.getJavaImageDescriptor(JavaPluginImages.DESC_OBJS_EMPTY_PACKAGE, image.getBounds(), 0));
                }
            }
            catch (JavaModelException javaModelException) {}
        } else {
            return null;
        }
        if (img != null) {
            this.preventRecursion = true;
            img = this.problemsDecorator.decorateImage(img, element);
            img = this.decman.decorateImage(img, element);
            this.preventRecursion = false;
            return img;
        }
        return null;
    }

    public static boolean containsIncludedFiles(BuildConfiguration bc, IPackageFragment pack) {
        try {
            IJavaElement[] javachildren = pack.getChildren();
            int i = 0;
            while (i < javachildren.length) {
                IResource res = javachildren[i].getCorrespondingResource();
                if (res != null && res.getType() == 1 && bc.isIncluded(res)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean containsExcludedFiles(BuildConfiguration bc, IPackageFragment pack) {
        try {
            IJavaElement[] javachildren = pack.getChildren();
            int i = 0;
            while (i < javachildren.length) {
                IResource res = javachildren[i].getCorrespondingResource();
                if (res != null && res.getType() == 1 && !bc.isIncluded(res)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = JavaPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public ImageDescriptor getJavaImageDescriptor(ImageDescriptor descriptor, Rectangle rect, int adorflags) {
        int flags = rect.width == 16 ? 2 : 0;
        Point size = ImageDecorator.useSmallSize(flags) ? JavaElementImageProvider.SMALL_SIZE : JavaElementImageProvider.BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, adorflags, size);
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    public String decorateText(String text, Object element) {
        if (element instanceof AJCompilationUnit) {
            return text.replaceFirst(".java", ".aj");
        }
        if (element instanceof IAspectJElement) {
            try {
                IProgramElement.Kind kind = ((IAspectJElement)element).getAJKind();
                if (kind != IProgramElement.Kind.ASPECT && kind != IProgramElement.Kind.ADVICE && kind != IProgramElement.Kind.POINTCUT && kind != IProgramElement.Kind.INTER_TYPE_METHOD && kind != IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) {
                    return text.substring(0, text.length() - 2);
                }
            }
            catch (JavaModelException e) {
                AspectJUIPlugin.logException(e);
            }
        }
        return null;
    }

    private int computeJavaAdornmentFlags(IJavaElement element) {
        int flags = 0;
        if (element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract((int)(modifiers = member.getFlags())) && ImageDecorator.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 2;
                }
                if (Flags.isSynchronized((int)modifiers) && ImageDecorator.confirmSynchronized((IJavaElement)member)) {
                    flags |= 4;
                }
                if (Flags.isStatic((int)modifiers) || ImageDecorator.isInterfaceField(member)) {
                    flags |= 8;
                }
                if (Flags.isDeprecated((int)modifiers)) {
                    flags |= 0x400;
                }
                if (member.getElementType() == 7 && JavaModelUtil.hasMainMethod((IType)((IType)member))) {
                    flags |= 0x10;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return ((IType)element).isClass();
        }
        return element.getDeclaringType().isClass();
    }

    private static boolean isInterfaceField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }
}

