/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import org.eclipse.ajdt.buildconfigurator.editor.BuildInputContext;
import org.eclipse.ajdt.buildconfigurator.editor.BuildInputContextManager;
import org.eclipse.ajdt.buildconfigurator.editor.BuildOutlinePage;
import org.eclipse.ajdt.buildconfigurator.editor.BuildPage;
import org.eclipse.ajdt.buildconfigurator.editor.BuildSourcePage;
import org.eclipse.ajdt.buildconfigurator.editor.BuildUndoManager;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class BuildEditor
extends MultiSourceEditor {
    static /* synthetic */ Class class$0;

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        manager.putContext((IEditorInput)input, (InputContext)new BuildInputContext((PDEFormEditor)this, (IEditorInput)input, true));
        manager.monitorFile(file);
    }

    protected InputContextManager createInputContextManager() {
        BuildInputContextManager manager = new BuildInputContextManager((PDEFormEditor)this);
        manager.setUndoManager((IModelUndoManager)new BuildUndoManager((PDEFormEditor)this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        if (!this.inputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.inputContextManager.putContext((IEditorInput)in, (InputContext)new BuildInputContext((PDEFormEditor)this, (IEditorInput)in, false));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        IEditorInput in = this.inputContextManager.getPrimaryContext().getInput();
        if (in instanceof IFileEditorInput) {
            IFile changedFile = ((IFileEditorInput)in).getFile();
            AJDTEventTrace.buildConfigWrite(changedFile);
        }
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void contextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        manager.putContext((IEditorInput)input, (InputContext)new BuildInputContext((PDEFormEditor)this, (IEditorInput)input, true));
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, (InputContext)new BuildInputContext((PDEFormEditor)this, (IEditorInput)input, true));
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected void addPages() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.addPage((IFormPage)new BuildPage((FormEditor)this));
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException((Throwable)e);
        }
        this.addSourcePage("build-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.inputContextManager.getPrimaryContext();
            if (primary.getId().equals("build-context")) {
                firstPageId = "build";
            }
            if (firstPageId == null) {
                firstPageId = "build";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new BuildSourcePage(editor, title, name);
    }

    protected IContentOutlinePage createContentOutline() {
        return new BuildOutlinePage((PDEFormEditor)this);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return null;
    }

    public String getTitle() {
        return super.getTitle();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IBuildModel)model).isValid() : false;
    }

    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < transfers.length) {
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SWTError sWTError) {}
        return false;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return null;
        }
        return super.getAdapter(key);
    }
}

