/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.ajdt.buildconfigurator.editor.BuildEditor;
import org.eclipse.ajdt.buildconfigurator.editor.model.Build;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.BuildModel;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuild;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IBaseModel;

public class BuildProperties {
    private IFile myPropertiesFile;
    private IBuild build;
    private IBuildModel buildModel;

    public BuildProperties(IFile file) {
        this.myPropertiesFile = file;
    }

    public BuildProperties(IFile file, List sourceFolders) {
        this.myPropertiesFile = file;
        this.initBuild(false);
        IBuildEntry srcIncl = this.buildModel.getFactory().createEntry("src.includes");
        this.build.addWithoutNotify(srcIncl);
        IBuildEntry srcExcl = this.build.getEntry("src.excludes");
        if (srcExcl != null) {
            ((Build)this.build).removeWithoutNotify(srcExcl);
        }
        Iterator iter = sourceFolders.iterator();
        while (iter.hasNext()) {
            String entry;
            Object next = iter.next();
            if (next instanceof IResource) {
                entry = this.getNameFromResource((IResource)next);
            } else {
                IPath path = ((IPath)next).addTrailingSeparator();
                entry = path.toString();
            }
            this.addTokenToBuildEntry((BuildEntry)srcIncl, entry);
        }
        this.writeFile();
    }

    public List getFiles(boolean forceReadingFile) {
        if (forceReadingFile) {
            this.initBuild(true);
        } else {
            this.initBuild(false);
        }
        IBuildEntry srcIncl = this.build.getEntry("src.includes");
        IBuildEntry srcExcl = this.build.getEntry("src.excludes");
        IProject fProject = this.myPropertiesFile.getProject();
        List included = this.determineIncludedFiles(srcIncl, srcExcl, fProject);
        return included;
    }

    public void include(IResource res) {
        String name = res.getType() == 2 ? res.getProjectRelativePath().addTrailingSeparator().toString() : res.getProjectRelativePath().toString();
        name = this.handleResourceFolder(res, name);
        this.initBuild(false);
        IBuildEntry srcIncl = this.build.getEntry("src.includes");
        IBuildEntry srcExcl = this.build.getEntry("src.excludes");
        this.handleCheck(srcIncl, srcExcl, name, res);
        if (srcIncl != null) {
            this.build.addWithoutNotify(srcIncl);
        }
        if (srcExcl != null) {
            this.build.addWithoutNotify(srcExcl);
        }
        this.deleteEmptyEntries();
    }

    public void exclude(IResource res) throws CoreException {
        String name = res.getType() == 2 ? res.getProjectRelativePath().addTrailingSeparator().toString() : res.getProjectRelativePath().toString();
        name = this.handleResourceFolder(res, name);
        this.initBuild(false);
        IBuildEntry srcIncl = this.build.getEntry("src.includes");
        IBuildEntry srcExcl = this.build.getEntry("src.excludes");
        this.handleUncheck(srcIncl, srcExcl, name, res);
        if (srcIncl != null) {
            this.build.addWithoutNotify(srcIncl);
        }
        if (srcExcl != null) {
            this.build.addWithoutNotify(srcExcl);
        }
        this.deleteEmptyEntries();
    }

    private void initBuild(boolean forceInit) {
        if (this.build == null || forceInit) {
            BuildEditor be = new BuildEditor();
            AJDTEventTrace.buildConfigRead(this.myPropertiesFile);
            be.monitoredFileAdded(this.myPropertiesFile);
            IBaseModel ibm = be.getContextManager().findContext((IResource)this.myPropertiesFile).getModel();
            if (ibm instanceof BuildModel) {
                this.buildModel = (BuildModel)ibm;
                this.build = this.buildModel.getBuild();
            }
        }
    }

    private List allFiles(IContainer folder) {
        final ArrayList contents = new ArrayList();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource res) {
                    if (res.getType() == 1 && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(res.getName())) {
                        contents.add(res);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            AspectJUIPlugin.logException(e);
        }
        return contents;
    }

    private List determineIncludedFiles(IBuildEntry includes, IBuildEntry excludes, IProject fProject) {
        ArrayList<IFile> includedFiles = new ArrayList<IFile>();
        Vector<String> fileExt = new Vector<String>();
        String[] exclTokens = new String[]{};
        if (fProject == null || includes == null) {
            return includedFiles;
        }
        String[] inclTokens = includes.getTokens();
        if (excludes != null) {
            exclTokens = excludes.getTokens();
        }
        TreeSet<String> temp = new TreeSet<String>();
        int i = 0;
        while (i < inclTokens.length) {
            temp.add(inclTokens[i]);
            ++i;
        }
        i = 0;
        while (i < exclTokens.length) {
            temp.add(exclTokens[i]);
            ++i;
        }
        Iterator iter = temp.iterator();
        while (iter.hasNext()) {
            String resource = iter.next().toString();
            boolean isIncluded = includes.contains(resource);
            if (resource.lastIndexOf(47) == resource.length() - 1) {
                Object folder = resource.length() == 1 ? fProject : fProject.getFolder(resource);
                if (isIncluded) {
                    includedFiles.addAll(this.allFiles((IContainer)folder));
                    continue;
                }
                includedFiles.removeAll(this.allFiles((IContainer)folder));
                continue;
            }
            if (resource.startsWith("*.")) {
                if (!isIncluded) continue;
                fileExt.add(resource.substring(2));
                continue;
            }
            IFile file = fProject.getFile(resource);
            if (isIncluded && ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(file.getName())) {
                includedFiles.add(file);
                continue;
            }
            includedFiles.remove(file);
        }
        if (fileExt.size() == 0) {
            return includedFiles;
        }
        return includedFiles;
    }

    public void writeFile() {
        block7: {
            AJDTEventTrace.buildConfigWrite(this.myPropertiesFile);
            IBuildEntry[] entries = this.build.getBuildEntries();
            StringBuffer buff = new StringBuffer();
            int i = 0;
            while (i < entries.length) {
                if (entries[i] instanceof BuildEntry) {
                    String s = ((BuildEntry)entries[i]).write();
                    buff.append(s);
                }
                ++i;
            }
            if (!this.myPropertiesFile.getWorkspace().isTreeLocked()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buff.toString().getBytes());
                try {
                    if (!this.myPropertiesFile.exists()) {
                        this.myPropertiesFile.create((InputStream)inputStream, false, null);
                        break block7;
                    }
                    this.myPropertiesFile.setContents((InputStream)inputStream, false, true, null);
                }
                catch (CoreException e) {
                    AspectJUIPlugin.logException(e);
                }
            } else {
                AspectJUIPlugin.logException(new Exception("BuildProperties: resource tree locked"));
            }
        }
    }

    private void addTokenToBuildEntry(BuildEntry entry, String token) {
        if (!entry.contains(token)) {
            entry.addTokenWithoutNotify(token);
        }
    }

    private boolean contains(Object[] array, Object o) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getNameFromResource(IResource res) {
        IPath p = res.getProjectRelativePath();
        if (res.getType() == 2 || res.getType() == 4) {
            p = p.addTrailingSeparator();
        }
        return p.toString();
    }

    private boolean isIncluded(IResource res, IBuildEntry includes, IBuildEntry excludes) {
        if (res.getParent() == null) {
            return false;
        }
        String name = this.getNameFromResource(res);
        if (includes != null && this.contains(includes.getTokens(), name)) {
            return true;
        }
        if (excludes != null && this.contains(excludes.getTokens(), name)) {
            return false;
        }
        return this.isIncluded((IResource)res.getParent(), includes, excludes);
    }

    protected String handleResourceFolder(IResource resource, String resourceName) {
        if (resource instanceof IFolder) {
            this.deleteFolderChildrenFromEntries((IFolder)resource);
            return this.getResourceFolderName(resourceName);
        }
        return resourceName;
    }

    protected void deleteFolderChildrenFromEntries(IFolder folder) {
        IBuild build = this.buildModel.getBuild();
        IBuildEntry srcIncl = build.getEntry("src.includes");
        IBuildEntry srcExcl = build.getEntry("src.excludes");
        String parentFolder = this.getResourceFolderName(folder.getProjectRelativePath().toString());
        this.removeChildren(srcIncl, parentFolder);
        this.removeChildren(srcExcl, parentFolder);
    }

    protected String getResourceFolderName(String resourceName) {
        return resourceName;
    }

    protected void removeChildren(IBuildEntry entry, String parentFolder) {
        if (entry != null) {
            String[] tokens = entry.getTokens();
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].indexOf(47) != -1 && tokens[i].startsWith(parentFolder) && !tokens[i].equals(parentFolder)) {
                    ((BuildEntry)entry).removeTokenWithoutNotify(tokens[i]);
                }
                ++i;
            }
        }
    }

    protected void handleCheck(IBuildEntry includes, IBuildEntry excludes, String resourceName, IResource resource) {
        if (includes == null) {
            includes = this.buildModel.getFactory().createEntry("src.includes");
            IBuild build = this.buildModel.getBuild();
            build.addWithoutNotify(includes);
        }
        if (excludes != null && excludes.contains(resourceName)) {
            excludes.removeTokenWithoutNotify(resourceName);
        }
        if (!this.isIncluded(resource, includes, excludes)) {
            includes.addTokenWithoutNotify(resourceName);
        }
    }

    protected void handleUncheck(IBuildEntry includes, IBuildEntry excludes, String resourceName, IResource resource) throws CoreException {
        if (this.isIncluded((IResource)resource.getParent(), includes, excludes)) {
            if (excludes == null) {
                excludes = this.buildModel.getFactory().createEntry("src.excludes");
                IBuild build = this.buildModel.getBuild();
                build.addWithoutNotify(excludes);
            }
            if (!(excludes.contains(resourceName) || includes != null && includes.contains(resourceName))) {
                excludes.addTokenWithoutNotify(resourceName);
            }
        }
        if (includes != null) {
            if (includes.contains(resourceName)) {
                ((BuildEntry)includes).removeTokenWithoutNotify(resourceName);
            }
            if (includes.contains("*." + resource.getFileExtension())) {
                IResource[] members = this.myPropertiesFile.getProject().members();
                int i = 0;
                while (i < members.length) {
                    if (!(members[i] instanceof IFolder) && !members[i].getName().equals(resource.getName()) && resource.getFileExtension().equals(members[i].getFileExtension())) {
                        includes.addTokenWithoutNotify(members[i].getName());
                    }
                    ++i;
                }
                includes.removeTokenWithoutNotify("*." + resource.getFileExtension());
            }
        }
    }

    protected void deleteEmptyEntries() {
        IBuild build = this.buildModel.getBuild();
        IBuildEntry[] entries = new IBuildEntry[]{build.getEntry("src.excludes"), build.getEntry("src.includes")};
        int i = 0;
        while (i < entries.length) {
            if (entries[i] != null && entries[i].getTokens().length == 0) {
                ((Build)build).removeWithoutNotify(entries[i]);
            }
            ++i;
        }
    }

    public void updateSourceFolders(List sourcePathes) {
        boolean changed = false;
        this.initBuild(false);
        IBuildEntry srcIncl = this.build.getEntry("src.includes");
        if (srcIncl != null) {
            changed |= this.removeOldSourceFolders(sourcePathes, srcIncl);
        } else {
            srcIncl = this.buildModel.getFactory().createEntry("src.includes");
            this.build.addWithoutNotify(srcIncl);
        }
        IBuildEntry srcExcl = this.build.getEntry("src.excludes");
        if (srcExcl != null) {
            changed |= this.removeOldSourceFolders(sourcePathes, srcExcl);
        }
        if (changed |= this.addNewSourceFolders(sourcePathes, srcIncl)) {
            this.writeFile();
        }
    }

    private boolean removeOldSourceFolders(List sourcePathes, IBuildEntry srcIncl) {
        boolean changed = false;
        String[] entries = srcIncl.getTokens();
        int i = 0;
        while (i < entries.length) {
            Iterator iter = sourcePathes.iterator();
            boolean toBeRemoved = true;
            while (iter.hasNext()) {
                IPath p = (IPath)iter.next();
                if (!p.isPrefixOf((IPath)new Path(entries[i]))) continue;
                toBeRemoved = false;
                break;
            }
            if (toBeRemoved) {
                srcIncl.removeTokenWithoutNotify(entries[i]);
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    private boolean addNewSourceFolders(List sourcePathes, IBuildEntry srcIncl) {
        boolean changed = false;
        String[] entries = srcIncl.getTokens();
        Iterator iter = sourcePathes.iterator();
        while (iter.hasNext()) {
            boolean isNewSrcPath = true;
            IPath path = (IPath)iter.next();
            int i = 0;
            while (i < entries.length) {
                if (path.isPrefixOf((IPath)new Path(entries[i]))) {
                    isNewSrcPath = false;
                    break;
                }
                ++i;
            }
            if (!isNewSrcPath) continue;
            srcIncl.addTokenWithoutNotify(path.addTrailingSeparator().toString());
            changed = true;
        }
        return changed;
    }
}

