/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathGroup;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathMessages;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;

public class AJClasspathModel
extends ClasspathModel {
    public static final int ASPECTPATH = 2;
    private ClasspathGroup bootstrapEntries;
    private ClasspathGroup userEntries;
    private ClasspathGroup aspectPathEntries;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AJClasspathModel() {
        this.getBootstrapEntry();
        this.getUserEntry();
        this.getAspectPathEntry();
    }

    public Object addEntry(int entryType, IRuntimeClasspathEntry entry) {
        IClasspathEntry entryParent = null;
        switch (entryType) {
            case 0: {
                entryParent = this.getBootstrapEntry();
                break;
            }
            case 1: {
                entryParent = this.getUserEntry();
                break;
            }
            case 2: {
                entryParent = this.getAspectPathEntry();
            }
        }
        ClasspathEntry newEntry = this.createEntry(entry, entryParent);
        Iterator entries = this.childEntries.iterator();
        while (entries.hasNext()) {
            Object element = entries.next();
            if (!(element instanceof ClasspathGroup ? ((ClasspathGroup)element).contains((IClasspathEntry)newEntry) : element.equals(newEntry))) continue;
            return null;
        }
        if (entryParent != null) {
            this.addEntryToClasspathGroup((ClasspathGroup)entryParent, (IClasspathEntry)newEntry);
        } else {
            this.childEntries.add(newEntry);
        }
        return newEntry;
    }

    public void removeAll() {
        if (this.bootstrapEntries != null) {
            this.bootstrapEntries.removeAll();
        }
        if (this.userEntries != null) {
            this.userEntries.removeAll();
        }
        if (this.aspectPathEntries != null) {
            this.aspectPathEntries.removeAll();
        }
    }

    public void setBootstrapEntries(IRuntimeClasspathEntry[] entries) {
        if (this.bootstrapEntries == null) {
            this.getBootstrapEntry();
        }
        this.bootstrapEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.addEntryToClasspathGroup(this.bootstrapEntries, (IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)this.bootstrapEntries));
            ++i;
        }
    }

    public void setUserEntries(IRuntimeClasspathEntry[] entries) {
        if (this.userEntries == null) {
            this.getUserEntry();
        }
        this.userEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.addEntryToClasspathGroup(this.userEntries, (IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)this.userEntries));
            ++i;
        }
    }

    public void setAspectPathEntries(IRuntimeClasspathEntry[] entries) {
        if (this.aspectPathEntries == null) {
            this.getAspectPathEntry();
        }
        this.aspectPathEntries.removeAll();
        int i = 0;
        while (i < entries.length) {
            this.addEntryToClasspathGroup(this.aspectPathEntries, (IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)this.aspectPathEntries));
            ++i;
        }
    }

    private IClasspathEntry getAspectPathEntry() {
        if (this.aspectPathEntries == null) {
            String name = AspectJUIPlugin.getResourceString("Launcher.aspectPath");
            this.aspectPathEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.aspectPathEntries;
    }

    public IClasspathEntry getBootstrapEntry() {
        if (this.bootstrapEntries == null) {
            String name = ClasspathMessages.getString((String)"ClasspathModel.0");
            this.bootstrapEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.bootstrapEntries;
    }

    public IClasspathEntry getUserEntry() {
        if (this.userEntries == null) {
            String name = ClasspathMessages.getString((String)"ClasspathModel.1");
            this.userEntries = this.createGroupEntry(new IRuntimeClasspathEntry[0], null, name, false, true);
        }
        return this.userEntries;
    }

    private ClasspathGroup createGroupEntry(IRuntimeClasspathEntry[] entries, ClasspathGroup entryParent, String name, boolean canBeRemoved, boolean addEntry) {
        ClasspathGroup group = new ClasspathGroup(name, (IClasspathEntry)entryParent, canBeRemoved);
        int i = 0;
        while (i < entries.length) {
            this.addEntryToClasspathGroup(group, (IClasspathEntry)new ClasspathEntry(entries[i], (IClasspathEntry)group));
            ++i;
        }
        if (addEntry) {
            this.addEntry(group);
        }
        return group;
    }

    public IClasspathEntry[] getEntries(int entryType) {
        switch (entryType) {
            case 0: {
                if (this.bootstrapEntries == null) break;
                return this.bootstrapEntries.getEntries();
            }
            case 1: {
                if (this.userEntries == null) break;
                return this.userEntries.getEntries();
            }
            case 2: {
                if (this.aspectPathEntries == null) break;
                return this.aspectPathEntries.getEntries();
            }
        }
        return new IClasspathEntry[0];
    }

    private void addEntryToClasspathGroup(ClasspathGroup group, IClasspathEntry entry) {
        Class<?> clazz = group.getClass();
        try {
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Method m = clazz.getMethod("addEntry", classArray);
                m.invoke((Object)group, entry);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Class[] classArray = new Class[2];
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$0 = Class.forName("org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz3;
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz4;
                Method m = clazz.getMethod("addEntry", classArray);
                Object[] objectArray = new Object[2];
                objectArray[0] = entry;
                m.invoke((Object)group, objectArray);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }
}

