/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.util.HashMap;
import java.util.Map;
import org.aspectj.ajde.ui.AbstractIcon;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class AJMainTypeSelectionDialog
extends TwoPaneElementSelector {
    private Object[] types;
    private static Map imgDescriptorsToImages = new HashMap();

    public AJMainTypeSelectionDialog(Shell shell, Object[] types) {
        super(shell, (ILabelProvider)new AJElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        this.types = types;
        this.setMessage(LauncherMessages.getString((String)"MainTypeSelectionDialog.Choose_a_type"));
        this.setUpperListLabel(LauncherMessages.getString((String)"MainTypeSelectionDialog.Matching_types"));
        this.setLowerListLabel(LauncherMessages.getString((String)"MainTypeSelectionDialog.Qualifier"));
    }

    public Object[] getTypes() {
        return this.types;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public int open() {
        if (this.types == null) {
            return 1;
        }
        this.setElements(this.types);
        return super.open();
    }

    public Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            if (element instanceof IType) {
                return super.getImage((Object)((IType)element).getPackageFragment());
            }
            AJDTIcon icon = (AJDTIcon)AspectJImages.registry().getIcon(IProgramElement.Kind.PACKAGE);
            return icon.getImageDescriptor().createImage();
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof IType) {
                text = super.getText((Object)((IType)element).getPackageFragment());
            } else if (element instanceof Object[]) {
                Object[] elements = (Object[])element;
                text = ((IProgramElement)elements[0]).getPackageName();
                text = String.valueOf(text) + " - " + ((IProject)elements[1]).getName();
            }
            return text;
        }
    }

    private static class AJElementLabelProvider
    extends JavaElementLabelProvider {
        public AJElementLabelProvider(int i) {
            super(i);
        }

        public Image getImage(Object element) {
            Image result = super.getImage(element);
            if (result == null && element instanceof Object[]) {
                Object[] elements = (Object[])element;
                IProgramElement aspectElement = (IProgramElement)elements[0];
                AbstractIcon icon = AspectJImages.registry().getStructureIcon(aspectElement.getKind(), aspectElement.getAccessibility());
                if (icon instanceof AJDTIcon) {
                    ImageDescriptor desc = ((AJDTIcon)icon).getImageDescriptor();
                    ImageDescriptor decorated = AJDTUtils.decorate(desc, aspectElement);
                    if (imgDescriptorsToImages.get(decorated) instanceof Image) {
                        result = (Image)imgDescriptorsToImages.get(decorated);
                    } else {
                        result = decorated.createImage();
                        imgDescriptorsToImages.put(decorated, result);
                    }
                }
            }
            return result;
        }

        public String getText(Object element) {
            String text = super.getText(element);
            if ((text == null || text.trim().equals("")) && element instanceof Object[]) {
                text = ((IProgramElement)((Object[])element)[0]).getName();
            }
            return text;
        }
    }
}

