/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.launching.AJClasspathModel;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class LaunchConfigurationClasspathUtils {
    public static IRuntimeClasspathEntry[] getCurrentClasspath(AJClasspathModel fModel) {
        IRuntimeClasspathEntry entry;
        IClasspathEntry[] boot = fModel.getEntries(0);
        IClasspathEntry[] user = fModel.getEntries(1);
        IClasspathEntry[] aspectPath = fModel.getEntries(2);
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(boot.length + user.length + aspectPath.length);
        int i = 0;
        while (i < boot.length) {
            IClasspathEntry bootEntry = boot[i];
            entry = null;
            if (bootEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)bootEntry).getDelegate();
            } else if (bootEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)boot[i];
            }
            if (entry != null) {
                if (entry.getClasspathProperty() == 3) {
                    entry.setClasspathProperty(2);
                }
                entries.add(entry);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < user.length) {
            IClasspathEntry userEntry = user[i2];
            entry = null;
            if (userEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)userEntry).getDelegate();
            } else if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i2];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < aspectPath.length) {
            IClasspathEntry aspectEntry = aspectPath[i3];
            entry = null;
            if (aspectEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)aspectEntry).getDelegate();
            } else if (aspectEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)aspectPath[i3];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i3;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    public static AJClasspathModel createClasspathModel(ILaunchConfiguration configuration) throws CoreException {
        AJClasspathModel fModel = new AJClasspathModel();
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        IRuntimeClasspathEntry[] aspectEntries = null;
        if (projectName != null && !projectName.trim().equals("")) {
            IProject project = AspectJUIPlugin.getWorkspace().getRoot().getProject(projectName);
            aspectEntries = LaunchConfigurationClasspathUtils.getAspectpath(project);
        }
        if (aspectEntries != null) {
            int i = 0;
            while (i < aspectEntries.length) {
                fModel.addEntry(2, aspectEntries[i]);
                ++i;
            }
        } else {
            aspectEntries = new IRuntimeClasspathEntry[]{};
        }
        boolean[] allAspectEntriesOnClasspath = new boolean[aspectEntries.length];
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    boolean isAspectPathEntry = false;
                    int j = 0;
                    while (j < aspectEntries.length) {
                        if (aspectEntries[j].equals(entry)) {
                            isAspectPathEntry = true;
                            allAspectEntriesOnClasspath[j] = true;
                            break;
                        }
                        ++j;
                    }
                    if (isAspectPathEntry) break;
                    fModel.addEntry(1, entry);
                    break;
                }
                default: {
                    fModel.addEntry(0, entry);
                }
            }
            ++i;
        }
        return fModel;
    }

    public static IRuntimeClasspathEntry[] getAspectpath(IProject project) throws CoreException {
        ArrayList<RuntimeClasspathEntry> result = new ArrayList<RuntimeClasspathEntry>();
        String paths = project.getPersistentProperty(BuildOptionsAdapter.ASPECTPATH);
        String cKinds = project.getPersistentProperty(BuildOptionsAdapter.ASPECTPATH_CON_KINDS);
        String eKinds = project.getPersistentProperty(BuildOptionsAdapter.ASPECTPATH_ENT_KINDS);
        if (paths != null && paths.length() > 0 && cKinds != null && cKinds.length() > 0 && eKinds != null && eKinds.length() > 0) {
            StringTokenizer sTokPaths = new StringTokenizer(paths, File.pathSeparator);
            StringTokenizer sTokCKinds = new StringTokenizer(cKinds, File.pathSeparator);
            StringTokenizer sTokEKinds = new StringTokenizer(eKinds, File.pathSeparator);
            if (sTokPaths.countTokens() == sTokCKinds.countTokens() && sTokPaths.countTokens() == sTokEKinds.countTokens()) {
                while (sTokPaths.hasMoreTokens()) {
                    org.eclipse.jdt.internal.core.ClasspathEntry entry = new org.eclipse.jdt.internal.core.ClasspathEntry(Integer.parseInt(sTokCKinds.nextToken()), Integer.parseInt(sTokEKinds.nextToken()), (IPath)new Path(sTokPaths.nextToken()), new IPath[0], new IPath[0], null, null, null, false);
                    result.add(new RuntimeClasspathEntry((org.eclipse.jdt.core.IClasspathEntry)entry));
                }
            }
        }
        if (result.size() > 0) {
            return result.toArray(new IRuntimeClasspathEntry[0]);
        }
        return null;
    }

    public static boolean isDefaultClasspath(IRuntimeClasspathEntry[] classpath, ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
            if (classpath.length == entries.length) {
                int i = 0;
                while (i < entries.length) {
                    IRuntimeClasspathEntry entry = entries[i];
                    if (!entry.equals(classpath[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void addAspectPathToClasspath(ILaunchConfiguration configuration) {
        block6: {
            try {
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                AJClasspathModel model = LaunchConfigurationClasspathUtils.createClasspathModel(configuration);
                IRuntimeClasspathEntry[] classpath = LaunchConfigurationClasspathUtils.getCurrentClasspath(model);
                boolean def = LaunchConfigurationClasspathUtils.isDefaultClasspath(classpath, (ILaunchConfiguration)wc);
                if (def) {
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
                    break block6;
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException e) {
                    AJDTEventTrace.generalEvent(e.getMessage());
                }
                wc.doSave();
            }
            catch (CoreException e1) {
                AJDTEventTrace.generalEvent(e1.getMessage());
            }
        }
    }
}

