/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class LaunchConfigurationManagementUtils {
    public static void updateAspectPaths(IJavaProject project, List existingAspectPathEntries, List newAspectPathEntries) {
        try {
            String projectName = project.getElementName();
            List configs = LaunchConfigurationManagementUtils.getLaunchConfigsForProject(projectName);
            Iterator iter = configs.iterator();
            while (iter.hasNext()) {
                ILaunchConfiguration configuration = (ILaunchConfiguration)iter.next();
                IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
                ArrayList<IRuntimeClasspathEntry> entriesAsList = new ArrayList<IRuntimeClasspathEntry>(Arrays.asList(entries));
                Iterator iterator = existingAspectPathEntries.iterator();
                block3: while (iterator.hasNext()) {
                    IClasspathEntry entryToRemove = ((CPListElement)iterator.next()).getClasspathEntry();
                    Iterator iterator2 = entriesAsList.iterator();
                    while (iterator2.hasNext()) {
                        IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator2.next();
                        if (entry.getClasspathProperty() != 3 || !entryToRemove.equals(entry.getClasspathEntry())) continue;
                        iterator2.remove();
                        continue block3;
                    }
                }
                iterator = newAspectPathEntries.iterator();
                while (iterator.hasNext()) {
                    IClasspathEntry newEntry = ((CPListElement)iterator.next()).getClasspathEntry();
                    entriesAsList.add((IRuntimeClasspathEntry)new RuntimeClasspathEntry(newEntry));
                }
                IRuntimeClasspathEntry[] updatedEntries = entriesAsList.toArray(new IRuntimeClasspathEntry[0]);
                LaunchConfigurationManagementUtils.updateConfigurationClasspath(configuration, updatedEntries);
            }
        }
        catch (CoreException cEx) {
            AJDTEventTrace.generalEvent(cEx.getMessage());
        }
    }

    private static void updateConfigurationClasspath(ILaunchConfiguration configuration, IRuntimeClasspathEntry[] classpath) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            try {
                ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                int i = 0;
                while (i < classpath.length) {
                    IRuntimeClasspathEntry entry = classpath[i];
                    mementos.add(entry.getMemento());
                    ++i;
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
            }
            catch (CoreException e) {
                AJDTEventTrace.generalEvent(e.getMessage());
            }
            wc.doSave();
        }
        catch (CoreException e1) {
            AJDTEventTrace.generalEvent(e1.getMessage());
        }
    }

    private static List getLaunchConfigsForProject(String projectName) {
        ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException cEx) {
            AJDTEventTrace.generalEvent(cEx.getMessage());
        }
        return candidateConfigs;
    }
}

