/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class AspectJProjectNature
implements IProjectNature {
    private IProject project;

    public void configure() throws CoreException {
        IProjectDescription projectDescription = this.project.getDescription();
        ICommand command = projectDescription.newCommand();
        command.setBuilderName("org.eclipse.ajdt.ui.ajbuilder");
        ICommand[] buildCommands = projectDescription.getBuildSpec();
        ICommand[] newBuildCommands = this.contains(buildCommands, "org.eclipse.jdt.core.javabuilder") ? this.swap(buildCommands, "org.eclipse.jdt.core.javabuilder", command) : this.insert(buildCommands, command);
        projectDescription.setBuildSpec(newBuildCommands);
        this.project.setDescription(projectDescription, null);
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        ICommand[] buildCommands = description.getBuildSpec();
        ICommand command = description.newCommand();
        command.setBuilderName("org.eclipse.jdt.core.javabuilder");
        ICommand[] newBuildCommands = this.contains(buildCommands, "org.eclipse.ajdt.ui.ajbuilder") ? this.swap(buildCommands, "org.eclipse.ajdt.ui.ajbuilder", command) : this.remove(buildCommands, "org.eclipse.ajdt.ui.ajbuilder");
        description.setBuildSpec(newBuildCommands);
        this.project.setDescription(description, null);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject value) {
        this.project = value;
    }

    private boolean contains(ICommand[] commands, String builderId) {
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    private ICommand[] swap(ICommand[] sourceCommands, String oldBuilderId, ICommand newCommand) {
        ICommand[] newCommands = new ICommand[sourceCommands.length];
        int i = 0;
        while (i < sourceCommands.length) {
            newCommands[i] = sourceCommands[i].getBuilderName().equals(oldBuilderId) ? newCommand : sourceCommands[i];
            ++i;
        }
        return newCommands;
    }

    private ICommand[] insert(ICommand[] sourceCommands, ICommand command) {
        ICommand[] newCommands = new ICommand[sourceCommands.length + 1];
        newCommands[0] = command;
        int i = 0;
        while (i < sourceCommands.length) {
            newCommands[i + 1] = sourceCommands[i];
            ++i;
        }
        return newCommands;
    }

    private ICommand[] remove(ICommand[] sourceCommands, String builderId) {
        ICommand[] newCommands = new ICommand[sourceCommands.length - 1];
        int newCommandIndex = 0;
        int i = 0;
        while (i < sourceCommands.length) {
            if (!sourceCommands[i].getBuilderName().equals(builderId)) {
                newCommands[newCommandIndex++] = sourceCommands[i];
            }
            ++i;
        }
        return newCommands;
    }
}

