/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.preferences.PreferencePageSupport;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PropertyPage;

public class CompilerPropertyPage
extends PropertyPage
implements SelectionListener {
    public final String COMPILER_PB_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public final String COMPILER_PB_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public final String COMPILER_PB_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public final String COMPILER_PB_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public final String COMPILER_PB_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public final String COMPILER_PB_UNMATCHED_SUPERTYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public final String COMPILER_PB_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public final String COMPILER_PB_NEED_SERIAL_VERSION_UID = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public final String COMPILER_PB_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public final String COMPILER_PB_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public final String COMPILER_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public final String COMPILER_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public final String COMPILER_LAZY_TJP = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public final String COMPILER_NO_ADVICE_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public final String COMPILER_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public final String COMPILER_REWEAVABLE_COMPRESS = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private final String PREF_AJ_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    private final String PREF_AJ_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    private final String PREF_AJ_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    private final String PREF_AJ_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    private final String PREF_AJ_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    private final String PREF_AJ_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    private final String PREF_AJ_UNMATCHED_SUPER_TYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    private final String PREF_AJ_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    private final String PREF_AJ_NEED_SERIAL_VERSION_UID_FIELD = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    private final String PREF_AJ_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    private final String PREF_ENABLE_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    private final String PREF_ENABLE_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    private final String PREF_ENABLE_LAZY_TJP = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    private final String PREF_ENABLE_NO_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    private final String PREF_ENABLE_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    private final String PREF_ENABLE_REWEAVABLE_COMPRESS = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static String ENABLED = "enabled";
    private static String DISABLED = "disabled";
    private Button noweaveButton;
    private Button lazytjpButton;
    private Button noinlineButton;
    private Button reweaveButton;
    private Button reweaveCompressButton;
    private IProject thisProject;
    private boolean initialised = false;
    private int switches = 0;
    protected List fComboBoxes;
    protected List fCheckBoxes = new ArrayList();
    private SelectionButtonDialogField fUseWorkspaceSettings;
    private SelectionButtonDialogField fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private TabFolder folder;

    public CompilerPropertyPage() {
        this.fComboBoxes = new ArrayList();
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CompilerPropertyPage.this.doDialogFieldChanged(field);
            }
        };
        this.fUseWorkspaceSettings = new SelectionButtonDialogField(16);
        this.fUseWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.setLabelText(PreferencesMessages.getString((String)"CompilerPropertyPage.useworkspacesettings.label"));
        this.fChangeWorkspaceSettings = new SelectionButtonDialogField(8);
        this.fChangeWorkspaceSettings.setLabelText(PreferencesMessages.getString((String)"CompilerPropertyPage.useworkspacesettings.change"));
        this.fChangeWorkspaceSettings.setDialogFieldListener(listener);
        this.fUseWorkspaceSettings.attachDialogField((DialogField)this.fChangeWorkspaceSettings);
        this.fUseProjectSettings = new SelectionButtonDialogField(16);
        this.fUseProjectSettings.setDialogFieldListener(listener);
        this.fUseProjectSettings.setLabelText(PreferencesMessages.getString((String)"CompilerPropertyPage.useprojectsettings.label"));
    }

    public void initDefaults(IPreferenceStore store) {
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", WARNING);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", IGNORE);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", WARNING);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", IGNORE);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", WARNING);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", WARNING);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", WARNING);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", IGNORE);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", IGNORE);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", WARNING);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.NoWeave", false);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects", false);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint", false);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XNoInline", false);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XReweavable", false);
        store.setDefault(this.thisProject + "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress", false);
        store.setDefault(this.thisProject + "useProjectSettings", false);
        this.initialised = true;
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        this.thisProject = (IProject)this.getElement();
        if (!this.initialised) {
            this.initDefaults(this.getPreferenceStore());
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fUseWorkspaceSettings.doFillIntoGrid(composite, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.fUseWorkspaceSettings.getSelectionButton(null));
        this.fChangeWorkspaceSettings.doFillIntoGrid(composite, 1);
        this.fUseProjectSettings.doFillIntoGrid(composite, 2);
        GridData data = new GridData(272);
        data.horizontalSpan = 2;
        this.folder = new TabFolder(parent, 0);
        this.folder.setLayout((Layout)new TabFolderLayout());
        this.folder.setLayoutData((Object)data);
        Composite aspectjComposite = this.createMessagesTabContent((Composite)this.folder);
        TabItem item = new TabItem(this.folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.tabtitle"));
        item.setControl((Control)aspectjComposite);
        aspectjComposite = this.createAdvancedTabContent((Composite)this.folder);
        item = new TabItem(this.folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.tabtitle"));
        item.setControl((Control)aspectjComposite);
        Dialog.applyDialogFont((Control)composite);
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean(this.thisProject + "useProjectSettings")) {
            this.fUseProjectSettings.setSelection(true);
        } else {
            this.fUseWorkspaceSettings.setSelection(true);
        }
        this.updateEnableState();
        return composite;
    }

    private Composite createMessagesTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.error"), AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.warning"), AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.ignore")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_absolute_type_name.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_wildcard_type_name.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_unresolvable_member.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_type_not_exposed_to_weaver.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_shadow_not_in_structure.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_unmatched_super_type_in_call.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_cannot_implement_lazy_tjp.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_need_serial_version_uid_field.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_incompatible_serial_version.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_no_interface_ctor_joinpoint.label");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        return composite;
    }

    private Composite createAdvancedTabContent(Composite folder) {
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_no_weave.label");
        this.noweaveButton = this.addCheckBox(composite, label, "org.aspectj.ajdt.core.compiler.weaver.NoWeave", enableDisableValues, 0);
        this.noweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_serializable_aspects.label");
        this.addCheckBox(composite, label, "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects", enableDisableValues, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_lazy_tjp.label");
        this.lazytjpButton = this.addCheckBox(composite, label, "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint", enableDisableValues, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_no_inline.label");
        this.noinlineButton = this.addCheckBox(composite, label, "org.aspectj.ajdt.core.compiler.weaver.XNoInline", enableDisableValues, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_reweavable.label");
        this.reweaveButton = this.addCheckBox(composite, label, "org.aspectj.ajdt.core.compiler.weaver.XReweavable", enableDisableValues, 0);
        this.reweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_reweavable_compress.label");
        this.reweaveCompressButton = this.addCheckBox(composite, label, "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress", enableDisableValues, 0);
        this.reweaveCompressButton.addSelectionListener((SelectionListener)checkBoxListener);
        this.checkNoWeaveSelection();
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AspectJUIPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean lintChanges = false;
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            String value = data.getValue(curr.getSelectionIndex());
            if (!value.equals(store.getString(String.valueOf(this.thisProject.toString()) + data.getKey()))) {
                lintChanges = true;
                store.setValue(this.thisProject + data.getKey(), value);
            }
            --i;
        }
        boolean advancedChanges = false;
        int i2 = this.fCheckBoxes.size() - 1;
        while (i2 >= 0) {
            Button curr = (Button)this.fCheckBoxes.get(i2);
            ControlData data = (ControlData)curr.getData();
            boolean value = curr.getSelection();
            if (value != store.getBoolean(String.valueOf(this.thisProject.toString()) + data.getKey())) {
                advancedChanges = true;
                store.setValue(String.valueOf(this.thisProject.toString()) + data.getKey(), value);
            }
            --i2;
        }
        boolean projectWorkspaceChanges = false;
        if (store.getBoolean(this.thisProject + "useProjectSettings") != this.useProjectSettings()) {
            projectWorkspaceChanges = true;
            store.setValue(this.thisProject + "useProjectSettings", this.useProjectSettings());
        }
        AspectJUIPlugin.getDefault().savePluginPreferences();
        if (lintChanges || advancedChanges || projectWorkspaceChanges || this.switches > 1 && this.useProjectSettings()) {
            boolean doBuild = false;
            String[] strings = this.getProjectBuildDialogStrings();
            if (strings != null) {
                MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = dialog.open();
                if (res == 0) {
                    doBuild = true;
                } else if (res != 1) {
                    return false;
                }
            }
            if (doBuild) {
                this.doProjectBuild();
            }
        }
        return true;
    }

    protected String[] getProjectBuildDialogStrings() {
        String title = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.needsbuild.title");
        String message = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.needsprojectbuild.message");
        return new String[]{title, message};
    }

    protected void doProjectBuild() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask("", 2);
                    try {
                        try {
                            monitor.setTaskName(AspectJUIPlugin.getResourceString("OptionsConfigurationBlock.buildproject.taskname"));
                            CompilerPropertyPage.this.thisProject.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String message = AspectJUIPlugin.getResourceString("OptionsConfigurationBlock.builderror.message");
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(message, e);
        }
    }

    protected void performDefaults() {
        String defaultValue;
        ControlData data;
        Combo curr;
        super.performDefaults();
        this.fUseWorkspaceSettings.setSelection(true);
        this.fUseProjectSettings.setSelection(false);
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            curr = (Combo)this.fComboBoxes.get(i);
            data = (ControlData)curr.getData();
            defaultValue = this.getPreferenceStore().getDefaultString(data.getKey());
            curr.select(data.getSelection(defaultValue));
            --i;
        }
        i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            curr = (Button)this.fCheckBoxes.get(i);
            if (this.useProjectSettings()) {
                curr.setEnabled(true);
            }
            curr.setSelection((data = (ControlData)curr.getData()).getSelection(defaultValue = this.getPreferenceStore().getDefaultString(data.getKey())) == 1);
            --i;
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Button addCheckBox(Composite parent, String label, String key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        int idx = label.indexOf("-");
        String optionname = label.substring(0, idx);
        String optiondesc = label.substring(idx + 1);
        optiondesc = optiondesc.trim();
        GridData gd = new GridData(1040);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setText(optionname);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        Label l = new Label(parent, 64);
        l.setText(optiondesc);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        l.setLayoutData((Object)gridData);
        this.createLabel(parent, "");
        boolean currValue = this.getPreferenceStore().getBoolean(String.valueOf(this.thisProject.toString()) + key);
        checkBox.setSelection(currValue);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected void addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        Label placeHolder = new Label(parent, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        String currValue = this.getPreferenceStore().getString(String.valueOf(this.thisProject.toString()) + key);
        if (currValue != null && currValue.length() > 0) {
            comboBox.select(data.getSelection(currValue));
        }
        this.fComboBoxes.add(comboBox);
    }

    private void checkNoWeaveSelection() {
        boolean buttonSelected = this.noweaveButton.getSelection();
        if (buttonSelected) {
            this.lazytjpButton.setEnabled(!buttonSelected);
            this.noinlineButton.setEnabled(!buttonSelected);
            this.reweaveButton.setEnabled(!buttonSelected);
            this.reweaveCompressButton.setEnabled(!buttonSelected);
        }
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.widgetSelected(se);
    }

    public void widgetSelected(SelectionEvent se) {
    }

    private void doDialogFieldChanged(DialogField field) {
        if (field == this.fChangeWorkspaceSettings) {
            String id = "org.eclipse.ajdt.ui.preferences.AJCompilerPreferencePage";
            AJCompilerPreferencePage page = new AJCompilerPreferencePage();
            PreferencePageSupport.showPreferencePage((Shell)this.getShell(), (String)id, (IPreferencePage)page);
        } else {
            ++this.switches;
            this.updateEnableState();
        }
    }

    private void updateEnableState() {
        if (this.useProjectSettings()) {
            int i = 0;
            while (i < this.fComboBoxes.size()) {
                Combo box = (Combo)this.fComboBoxes.get(i);
                box.setEnabled(true);
                ++i;
            }
            i = 0;
            while (i < this.fCheckBoxes.size()) {
                Button checkBox = (Button)this.fCheckBoxes.get(i);
                checkBox.setEnabled(true);
                ++i;
            }
            boolean buttonSelected = this.noweaveButton.getSelection();
            if (buttonSelected) {
                this.lazytjpButton.setSelection(false);
                this.noinlineButton.setSelection(false);
                this.reweaveButton.setSelection(false);
                this.reweaveCompressButton.setSelection(false);
            }
            this.lazytjpButton.setEnabled(!buttonSelected);
            this.noinlineButton.setEnabled(!buttonSelected);
            this.reweaveButton.setEnabled(!buttonSelected);
            this.reweaveCompressButton.setEnabled(!buttonSelected);
        } else {
            int i = 0;
            while (i < this.fComboBoxes.size()) {
                Combo box = (Combo)this.fComboBoxes.get(i);
                box.setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < this.fCheckBoxes.size()) {
                Button checkBox = (Button)this.fCheckBoxes.get(i);
                checkBox.setEnabled(false);
                ++i;
            }
        }
    }

    private boolean useProjectSettings() {
        return this.fUseProjectSettings.isSelected();
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            int i = 0;
            while (i < this.fValues.length) {
                if (value.equals(this.fValues[i])) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
    }

    private class CheckBoxListener
    implements SelectionListener {
        CheckBoxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean buttonSelected;
            if (e.getSource().equals(CompilerPropertyPage.this.noweaveButton)) {
                boolean buttonSelected2 = CompilerPropertyPage.this.noweaveButton.getSelection();
                if (buttonSelected2) {
                    CompilerPropertyPage.this.lazytjpButton.setSelection(false);
                    CompilerPropertyPage.this.noinlineButton.setSelection(false);
                    CompilerPropertyPage.this.reweaveButton.setSelection(false);
                    CompilerPropertyPage.this.reweaveCompressButton.setSelection(false);
                }
                CompilerPropertyPage.this.lazytjpButton.setEnabled(!buttonSelected2);
                CompilerPropertyPage.this.noinlineButton.setEnabled(!buttonSelected2);
                CompilerPropertyPage.this.reweaveButton.setEnabled(!buttonSelected2);
                CompilerPropertyPage.this.reweaveCompressButton.setEnabled(!buttonSelected2);
            } else if (e.getSource().equals(CompilerPropertyPage.this.reweaveButton)) {
                boolean buttonSelected3 = CompilerPropertyPage.this.reweaveButton.getSelection();
                if (buttonSelected3) {
                    CompilerPropertyPage.this.reweaveCompressButton.setSelection(false);
                }
            } else if (e.getSource().equals(CompilerPropertyPage.this.reweaveCompressButton) && (buttonSelected = CompilerPropertyPage.this.reweaveCompressButton.getSelection())) {
                CompilerPropertyPage.this.reweaveButton.setSelection(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

