/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class BuildSelectorAction
implements IWorkbenchWindowActionDelegate {
    private IFile currentlySelectedBuildFile = null;

    public void run(IAction action) {
        IProject buildFileProject = this.currentlySelectedBuildFile.getProject();
        try {
            if (!buildFileProject.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return;
            }
        }
        catch (CoreException cEx) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Unable to verify project nature", cEx);
        }
        AspectJUIPlugin.setBuildConfigurationFile(buildFileProject, this.currentlySelectedBuildFile);
        AspectJUIPlugin.getDefault().setCurrentProject(buildFileProject);
        BuildSelectorAction.doFullBuild(buildFileProject);
    }

    public static void doFullBuild(final IProject project) {
        IWorkbenchWindow wbwin = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow();
        if (wbwin == null) {
            return;
        }
        Shell activeShell = wbwin.getShell();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            void doLocalBuild(int buildType, IProgressMonitor pm) throws CoreException {
                Builder.isLocalBuild = true;
                project.build(6, pm);
                Builder.isLocalBuild = false;
            }

            public void run(IProgressMonitor pm) {
                try {
                    this.doLocalBuild(6, pm);
                }
                catch (CoreException cEx) {
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Build on select error", cEx);
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, op);
        }
        catch (Exception e) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Auto build on select failed", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object first;
        if (selection instanceof IStructuredSelection && (first = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.currentlySelectedBuildFile = (IFile)first;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

