/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.ajdt.internal.codeconversion.AspectsConvertingParser;
import org.eclipse.ajdt.internal.codeconversion.ConversionOptions;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class AJFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                String content = document.get();
                AspectsConvertingParser pars = new AspectsConvertingParser(content.toCharArray());
                ArrayList changes = pars.convert(ConversionOptions.CONSTANT_SIZE);
                content = new String(pars.content);
                TextEdit edit = CodeFormatterUtil.format2((int)8, (String)content, (int)partition.getOffset(), (int)partition.getLength(), (int)0, (String)TextUtilities.getDefaultLineDelimiter((IDocument)document), (Map)this.getPreferences());
                if (edit != null) {
                    if (changes.size() > 0) {
                        TextEdit[] edits = edit.getChildren();
                        int i = 0;
                        while (i < edits.length) {
                            TextEdit edit2 = edits[i];
                            boolean conflict = AspectsConvertingParser.conflictsWithAJEdit((int)edit2.getOffset(), (ArrayList)changes);
                            if (conflict) {
                                edit.removeChild(edit2);
                            } else {
                                conflict = AspectsConvertingParser.conflictsWithAJEdit((int)edit2.getInclusiveEnd(), (ArrayList)changes);
                                if (conflict) {
                                    edit.removeChild(edit2);
                                }
                            }
                            ++i;
                        }
                    }
                    edit.apply(document);
                }
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log((Throwable)exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log((Throwable)exception);
            }
        }
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }
}

