/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AdviceActionDelegate
extends AbstractRulerActionDelegate {
    IEditorPart editor = null;
    IVerticalRulerInfo rulerInfo = null;
    static /* synthetic */ Class class$0;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        String id;
        if (!(targetEditor == null || (id = targetEditor.getSite().getId()).equals("org.eclipse.jdt.ui.CompilationUnitEditor") || id.equals("org.eclipse.jdt.ui.ClassFileEditor") || id.equals("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor"))) {
            targetEditor = null;
        }
        this.editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        try {
            IFileEditorInput ifep = (IFileEditorInput)this.editor.getEditorInput();
            IFile ifile = ifep.getFile();
            int linenumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
            IMarker[] markers = ifile.findMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
            MenuManager adviceSubmenu = null;
            boolean adviceSubmenuInitialized = false;
            if (markers != null && markers.length != 0) {
                Integer clickedLine = new Integer(linenumber + 1);
                int j = 0;
                while (j < markers.length) {
                    IMarker m = markers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String textLabel = (String)m.getAttribute("message");
                        AJDTMenuAction ama = new AJDTMenuAction(textLabel, m);
                        if (!adviceSubmenuInitialized) {
                            adviceSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.adviceInAffect"));
                            manager.add((IContributionItem)new Separator());
                            manager.add((IContributionItem)adviceSubmenu);
                            adviceSubmenuInitialized = true;
                        }
                        adviceSubmenu.add((IAction)ama);
                    }
                    ++j;
                }
            }
            IMarker[] decMarkers = ifile.findMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
            MenuManager declarationSubmenu = null;
            boolean declarationSubmenuInitialized = false;
            if (decMarkers != null && decMarkers.length != 0) {
                Integer clickedLine = new Integer(linenumber + 1);
                int j = 0;
                while (j < decMarkers.length) {
                    IMarker m = decMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String textLabel = (String)m.getAttribute("message");
                        AJDTMenuAction ama = new AJDTMenuAction(textLabel, m);
                        if (!declarationSubmenuInitialized) {
                            declarationSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.aspectDeclarations"));
                            if (!adviceSubmenuInitialized) {
                                manager.add((IContributionItem)new Separator());
                            }
                            manager.add((IContributionItem)declarationSubmenu);
                            declarationSubmenuInitialized = true;
                        }
                        declarationSubmenu.add((IAction)ama);
                    }
                    ++j;
                }
            }
            IMarker[] probMarkers = ifile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            MenuManager problemSubmenu = null;
            boolean problemSubmenuInitialized = false;
            if (probMarkers != null && probMarkers.length != 0) {
                Integer clickedLine = new Integer(linenumber + 1);
                int j = 0;
                while (j < probMarkers.length) {
                    IMarker m = probMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String loc;
                        int relCount = 0;
                        if ((loc = (String)m.getAttribute("relatedLocations-" + relCount++)) != null) {
                            while (loc != null) {
                                String[] s = loc.split(":::");
                                String resName = s[0].substring(s[0].lastIndexOf(File.separator) + 1);
                                String textLabel = AspectJUIPlugin.getFormattedResourceString("EditorRulerContextMenu.relatedLocation.message", new String[]{resName, s[1]});
                                RelatedLocationMenuAction ama = new RelatedLocationMenuAction(textLabel, loc);
                                if (!problemSubmenuInitialized) {
                                    problemSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.relatedLocations"));
                                    if (!adviceSubmenuInitialized && !declarationSubmenuInitialized) {
                                        manager.add((IContributionItem)new Separator());
                                    }
                                    manager.add((IContributionItem)problemSubmenu);
                                    problemSubmenuInitialized = true;
                                }
                                problemSubmenu.add((IAction)ama);
                                loc = (String)m.getAttribute("relatedLocations-" + relCount++);
                            }
                        }
                    }
                    ++j;
                }
            }
        }
        catch (CoreException ce) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception whilst extending ruler context menu with advice items", ce);
        }
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine fStatusLine;
                IEditorPart iEditorPart = AdviceActionDelegate.this.editor;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((fStatusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                    fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }

    abstract class BaseAJDTMenuAction
    extends Action {
        BaseAJDTMenuAction(String s) {
            super(s);
        }

        abstract String getJumpLocation();

        public void run() {
            block7: {
                try {
                    String[] s = this.getJumpLocation().split(":::");
                    String filepath = s[0];
                    String linenumber = s[1];
                    IResource ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath);
                    IMarker jumpMarker = null;
                    if (ir != null && ir.exists()) {
                        try {
                            jumpMarker = ir.createMarker("org.eclipse.core.resources.textmarker");
                            jumpMarker.setAttribute("lineNumber", new Integer(linenumber).intValue());
                        }
                        catch (CoreException ce) {
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Unable to build jump marker in AdviceMenuAction run method", ce);
                        }
                        try {
                            IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)jumpMarker, (boolean)true);
                        }
                        catch (Exception e) {
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception whilst asking editor to jump to advice location", e);
                        }
                        break block7;
                    }
                    AdviceActionDelegate.this.report("Could not find resource.");
                }
                catch (IndexOutOfBoundsException ioobe) {
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Problem parsing marker jump location (probably!)", ioobe);
                }
            }
        }
    }

    class RelatedLocationMenuAction
    extends BaseAJDTMenuAction {
        private String jumpLocation;

        RelatedLocationMenuAction(String s, String jumpLocation) {
            super(s);
            this.jumpLocation = jumpLocation;
            this.setImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.jcu_obj.gif"));
        }

        String getJumpLocation() {
            return this.jumpLocation;
        }
    }

    class AJDTMenuAction
    extends BaseAJDTMenuAction {
        IMarker adviceMarker;

        AJDTMenuAction(String s, IMarker marker) {
            super(s);
            String runtimeTest = AspectJUIPlugin.getResourceString("AspectJEditor.runtimetest");
            boolean hasRuntimeTest = false;
            if (s.endsWith(runtimeTest)) {
                hasRuntimeTest = true;
            }
            if (s.indexOf(".before(") != -1) {
                if (hasRuntimeTest) {
                    this.setImageDescriptor(AspectJImages.DYNAMIC_BEFORE_ADVICE.getImageDescriptor());
                } else {
                    this.setImageDescriptor(AspectJImages.BEFORE_ADVICE.getImageDescriptor());
                }
            } else if (s.indexOf(".after(") != -1 || s.indexOf(".afterReturning(") != -1 || s.indexOf(".afterThrowing(") != -1) {
                if (hasRuntimeTest) {
                    this.setImageDescriptor(AspectJImages.DYNAMIC_AFTER_ADVICE.getImageDescriptor());
                } else {
                    this.setImageDescriptor(AspectJImages.AFTER_ADVICE.getImageDescriptor());
                }
            } else if (s.indexOf(".around(") != -1) {
                if (hasRuntimeTest) {
                    this.setImageDescriptor(AspectJImages.DYNAMIC_AROUND_ADVICE.getImageDescriptor());
                } else {
                    this.setImageDescriptor(AspectJImages.AROUND_ADVICE.getImageDescriptor());
                }
            } else {
                this.setImageDescriptor(AspectJImages.ITD.getImageDescriptor());
            }
            this.adviceMarker = marker;
        }

        String getJumpLocation() {
            try {
                return (String)this.adviceMarker.getAttribute("sourceLocationOfAdvice");
            }
            catch (CoreException ce) {
                AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception whilst executing AdviceMenuAction run method", ce);
                return null;
            }
        }
    }
}

