/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionDelegateHelper;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AspectJBreakpointRulerAction
extends Action {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private IEditorStatusLine fStatusLine;
    static /* synthetic */ Class class$0;

    public AspectJBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor, IEditorPart editorPart) {
        super(ActionMessages.getString((String)"ManageBreakpointRulerAction.label"));
        this.fRuler = ruler;
        this.fTextEditor = editor;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fStatusLine = (IEditorStatusLine)editorPart.getAdapter((Class)clazz);
    }

    public void dispose() {
        this.fTextEditor = null;
        this.fRuler = null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    boolean containsAspect(IProgramElement elem) {
        if (elem.getKind().equals(IProgramElement.Kind.ASPECT)) {
            return true;
        }
        List children = elem.getChildren();
        if (children != null && children.size() > 0) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                if (!this.containsAspect((IProgramElement)iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    boolean isInAspect(IProgramElement elem) {
        if (elem.getKind().equals(IProgramElement.Kind.ASPECT)) {
            return true;
        }
        IProgramElement parent = elem.getParent();
        if (parent != null) {
            return this.isInAspect(parent);
        }
        return false;
    }

    boolean isBreakpointable(IProgramElement elem) {
        return elem.getKind().equals(IProgramElement.Kind.ADVICE) || elem.getKind().equals(IProgramElement.Kind.METHOD) || elem.getKind().equals(IProgramElement.Kind.CODE) || elem.getKind().equals(IProgramElement.Kind.CONSTRUCTOR) || elem.getKind().equals(IProgramElement.Kind.INITIALIZER) || elem.getKind().equals(IProgramElement.Kind.INTER_TYPE_CONSTRUCTOR) || elem.getKind().equals(IProgramElement.Kind.INTER_TYPE_METHOD) || elem.getKind().equals(IProgramElement.Kind.INTER_TYPE_FIELD) || elem.getKind().equals(IProgramElement.Kind.FIELD);
    }

    public String getQualifiedMainClassName(IProgramElement elem) {
        String packName = elem.getPackageName();
        IProgramElement parent = elem.getParent();
        while (parent.getKind() != IProgramElement.Kind.PACKAGE && parent.getKind() != IProgramElement.Kind.FILE_LST) {
            elem = parent;
            parent = parent.getParent();
        }
        String className = elem.getName();
        className = className.substring(0, className.lastIndexOf(46));
        if ("".equals(packName)) {
            return className;
        }
        return String.valueOf(packName) + "." + className;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block8: {
            try {
                block9: {
                    block10: {
                        list = this.getMarkers();
                        if (!list.isEmpty()) break block9;
                        lineNumber = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity() + 1;
                        if (lineNumber >= this.getDocument().getNumberOfLines()) {
                            return;
                        }
                        res = this.getResource();
                        hierarchy = Ajde.getDefault().getStructureModelManager().getHierarchy();
                        elem = hierarchy.findElementForSourceLine(res.getLocation().toOSString(), lineNumber);
                        if (elem.getParent() != null) ** GOTO lbl19
                        pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(res.getProject());
                        if (pbc != null && (bc = pbc.getActiveBuildConfiguration()) != null && !bc.isIncluded(res)) {
                            this.report(AspectJUIPlugin.getResourceString("breakpoint.fileExcluded"));
                            return;
                        }
                        javaElem = JavaCore.create((IResource)res.getParent());
                        qualifiedName = javaElem instanceof IPackageFragment ? String.valueOf(javaElem.getElementName()) + '.' : "";
                        break block10;
lbl-1000:
                        // 1 sources

                        {
                            elem = hierarchy.findElementForSourceLine(res.getLocation().toOSString(), ++lineNumber);
lbl19:
                            // 2 sources

                            ** while (!this.isBreakpointable((IProgramElement)elem) && lineNumber < this.getDocument().getNumberOfLines())
                        }
lbl20:
                        // 1 sources

                        signature = elem.getBytecodeName();
                        if (signature != null && !signature.equals((elemBefore = hierarchy.findElementForSourceLine(res.getLocation().toOSString(), lineNumber - 1)).getBytecodeName()) && lineNumber < this.getDocument().getNumberOfLines() && signature.equals((elemBefore = hierarchy.findElementForSourceLine(res.getLocation().toOSString(), lineNumber + 1)).getBytecodeName())) {
                            ++lineNumber;
                        }
                        if (!"".equals(qualifiedName = elem.getPackageName())) {
                            qualifiedName = String.valueOf(qualifiedName) + '.';
                        }
                    }
                    qualifiedName = String.valueOf(qualifiedName) + res.getName().substring(0, res.getName().lastIndexOf(46));
                    AJDTEventTrace.generalEvent("creating breakpoint in " + qualifiedName);
                    JDIDebugModel.createLineBreakpoint((IResource)this.getResource(), (String)qualifiedName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, new HashMap<K, V>(10));
                    break block8;
                }
                manager = DebugPlugin.getDefault().getBreakpointManager();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    marker = (IMarker)iterator.next();
                    breakpoint = manager.getBreakpoint(marker);
                    if (breakpoint == null) continue;
                    breakpoint.delete();
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.errorDialog((String)ActionMessages.getString((String)"ManageBreakpointRulerAction.error.adding.message1"), (Throwable)e);
            }
        }
    }

    protected IType getType(ITextSelection selection) {
        IMember member = ActionDelegateHelper.getDefault().getCurrentMember(selection);
        IType type = null;
        if (member instanceof IType) {
            type = (IType)member;
        } else if (member != null) {
            type = member.getDeclaringType();
        }
        try {
            while (type != null && !type.isBinary() && type.isLocal()) {
                type = type.getDeclaringType();
            }
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log((Throwable)e);
        }
        return type;
    }

    protected IResource getResource() {
        IFile resource = null;
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)editorInput).getFile();
        }
        return resource;
    }

    protected List getMarkers() {
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            try {
                IMarker[] markers = null;
                if (resource instanceof IFile) {
                    markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    markers = root.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (markers != null) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < markers.length) {
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                        if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(model.getMarkerPosition(markers[i]), document)) {
                            breakpoints.add(markers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log((IStatus)x.getStatus());
            }
        }
        return breakpoints;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AspectJBreakpointRulerAction.this.fStatusLine != null) {
                    AspectJBreakpointRulerAction.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }
}

