/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.IStructureViewNode;
import org.aspectj.ajde.ui.StructureView;
import org.aspectj.ajde.ui.StructureViewManager;
import org.aspectj.ajde.ui.StructureViewProperties;
import org.aspectj.ajde.ui.StructureViewRenderer;
import org.aspectj.asm.IProgramElement;
import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNode;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.editor.AspectJLabelProvider;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AspectJContentOutlinePage
extends ContentOutlinePage
implements StructureViewRenderer {
    protected IFile input;
    private static final int RELATIONSHIP_LEVEL = 3;
    private AbstractTextEditor editor;
    private StructureViewProperties viewProperties;
    private StructureViewManager svManager;
    private StructureView view;
    private static String lastLoadedConfigFile = "";
    private boolean outlinePageCreation = true;
    private static List outlinesWithPendingAdviceMarkerUpdates = null;
    private ViewerSorter lexicalSorter;

    public AspectJContentOutlinePage(AbstractTextEditor editor, IFile input) {
        this.input = input;
        this.editor = editor;
        this.svManager = Ajde.getDefault().getStructureViewManager();
        this.viewProperties = this.svManager.getDefaultViewProperties();
        this.viewProperties.setGranularity(StructureViewProperties.Granularity.DECLARED_ELEMENTS);
        this.lexicalSorter = new LexicalSorter();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.configureHelp();
        this.configureContextMenu();
        this.registerToolbarActions();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new AspectJLabelProvider(parent));
        IAdaptable outline = this.getContentOutline(this.input, true);
        viewer.setInput((Object)outline);
        this.expandTreeView();
    }

    public void update() {
        AJDTEventTrace.generalEvent("Editor Update called: " + this.input.getName());
        this.getControl().setRedraw(false);
        IAdaptable outline = this.getContentOutline(this.input, true);
        this.getTreeViewer().setInput((Object)outline);
        this.expandTreeView();
        this.updateAdviceMarkers(true);
        this.getControl().setRedraw(true);
    }

    public void update(StructureView view) {
        if (view != null && this.view != null && !view.toString().equals(this.view.toString())) {
            AJDTEventTrace.generalEvent("Assumption Not True: Old view object:" + view.toString() + "  New view object:" + view.toString());
        }
        this.input.getProject();
        Builder.getLastBuildTarget();
        if (this.input.getProject().equals((Object)Builder.getLastBuildTarget())) {
            AJDTEventTrace.modelUpdated(this.input);
            this.view = view;
            this.getControl().setRedraw(false);
            AJDTStructureViewNode toDisplay = (AJDTStructureViewNode)view.getRootNode();
            this.updateAdviceMarkers(false);
            this.getTreeViewer().setInput((Object)toDisplay);
            this.expandTreeView();
            this.getControl().setRedraw(true);
        }
    }

    public void updateAdviceMarkers(boolean right_now) {
        if (outlinesWithPendingAdviceMarkerUpdates == null) {
            outlinesWithPendingAdviceMarkerUpdates = new ArrayList();
        }
        outlinesWithPendingAdviceMarkerUpdates.add(this);
        if (right_now) {
            AspectJContentOutlinePage.performPendingAdviceMarkerUpdates();
        }
    }

    public static void performPendingAdviceMarkerUpdates() {
        if (outlinesWithPendingAdviceMarkerUpdates == null) {
            return;
        }
        Iterator it = outlinesWithPendingAdviceMarkerUpdates.iterator();
        while (it.hasNext()) {
            AspectJContentOutlinePage page = (AspectJContentOutlinePage)((Object)it.next());
            AJDTStructureViewNode cfr_ignored_0 = (AJDTStructureViewNode)page.view.getRootNode();
            if (!(page.editor instanceof AspectJEditor)) continue;
            if (page.editor.getEditorInput() != null) {
                ((AspectJEditor)page.editor).forceUpdateOfAdviceMarkers();
                continue;
            }
            AJDTEventTrace.generalEvent("INFO message: Compiler made attempt to update outline for a currently (possibly temporarily) non-existent resource: " + page.editor.getTitle());
        }
        outlinesWithPendingAdviceMarkerUpdates = null;
    }

    public void updateView(StructureView view) {
        AJDTEventTrace.generalEvent("outline updateview called (file:" + this.input.getName() + "): " + view.toString());
        final StructureView fView = view;
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    AspectJContentOutlinePage.this.update(fView);
                }
                catch (Throwable throwable) {}
            }
        });
    }

    public void setActiveNode(IStructureViewNode node) {
        TreeViewer viewer = this.getTreeViewer();
        viewer.setInput((Object)((AJDTStructureViewNode)node));
    }

    protected void setInput(IFile input) {
        this.input = input;
    }

    public void dispose() {
        String action = "Unable to unregister with structure view manager";
        if (this.view != null) {
            boolean successfullyUnregistered = this.svManager.deleteView(this.view);
            action = "Unregistering with structure view manager.  Successful:" + successfullyUnregistered;
        }
        AJDTEventTrace.generalEvent("Outline disposed for file " + this.editor.getTitle() + ": " + action);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sSel;
        Object target;
        super.selectionChanged(event);
        if (this.outlinePageCreation) {
            this.outlinePageCreation = false;
            return;
        }
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (target = (sSel = (IStructuredSelection)selection).getFirstElement()) instanceof AJDTStructureViewNode) {
            AJDTStructureViewNode ajdtNode = (AJDTStructureViewNode)target;
            if (this.editor.getEditorInput() instanceof IFileEditorInput) {
                IMarker marker = ajdtNode.getMarker(((IFileEditorInput)this.editor.getEditorInput()).getFile().getProject());
                if (ajdtNode.getStructureNode() != null) {
                    AJDTEventTrace.nodeClicked(ajdtNode.getStructureNode().getName(), marker);
                    if (marker != null) {
                        try {
                            IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker, (boolean)false);
                        }
                        catch (PartInitException ex) {
                            System.err.println("Doh!" + (Object)((Object)ex));
                        }
                    }
                }
            } else {
                AJDTEventTrace.generalEvent("Problem in outline view: Editor input is not a file");
            }
        }
    }

    private IAdaptable getContentOutline(IFile input, boolean registerForUpdates) {
        this.updateActiveConfig();
        String filePath = AJDTUtils.getResourcePath((IResource)input);
        AJDTEventTrace.structureViewRequested(input.getName());
        if (this.view != null) {
            this.svManager.deleteView(this.view);
        }
        FileStructureView structureView = this.svManager.createViewForSourceFile(filePath, this.viewProperties);
        structureView.setRenderer((StructureViewRenderer)this);
        this.view = structureView;
        return (AJDTStructureViewNode)this.view.getRootNode();
    }

    private void updateActiveConfig() {
        IProject project = this.input.getProject();
        String configFile = AspectJUIPlugin.getBuildConfigurationFile(project);
        if (!configFile.equals(lastLoadedConfigFile)) {
            AJDTEventTrace.buildConfigSelected(configFile, project);
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(configFile);
            lastLoadedConfigFile = configFile;
        }
    }

    private void expandTreeView() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.collapseAll();
        Tree t = viewer.getTree();
        TreeItem[] tItems = t.getItems();
        int i = 0;
        while (i < tItems.length) {
            TreeItem item = tItems[i];
            AJDTStructureViewNode node = (AJDTStructureViewNode)item.getData();
            if (node.getStructureNode() instanceof IProgramElement) {
                viewer.expandToLevel((Object)node, 1);
            }
            ++i;
        }
    }

    private void configureHelp() {
    }

    private void configureContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.add((IContributionItem)new Separator("additions-end"));
        TreeViewer viewer = this.getTreeViewer();
        Menu menu = menuMgr.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.ajdt.ui.outline", menuMgr, (ISelectionProvider)viewer);
    }

    public void setActiveNode(IStructureViewNode activeNode, int lineOffset) {
        this.setActiveNode(activeNode);
    }

    private void registerToolbarActions() {
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        if (toolBarManager != null) {
            LexicalSortingAction sortAction = new LexicalSortingAction();
            toolBarManager.add((IAction)sortAction);
            FilterAction fieldAction = new FilterAction(new CategoryFilter(6), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideFields.label"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideFields.description.checked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideFields.description.unchecked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideFields.tooltip.checked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideFields.tooltip.unchecked"), "HideFields.isChecked");
            JavaPluginImages.setLocalImageDescriptors((IAction)fieldAction, (String)"fields_co.gif");
            toolBarManager.add((IAction)fieldAction);
            FilterAction staticAction = new FilterAction(new StaticFilter(), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.label"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.description.checked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.description.unchecked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.tooltip.checked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideStaticMembers.tooltip.unchecked"), "HideStaticMembers.isChecked");
            JavaPluginImages.setLocalImageDescriptors((IAction)staticAction, (String)"static_co.gif");
            toolBarManager.add((IAction)staticAction);
            FilterAction publicAction = new FilterAction(new VisibilityFilter(), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.label"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.description.checked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.description.unchecked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.tooltip.checked"), AspectJUIPlugin.getResourceString("JavaOutlinePage.HideNonePublicMembers.tooltip.unchecked"), "HideNonePublicMembers.isChecked");
            JavaPluginImages.setLocalImageDescriptors((IAction)publicAction, (String)"public_co.gif");
            toolBarManager.add((IAction)publicAction);
            FilterAction pointcutAction = new FilterAction(new CategoryFilter(7), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.label"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.description.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.description.unchecked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.tooltip.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HidePointcuts.tooltip.unchecked"), "HidePointcuts.isChecked");
            pointcutAction.setImageDescriptor(AspectJImages.HIDE_POINTCUTS.getImageDescriptor());
            toolBarManager.add((IAction)pointcutAction);
            FilterAction adviceAction = new FilterAction(new CategoryFilter(9), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideAdvice.label"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideAdvice.description.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideAdvice.description.unchecked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideAdvice.tooltip.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideAdvice.tooltip.unchecked"), "HideAdvice.isChecked");
            adviceAction.setImageDescriptor(AspectJImages.HIDE_ADVICE.getImageDescriptor());
            toolBarManager.add((IAction)adviceAction);
            FilterAction introductionAction = new FilterAction(new CategoryFilter(5), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.label"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.description.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.description.unchecked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.tooltip.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideIntroductions.tooltip.unchecked"), "HideIntroductions.isChecked");
            introductionAction.setImageDescriptor(AspectJImages.HIDE_ITDS.getImageDescriptor());
            toolBarManager.add((IAction)introductionAction);
            FilterAction declarationAction = new FilterAction(new CategoryFilter(8), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.label"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.description.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.description.unchecked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.tooltip.checked"), AspectJUIPlugin.getResourceString("AJavaOutlinePage.HideDeclarations.tooltip.unchecked"), "HideIntroductions.isChecked");
            declarationAction.setImageDescriptor(AspectJImages.HIDE_DECLARATIONS.getImageDescriptor());
            toolBarManager.add((IAction)declarationAction);
        }
    }

    private void setSorting(boolean on) {
        if (on) {
            AJDTEventTrace.outlineViewAction("Sorting Alphabetical order", this.input);
            this.getTreeViewer().setSorter(this.lexicalSorter);
        } else {
            AJDTEventTrace.outlineViewAction("Sorting Declaration order", this.input);
            this.getTreeViewer().setSorter(null);
        }
    }

    private void addFilter(ViewerFilter filter) {
        this.getTreeViewer().addFilter(filter);
        this.expandTreeView();
    }

    private void removeFilter(ViewerFilter filter) {
        this.getTreeViewer().removeFilter(filter);
        this.expandTreeView();
    }

    class LexicalSortingAction
    extends Action {
        public LexicalSortingAction() {
            this.setText(AspectJUIPlugin.getResourceString("JavaOutlinePage.Sort.label"));
            JavaPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
            boolean checked = AspectJUIPlugin.getDefault().getPreferenceStore().getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            AspectJContentOutlinePage.this.setSorting(on);
            this.setToolTipText(on ? AspectJUIPlugin.getResourceString("JavaOutlinePage.Sort.tooltip.checked") : AspectJUIPlugin.getResourceString("JavaOutlinePage.Sort.tooltip.unchecked"));
            this.setDescription(on ? AspectJUIPlugin.getResourceString("JavaOutlinePage.Sort.description.checked") : AspectJUIPlugin.getResourceString("JavaOutlinePage.Sort.description.unchecked"));
            if (store) {
                AspectJUIPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }
    }

    class LexicalSorter
    extends ViewerSorter {
        LexicalSorter() {
        }

        public int category(Object element) {
            if (element instanceof AJDTStructureViewNode) {
                return ((AJDTStructureViewNode)element).category();
            }
            return 0;
        }
    }

    class FilterAction
    extends Action {
        private ViewerFilter fFilter;
        private String fCheckedDesc;
        private String fUncheckedDesc;
        private String fCheckedTooltip;
        private String fUncheckedTooltip;
        private String fPreferenceKey;

        public FilterAction(ViewerFilter filter, String label, String checkedDesc, String uncheckedDesc, String checkedTooltip, String uncheckedTooltip, String prefKey) {
            this.fFilter = filter;
            this.setText(label);
            this.fCheckedDesc = checkedDesc;
            this.fUncheckedDesc = uncheckedDesc;
            this.fCheckedTooltip = checkedTooltip;
            this.fUncheckedTooltip = uncheckedTooltip;
            this.fPreferenceKey = prefKey;
            boolean checked = AspectJUIPlugin.getDefault().getPreferenceStore().getBoolean(this.fPreferenceKey);
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            if (on) {
                AJDTEventTrace.outlineViewAction(this.fUncheckedTooltip, AspectJContentOutlinePage.this.input);
                AspectJContentOutlinePage.this.addFilter(this.fFilter);
                this.setToolTipText(this.fCheckedTooltip);
                this.setDescription(this.fCheckedDesc);
            } else {
                AJDTEventTrace.outlineViewAction(this.fCheckedTooltip, AspectJContentOutlinePage.this.input);
                AspectJContentOutlinePage.this.removeFilter(this.fFilter);
                this.setToolTipText(this.fUncheckedTooltip);
                this.setDescription(this.fUncheckedDesc);
            }
            if (store) {
                AspectJUIPlugin.getDefault().getPreferenceStore().setValue(this.fPreferenceKey, on);
            }
        }
    }

    class VisibilityFilter
    extends ViewerFilter {
        VisibilityFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isPublic = true;
            if (element instanceof AJDTStructureViewNode) {
                isPublic = ((AJDTStructureViewNode)element).isPublic();
            }
            return isPublic;
        }
    }

    class StaticFilter
    extends ViewerFilter {
        StaticFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isNonStatic = true;
            if (element instanceof AJDTStructureViewNode) {
                isNonStatic = !((AJDTStructureViewNode)element).getStructureNode().getModifiers().contains(IProgramElement.Modifiers.STATIC);
            }
            return isNonStatic;
        }
    }

    class CategoryFilter
    extends ViewerFilter {
        private int category;

        public CategoryFilter(int category) {
            this.category = category;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean isNotInCategory = true;
            if (element instanceof AJDTStructureViewNode) {
                int elementCat = ((AJDTStructureViewNode)element).category();
                isNotInCategory = this.category != elementCat;
            }
            return isNotInCategory;
        }
    }
}

