/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AJSourceViewerConfiguration;
import org.eclipse.ajdt.internal.ui.editor.AspectJContentOutlinePage;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.ContextMenuManipulator;
import org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionAssistant;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.javamodel.AJCompilationUnitManager;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.visualiser.NodeHolder;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AspectJEditor
extends CompilationUnitEditor {
    public static final String ASPECTJ_EDITOR_ID = "org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor";
    private AspectJContentOutlinePage contentOutlinePage;
    private AnnotationAccessWrapper annotationAccessWrapper;
    private boolean markersNeedUpdating = true;
    private static Set activeEditorList = new HashSet();
    private IFileEditorInput currentFileInput;
    static Set modifiedAspectToClass = new HashSet();
    private AJSourceViewerConfiguration fAJSourceViewerConfiguration;
    private boolean isEditingAjFile = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getRulerContextMenuId() != null) {
            String id = this.getRulerContextMenuId() != null ? this.getRulerContextMenuId() : "#RulerContext";
            MenuManager manager = new MenuManager(id, id);
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(this.getContextMenuListener());
            Control rulerControl = this.getVerticalRuler().getControl();
            Menu fRulerContextMenu = manager.createContextMenu(rulerControl);
            rulerControl.setMenu(fRulerContextMenu);
            this.getSite().registerContextMenu(this.getRulerContextMenuId(), manager, this.getSelectionProvider());
            manager.addMenuListener((IMenuListener)new ContextMenuManipulator());
        }
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return new AJTextOperationTarget((ITextOperationTarget)super.getAdapter(key));
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz2)) {
            return this.getContentOutlinePage(key);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz3)) {
            Object o = super.getAdapter(key);
            if (o instanceof IAnnotationAccessExtension) {
                if (this.annotationAccessWrapper == null) {
                    this.annotationAccessWrapper = new AnnotationAccessWrapper();
                }
                this.annotationAccessWrapper.setWrapped((IAnnotationAccessExtension)o);
                return this.annotationAccessWrapper;
            }
            return o;
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)"CompilationUnitEditor.error.saving.title1", (String)"CompilationUnitEditor.error.saving.message1");
            }
        } else {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    this.performSave(false, progressMonitor);
                }
            } else {
                this.performSave(false, progressMonitor);
            }
        }
        if (this.contentOutlinePage == null) {
            Object outlinePage;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((outlinePage = this.getContentOutlinePage(clazz)) instanceof AspectJContentOutlinePage) {
                this.contentOutlinePage = (AspectJContentOutlinePage)((Object)outlinePage);
            }
        }
    }

    private Object getContentOutlinePage(Class key) {
        Object outlinePage;
        block7: {
            outlinePage = null;
            if (AspectJPreferences.isAspectJOutlineEnabled()) {
                IEditorInput input = this.getEditorInput();
                if (input instanceof IFileEditorInput) {
                    IFile f = ((IFileEditorInput)input).getFile();
                    IProject p = f.getProject();
                    try {
                        if (p.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                            this.contentOutlinePage = new AspectJContentOutlinePage((AbstractTextEditor)this, f);
                            outlinePage = this.contentOutlinePage;
                            break block7;
                        }
                        outlinePage = super.getAdapter(key);
                    }
                    catch (CoreException coreException) {
                        outlinePage = super.getAdapter(key);
                    }
                } else {
                    outlinePage = super.getAdapter(key);
                }
            } else {
                outlinePage = super.getAdapter(key);
            }
        }
        return outlinePage;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        SourceViewerConfiguration myConf = this.getSourceViewerConfiguration();
        if (myConf != null && myConf instanceof AJSourceViewerConfiguration && !(configuration instanceof AJSourceViewerConfiguration)) {
            return;
        }
        super.setSourceViewerConfiguration(configuration);
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof IFileEditorInput) {
            AJCompilationUnit unit;
            IFileEditorInput fInput = (IFileEditorInput)input;
            if (ProjectProperties.ASPECTJ_SOURCE_ONLY_FILTER.accept(fInput.getFile().getName()) && (unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache(fInput.getFile())) != null) {
                this.isEditingAjFile = true;
                unit.becomeWorkingCopy(null, null);
                ((IWorkingCopyManagerExtension)JavaPlugin.getDefault().getWorkingCopyManager()).setWorkingCopy(input, (ICompilationUnit)unit);
            }
            if (this.currentFileInput != null) {
                this.removeAJDTMarkers(this.currentFileInput);
            }
            this.currentFileInput = fInput;
            AJDTEventTrace.editorOpened(fInput.getFile());
            this.updateAdviceMarkers(fInput);
            activeEditorList.add(this);
            IDocument document = this.getDocumentProvider().getDocument((Object)fInput);
            AspectJTextTools textTools = AspectJUIPlugin.getDefault().getAspectJTextTools();
            textTools.setupJavaDocumentPartitioner(document, "___java_partitioning");
            if (this.contentOutlinePage != null) {
                this.contentOutlinePage.setInput(fInput.getFile());
                this.contentOutlinePage.update();
            }
            if ("aj".equals(fInput.getFile().getFileExtension())) {
                JavaPlugin.getDefault().getWorkingCopyManager().connect(input);
            }
        }
    }

    public void forceUpdateOfAdviceMarkers() {
        this.markersNeedUpdating = true;
        this.updateAdviceMarkers((IFileEditorInput)this.getEditorInput());
    }

    public void updateAdviceMarkers(final IFileEditorInput fInput) {
        if (!this.markersNeedUpdating) {
            return;
        }
        if (fInput == null) {
            AJDTEventTrace.generalEvent("AspectJEditor: FileEditorInput is null for editor with title (" + this.getTitle() + "): Cannot update markers on it");
            return;
        }
        if (fInput.getFile() == null) {
            AJDTEventTrace.generalEvent("AspectJEditor: fileeditorinput.getFile() is null: see bugzilla #43662");
            return;
        }
        this.removeAJDTMarkers(fInput);
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AspectJEditor.this.addNewMarkers(fInput);
            }
        });
    }

    private void removeAJDTMarkers(final IFileEditorInput fInput) {
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            public void run() {
                block2: {
                    try {
                        fInput.getFile().deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                        fInput.getFile().deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                    }
                    catch (CoreException ce) {
                        if (!fInput.getFile().exists()) break block2;
                        AspectJUIPlugin.getDefault().getErrorHandler().handleError("Advice marker delete failed", ce);
                    }
                }
            }
        });
    }

    private void addNewMarkers(final IFileEditorInput fInput) {
        IProject project = fInput.getFile().getProject();
        try {
            if (project == null || !project.isOpen() || !project.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return;
            }
        }
        catch (CoreException coreException) {}
        String path = fInput.getFile().getRawLocation().toOSString();
        Map m = StructureModelUtil.getLinesToAspectMap(path, true);
        if (m != null) {
            Set keys = m.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                final Integer linenumberInt = (Integer)o;
                final Vector v = (Vector)m.get(o);
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            boolean sameType = true;
                            boolean runtimeTst = false;
                            NodeHolder cfr_ignored_0 = (NodeHolder)v.get(0);
                            if (v.size() > 1) {
                                NodeHolder first = (NodeHolder)v.get(0);
                                String adviceType = first.node.getExtraInfo() == null ? null : first.node.getExtraInfo().getExtraAdviceInformation();
                                Iterator iter = v.iterator();
                                while (iter.hasNext()) {
                                    NodeHolder element = (NodeHolder)iter.next();
                                    boolean bl = runtimeTst = runtimeTst || element.runtimeTest;
                                    if (adviceType != null) {
                                        if (element.node.getExtraInfo() == null) {
                                            sameType = false;
                                            continue;
                                        }
                                        sameType = sameType && adviceType.equals(element.node.getExtraInfo().getExtraAdviceInformation());
                                        continue;
                                    }
                                    boolean bl2 = sameType = sameType && element.node.getExtraInfo() == null;
                                }
                            } else if (v.size() == 1) {
                                runtimeTst = ((NodeHolder)v.get((int)0)).runtimeTest;
                            }
                            boolean runtimeTest = runtimeTst;
                            boolean useDefaultAdviceMarker = !sameType;
                            int j = 0;
                            while (j < v.size()) {
                                NodeHolder noddyHolder = (NodeHolder)v.get(j);
                                IProgramElement sn = noddyHolder.node;
                                IResource ir = (IResource)fInput.getFile();
                                sn.getSourceLocation();
                                sn.toLinkLabelString();
                                sn.getName();
                                IMarker marker = AspectJEditor.this.createMarker(linenumberInt, runtimeTest, ir, sn, useDefaultAdviceMarker, noddyHolder.runtimeTest);
                                ISourceLocation sLoc2 = sn.getSourceLocation();
                                marker.setAttribute("priority", 2);
                                marker.setAttribute("sourceLocationOfAdvice", (Object)(String.valueOf(sLoc2.getSourceFile().getAbsolutePath()) + ":::" + sLoc2.getLine() + ":::" + sLoc2.getEndLine() + ":::" + sLoc2.getColumn()));
                                ++j;
                            }
                        }
                        catch (CoreException ce) {
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception creating advice marker", ce);
                        }
                    }
                };
                try {
                    AspectJUIPlugin.getWorkspace().run(r, null);
                }
                catch (CoreException cEx) {
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("AJDT Error adding advice markers", cEx);
                }
            }
        }
        this.markersNeedUpdating = false;
    }

    public void dispose() {
        AJDTEventTrace.generalEvent("Disposing editor for:" + this.getTitle());
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AJDTEventTrace.editorClosed(fInput.getFile());
            activeEditorList.remove((Object)this);
            try {
                AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache(fInput.getFile());
                if (unit != null) {
                    unit.discardWorkingCopy();
                }
            }
            catch (JavaModelException e) {
                AspectJUIPlugin.logException(e);
            }
        }
        this.removeAJDTMarkers(this.currentFileInput);
        super.dispose();
    }

    public static void forceEditorUpdates(final IProject project) {
        final Iterator editorIter = activeEditorList.iterator();
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    while (true) {
                        IFileEditorInput ifei;
                        if (!editorIter.hasNext()) {
                            return;
                        }
                        AspectJEditor ajed = (AspectJEditor)((Object)editorIter.next());
                        IEditorInput iei = ajed.getEditorInput();
                        boolean updateThisEditor = true;
                        if (project != null && iei instanceof IFileEditorInput && !(ifei = (IFileEditorInput)iei).getFile().getProject().getName().equals(project.getName())) {
                            updateThisEditor = false;
                        }
                        if (!updateThisEditor) continue;
                        AJDTEventTrace.generalEvent("Forcing update of outline page for editor: " + ajed.getEditorInput().getName());
                        try {
                            ajed.contentOutlinePage.update();
                        }
                        catch (Throwable t) {
                            AJDTEventTrace.generalEvent("Unexpected exception updating editor outline " + t.toString());
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public void setFocus() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AspectJUIPlugin.getDefault().setCurrentProject(fInput.getFile().getProject());
            this.updateAdviceMarkers(fInput);
        }
        super.setFocus();
    }

    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.getPreferenceStore();
        AspectJTextTools textTools = new AspectJTextTools(store);
        this.fAJSourceViewerConfiguration = new AJSourceViewerConfiguration(textTools, this, "___java_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fAJSourceViewerConfiguration);
    }

    private IMarker createMarker(Integer linenumberInt, boolean runtimeTest, IResource ir, IProgramElement programElement, boolean useDefaultAdviceMarker, boolean nodeRuntimeTest) throws CoreException {
        String label = programElement.toLinkLabelString();
        String adviceType = "";
        if (programElement.getExtraInfo() != null) {
            adviceType = programElement.getExtraInfo().getExtraAdviceInformation();
        }
        IMarker marker = useDefaultAdviceMarker ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicadvicemarker") : (adviceType == "" ? ir.createMarker("org.eclipse.ajdt.ui.declarationmarker") : ir.createMarker("org.eclipse.ajdt.ui.advicemarker"))) : (adviceType.equals("before") ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicbeforeadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.beforeadvicemarker")) : (adviceType.equals("around") ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicaroundadvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.aroundadvicemarker")) : (adviceType.startsWith("after") ? (runtimeTest ? ir.createMarker("org.eclipse.ajdt.ui.dynamicafteradvicemarker") : ir.createMarker("org.eclipse.ajdt.ui.afteradvicemarker")) : ir.createMarker("org.eclipse.ajdt.ui.itdmarker"))));
        marker.setAttribute("lineNumber", linenumberInt.intValue());
        if (nodeRuntimeTest) {
            label = String.valueOf(label) + " " + AspectJUIPlugin.getResourceString("AspectJEditor.runtimetest");
        }
        marker.setAttribute("message", (Object)label);
        return marker;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.isEditingAjFile) {
            menu.remove("org.eclipse.jdt.ui.refactoring.menu");
            IContributionItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if ("group.open".equals(item.getId())) {
                    menu.remove(items[i + 2]);
                    menu.remove(items[i + 3]);
                    break;
                }
                ++i;
            }
        }
    }

    private class AJTextOperationTarget
    implements ITextOperationTarget {
        private ITextOperationTarget parent;
        private JavaCorrectionAssistant fCorrectionAssistant;

        public AJTextOperationTarget(ITextOperationTarget parent) {
            this.parent = parent;
        }

        public boolean canDoOperation(int operation) {
            return this.parent.canDoOperation(operation);
        }

        public void doOperation(int operation) {
            if (operation == 50) {
                if (this.fCorrectionAssistant == null) {
                    this.fCorrectionAssistant = new JavaCorrectionAssistant((ITextEditor)AspectJEditor.this);
                    this.fCorrectionAssistant.install((ITextViewer)AspectJEditor.this.getSourceViewer());
                }
                String msg = this.fCorrectionAssistant.showPossibleCompletions();
                AspectJEditor.this.setStatusLineErrorMessage(msg);
            } else {
                this.parent.doOperation(operation);
            }
        }
    }

    class AnnotationAccessWrapper
    implements IAnnotationAccessExtension {
        private IAnnotationAccessExtension wrapped;

        AnnotationAccessWrapper() {
        }

        public void setWrapped(IAnnotationAccessExtension w) {
            this.wrapped = w;
        }

        public String getTypeLabel(Annotation annotation) {
            return this.wrapped.getTypeLabel(annotation);
        }

        public int getLayer(Annotation annotation) {
            int x = this.wrapped.getLayer(annotation);
            if ("org.eclipse.jdt.ui.overrideIndicator".equals(annotation.getType())) {
                x += 2;
            }
            return x;
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            this.wrapped.paint(annotation, gc, canvas, bounds);
        }

        public boolean isPaintable(Annotation annotation) {
            return this.wrapped.isPaintable(annotation);
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            return this.wrapped.isSubtype(annotationType, potentialSupertype);
        }

        public Object[] getSupertypes(Object annotationType) {
            return this.wrapped.getSupertypes(annotationType);
        }
    }
}

