/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.BuildConfigModel;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.bridge.IMessage;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AJDTIcon;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class BuildConfigEditor
extends EditorPart
implements SelectionListener {
    boolean isDirty = false;
    private Tree tree = null;
    BuildConfigModel model = null;
    IFileEditorInput fileInput;
    private Hashtable nodeMap;
    ImageDescriptor compilationUnitImgDesc;
    ImageDescriptor directoryImgDesc;
    private static Hashtable reusableImageMap;

    public void widgetDefaultSelected(SelectionEvent e) {
        TreeItem ti = (TreeItem)e.item;
        BuildConfigNode node = (BuildConfigNode)ti.getData();
        if (node != null && node.getBuildConfigNodeKind() == BuildConfigNode.Kind.FILE_LST) {
            String relativePath = node.getResourcePath();
            IFile file = this.fileInput.getFile().getProject().getFile(relativePath);
            if (file != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (boolean)true);
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
            }
        } else {
            this.widgetSelected(e);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if ((e.detail & 0x20) > 0) {
            TreeItem ti = (TreeItem)e.item;
            boolean checked = ti.getChecked();
            this.setTreeNodeStatus(ti, checked);
            this.ensureTreeCheckboxConsistency((Widget)this.tree);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        Ajde.getDefault().getConfigurationManager().writeModel(this.model);
        this.clearDirty();
        try {
            this.fileInput.getFile().refreshLocal(0, monitor);
        }
        catch (CoreException cEx) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Failed to update lst file resource", cEx);
        }
        this.clearMarkers(this.fileInput);
        this.buildModel(this.fileInput);
        CompilerMonitor.showOutstandingProblems();
        this.tree.removeAll();
        this.populateTree();
    }

    public void doSaveAs() {
        this.doSave(null);
    }

    public void gotoMarker(IMarker marker) {
        try {
            TreeItem tItem;
            Integer lineNumber = (Integer)marker.getAttribute("lineNumber");
            String sourceFile = AJDTUtils.getResourcePath(marker.getResource());
            BuildConfigNode node = this.model.findNodeForSourceLine(sourceFile, lineNumber.intValue());
            if (node != null && (tItem = (TreeItem)this.nodeMap.get(node)) != null) {
                TreeItem[] selectionTarget = new TreeItem[]{tItem};
                this.tree.setSelection(selectionTarget);
            }
        }
        catch (CoreException cEx) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Unable to go to marker", cEx);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setContentDescription(input.getName());
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("InvalidInput");
        }
        this.fileInput = (IFileEditorInput)input;
        this.isDirty = false;
        this.clearMarkers(this.fileInput);
        this.buildModel(this.fileInput);
        CompilerMonitor.showOutstandingProblems();
        AJDTEventTrace.editorOpened(this.fileInput.getFile());
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 96);
        this.tree.addSelectionListener((SelectionListener)this);
        this.populateTree();
    }

    public void setFocus() {
        this.tree.setFocus();
    }

    public void dispose() {
        AJDTEventTrace.editorClosed(this.fileInput.getFile());
        super.dispose();
    }

    private void clearMarkers(IFileEditorInput input) {
        try {
            ((IResource)input.getFile()).deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(e.getMessage(), e);
        }
    }

    private void buildModel(IFileEditorInput input) {
        String filePath = input.getFile().getLocation().toOSString();
        this.nodeMap = new Hashtable();
        this.model = Ajde.getDefault().getConfigurationManager().buildModel(filePath);
    }

    private void populateTree() {
        if (this.model != null) {
            this.populateBranch((Widget)this.tree, this.model.getRoot());
            this.ensureTreeCheckboxConsistency((Widget)this.tree);
        }
    }

    private void populateBranch(Widget parent, BuildConfigNode node) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode childNode = (BuildConfigNode)it.next();
            TreeItem tItem = parent instanceof Tree ? new TreeItem((Tree)parent, 0) : new TreeItem((TreeItem)parent, 0);
            tItem.setImage(this.createNodeImage(childNode));
            tItem.setText(childNode.getName());
            tItem.setData((Object)childNode);
            tItem.setChecked(childNode.isActive());
            tItem.setExpanded(true);
            this.nodeMap.put(childNode, tItem);
            this.populateBranch((Widget)tItem, childNode);
        }
    }

    private boolean ensureTreeCheckboxConsistency(Widget where) {
        boolean oneselected = false;
        if (where instanceof TreeItem) {
            TreeItem ti = (TreeItem)where;
            TreeItem[] tis = ti.getItems();
            oneselected = false;
            boolean graychildren = false;
            int count = 0;
            int i = 0;
            while (i < tis.length) {
                if (this.ensureTreeCheckboxConsistency((Widget)tis[i])) {
                    ti.setChecked(true);
                    ti.setExpanded(true);
                    oneselected = true;
                    if (tis[i].getGrayed()) {
                        graychildren = true;
                    }
                    ++count;
                }
                ++i;
            }
            if (oneselected) {
                if (count != tis.length || graychildren) {
                    ti.setGrayed(true);
                } else {
                    ti.setGrayed(false);
                }
            }
            if (count == 0 && tis.length != 0) {
                ti.setChecked(false);
                ti.setGrayed(false);
                ti.setExpanded(false);
            }
            return oneselected || ti.getChecked();
        }
        TreeItem[] tis = ((Tree)where).getItems();
        int i = 0;
        while (i < tis.length) {
            this.ensureTreeCheckboxConsistency((Widget)tis[i]);
            ++i;
        }
        return false;
    }

    private void setTreeNodeStatus(TreeItem item, boolean include) {
        BuildConfigNode node = (BuildConfigNode)item.getData();
        if (include) {
            this.includeNodeInConfig(node);
        } else {
            this.excludeNodeFromConfig(node);
        }
        TreeItem[] children = item.getItems();
        int i = 0;
        while (i < children.length) {
            children[i].setChecked(include);
            this.setTreeNodeStatus(children[i], include);
            ++i;
        }
    }

    private void setDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    private void clearDirty() {
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    private void includeNodeInConfig(BuildConfigNode node) {
        if (!node.isActive()) {
            node.setActive(true);
            this.setDirty();
        }
    }

    private void excludeNodeFromConfig(BuildConfigNode node) {
        if (node.isActive()) {
            node.setActive(false);
            this.setDirty();
        }
    }

    private Image createNodeImage(BuildConfigNode node) {
        BuildConfigNode.Kind kind = node.getBuildConfigNodeKind();
        int overlayFlags = 0;
        if (kind == BuildConfigNode.Kind.ERROR) {
            overlayFlags = 64;
        }
        List linkedsrcfolders = this.getLinkedSourceFolders();
        IMessage sMessage = node.getMessage();
        if (sMessage != null) {
            if (sMessage.getKind() == IMessage.ERROR) {
                overlayFlags = 64;
            } else if (sMessage.getKind() == IMessage.WARNING) {
                overlayFlags = 32;
            }
        }
        String nodename = node.getName();
        if (overlayFlags != 0 && nodename.startsWith("Use relative paths only, omitting: ")) {
            String realLocation = node.getName().substring("Use relative paths only, omitting: ".length());
            realLocation = realLocation.replace('/', File.separatorChar);
            realLocation = realLocation.replace('\\', File.separatorChar);
            Iterator fldr = linkedsrcfolders.iterator();
            while (fldr.hasNext()) {
                String element = (String)fldr.next();
                element = element.replace('/', File.separatorChar);
                if (!realLocation.startsWith(element = element.replace('\\', File.separatorChar))) continue;
                node.setName("Resource from linked source folder: " + realLocation);
                overlayFlags = 0;
            }
        }
        String key = new String(String.valueOf(kind.toString()) + ":::" + overlayFlags);
        if (reusableImageMap == null) {
            reusableImageMap = new Hashtable();
        }
        if (reusableImageMap.get(key) != null) {
            return (Image)reusableImageMap.get(key);
        }
        AJDTIcon icon = (AJDTIcon)AspectJImages.registry().getIcon(kind);
        ImageDescriptor baseDescriptor = icon.getImageDescriptor();
        Image newImage = AJDTUtils.decorate(baseDescriptor, overlayFlags).createImage();
        reusableImageMap.put(key, newImage);
        return newImage;
    }

    public List getLinkedSourceFolders() {
        ArrayList<String> linkedSourceFolders = new ArrayList<String>();
        IProject proj = this.fileInput.getFile().getProject();
        IJavaProject jProject = JavaCore.create((IProject)proj);
        try {
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    IClasspathEntry sourceEntry = classpathEntries[i];
                    IPath sourcePath = sourceEntry.getPath();
                    sourcePath = sourcePath.removeFirstSegments(1);
                    IResource[] srcContainer = new IResource[]{proj.findMember(sourcePath)};
                    linkedSourceFolders.add(srcContainer[0].getLocation().toOSString());
                }
                ++i;
            }
        }
        catch (JavaModelException jmEx) {
            jmEx.printStackTrace();
        }
        return linkedSourceFolders;
    }
}

