/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.core.resources.AspectJImages;
import org.eclipse.ajdt.internal.ui.wizards.AspectJWizardNewProjectCreationPage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class AspectJProjectWizard
extends BasicNewProjectResourceWizard
implements IExecutableExtension {
    protected NewJavaProjectWizardPage fJavaPage;
    protected AspectJWizardNewProjectCreationPage fMainPage;
    private IConfigurationElement fConfigElement;

    public AspectJProjectWizard() {
        this.setDefaultPageImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.setDialogSettings(AspectJUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.title"));
    }

    public void addPages() {
        this.fMainPage = new AspectJWizardNewProjectCreationPage("NewAspectjProjectCreationWizard");
        this.fMainPage.setTitle(AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.title"));
        this.fMainPage.setDescription(AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.description"));
        this.fMainPage.setImageDescriptor(AspectJImages.W_NEW_AJ_PRJ.getImageDescriptor());
        this.addPage((IWizardPage)this.fMainPage);
        IWorkspaceRoot root = AspectJUIPlugin.getWorkspace().getRoot();
        this.fJavaPage = new NewJavaProjectWizardPage(root, (WizardNewProjectCreationPage)this.fMainPage);
        this.addPage((IWizardPage)this.fJavaPage);
    }

    public boolean performFinish() {
        IProject project = this.fJavaPage.getNewJavaProject().getProject();
        boolean useExisting = this.fMainPage.useExistingProjectStructure();
        if (!useExisting) {
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fJavaPage.getRunnable());
            try {
                this.getContainer().run(false, true, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                String title = AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.title");
                String message = AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.message");
                ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            project = this.fJavaPage.getNewJavaProject().getProject();
        } else {
            if (!this.fMainPage.hasCorrectCapitalisation()) {
                IWorkspaceRoot root = AspectJUIPlugin.getWorkspace().getRoot();
                AspectJWizardNewProjectCreationPage TempMainPage = new AspectJWizardNewProjectCreationPage("NewAspectjProjectCreationWizard");
                TempMainPage.setInitialProjectName(this.fMainPage.getCorrectCapitalization());
                NewJavaProjectWizardPage TempJavaPage = new NewJavaProjectWizardPage(root, (WizardNewProjectCreationPage)TempMainPage);
                project = TempJavaPage.getNewJavaProject().getProject();
                this.fMainPage.setPageComplete(false);
                this.fJavaPage.setPageComplete(false);
            }
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                project.create((IProgressMonitor)monitor);
                project.open((IProgressMonitor)monitor);
            }
            catch (CoreException e) {
                String title = AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.build_error.title");
                String message = AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.build_error.message");
                ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)title, (String)message);
                return false;
            }
        }
        boolean completed = this.finalizeNewProject(project, useExisting);
        return completed;
    }

    private boolean finalizeNewProject(IProject project, boolean alreadyExists) {
        final IProject thisProject = project;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            if (!alreadyExists) {
                AJDTUtils.addAspectJNature(project);
            } else {
                dialog.run(true, true, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        monitor.beginTask("", 2);
                        try {
                            try {
                                monitor.setTaskName(AspectJUIPlugin.getResourceString("OptionsConfigurationBlock.buildproject.taskname"));
                                thisProject.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }
                            catch (CoreException e) {
                                System.err.println("Failed initial Java build of new project " + thisProject.getName() + " : " + (Object)((Object)e));
                                AspectJUIPlugin.getDefault().getLog().log(e.getStatus());
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var3_5 = null;
                        }
                        monitor.done();
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            String title = AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.title");
            String message = AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.op_error.message");
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (CoreException e) {
            AspectJUIPlugin.logException(e);
        }
        project = thisProject;
        AspectJUIPlugin.getDefault().setCurrentProject(project);
        this.selectAndReveal((IResource)project);
        AJDTEventTrace.newProjectCreated(project);
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }
}

